/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megafon.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonProduct;

public class MegafonProductDao
extends AbstractIdDao<MegafonProduct> {
    public MegafonProductDao(Connection con, int moduleId) {
        super(con, "megafon_product", moduleId);
    }

    public List<MegafonProduct> list(String filter, String orderBy, Object ... params) throws SQLException {
        return super.list(filter, orderBy, params);
    }

    protected MegafonProduct getFromRS(ResultSet rs) throws SQLException {
        MegafonProduct product = new MegafonProduct();
        product.setId(rs.getInt("id"));
        product.setTitle(rs.getString("title"));
        product.setProductOfferingId(rs.getString("product_offering_id"));
        product.setOptionKitId(rs.getInt("option_kit_id"));
        product.setNpayServiceId(rs.getInt("npay_service_id"));
        product.setPrice(rs.getInt("price"));
        product.setTariffLabelId(rs.getInt("tariff_label_id"));
        return product;
    }

    protected void updateImpl(MegafonProduct product) throws SQLException {
        String query = (product.getId() > 0 ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET title=?, product_offering_id=?, option_kit_id=?, npay_service_id=?, price=?, tariff_label_id=?" + (product.getId() > 0 ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, product.getTitle());
            ps.setString(2, product.getProductOfferingId());
            ps.setInt(3, product.getOptionKitId());
            ps.setInt(4, product.getNpayServiceId());
            ps.setInt(5, product.getPrice());
            ps.setInt(6, product.getTariffLabelId());
            if (product.getId() > 0) {
                ps.setInt(7, product.getId());
            }
            ps.executeUpdate();
        }
    }
}

