/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megafon.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariff;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractTariffService;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Reserve;
import ru.bitel.bgbilling.kernel.contract.balance.common.service.ReserveService;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffPlan;
import ru.bitel.bgbilling.kernel.tariff.common.service.TariffService;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonContractOption;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonContractProduct;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonContractProductHistory;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonContractProductStatus;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonOption;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonOptionType;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonProduct;
import ru.bitel.bgbilling.modules.megafon.common.service.MegafonContractService;
import ru.bitel.bgbilling.modules.megafon.common.service.MegafonService;
import ru.bitel.bgbilling.modules.megafon.server.MegafonCheckOrderStatus;
import ru.bitel.bgbilling.modules.megafon.server.api.MegafonApiClient;
import ru.bitel.bgbilling.modules.megafon.server.bean.MegafonContractOptionDao;
import ru.bitel.bgbilling.modules.megafon.server.bean.MegafonContractProductDao;
import ru.bitel.bgbilling.modules.megafon.server.bean.MegafonContractProductHistoryDao;
import ru.bitel.bgbilling.modules.megafon.server.bean.MegafonOptionDao;
import ru.bitel.bgbilling.modules.megafon.server.utils.MegafonUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.Result;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.megafon.common.service.MegafonContractService")
public class MegafonContractServiceImpl
extends AbstractService
implements MegafonContractService {
    private MegafonContractProductDao contractProductDao;
    private MegafonContractProductHistoryDao productHistoryDao;
    private MegafonContractOptionDao contractOptionDao;

    @PostConstruct
    public void init() {
        this.contractProductDao = new MegafonContractProductDao(this.getConnection(), this.moduleId);
        this.productHistoryDao = new MegafonContractProductHistoryDao(this.getConnection(), this.moduleId);
        this.contractOptionDao = new MegafonContractOptionDao(this.getConnection(), this.moduleId);
    }

    public SearchResult<MegafonContractProduct> getContractProductList(Page page, int contractId, MegafonContractProductStatus status) throws Exception {
        if (page == null) {
            page = new Page();
        }
        ArrayList<String> conditions = new ArrayList<String>();
        ArrayList<Integer> parameters = new ArrayList<Integer>();
        if (contractId > 0) {
            conditions.add("contract_id = ?");
            parameters.add(contractId);
        }
        if (status != null) {
            conditions.add("status = ?");
            parameters.add(status.ordinal());
        }
        String where = conditions.isEmpty() ? "" : String.join((CharSequence)" AND ", conditions);
        Result<MegafonContractProduct> result = this.contractProductDao.list(page, where, "id", parameters.toArray());
        return new SearchResult(result.getPage()).setList(result.getList());
    }

    public boolean checkActiveProductOnContracts(int productId) throws Exception {
        return !this.contractProductDao.list(new Page(), "product_id=? AND status=?", "id", productId, MegafonContractProductStatus.ACTIVE.ordinal()).getList().isEmpty();
    }

    public SearchResult<MegafonContractProductHistory> getHistoryList(Page page, int contractId, String msisdn, int productId, String productTitle, Period period) throws Exception {
        ArrayList<Object> parameters = new ArrayList<Object>();
        ArrayList<String> conditions = new ArrayList<String>();
        if (contractId > 0) {
            conditions.add("contract_id=?");
            parameters.add(contractId);
        }
        if (Utils.notBlankString((String)msisdn)) {
            conditions.add("msisdn=?");
            parameters.add(msisdn);
        }
        if (productId > 0) {
            conditions.add("product_id=?");
            parameters.add(productId);
        }
        if (period != null) {
            if (period.getDateFrom() != null) {
                conditions.add("date_from>=?");
                parameters.add(period.getDateFrom());
            }
            if (period.getDateTo() != null) {
                conditions.add("date_to<=?");
                parameters.add(period.getDateTo());
            }
        }
        if (Utils.notBlankString((String)productTitle)) {
            conditions.add("product_title LIKE ?");
            parameters.add("%" + productTitle + "%");
        }
        String whereClause = "";
        if (!conditions.isEmpty()) {
            whereClause = String.join((CharSequence)" AND ", conditions);
        }
        if (page == null) {
            page = new Page();
        }
        Result<MegafonContractProductHistory> result = this.productHistoryDao.list(page, whereClause, "id", parameters.toArray());
        return new SearchResult(result.getPage()).setList(result.getList());
    }

    public boolean checkAllowActivateProduct(MegafonContractProduct contractProduct) throws Exception {
        if (contractProduct.getStartTime() == null) {
            throw new BGException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u0434\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435!");
        }
        if (Utils.isBlankString((String)contractProduct.getMsisdn())) {
            throw new BGException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440: msisdn");
        }
        if (contractProduct.getTariffId() <= 0) {
            throw new BGException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u0442\u0430\u0440\u0438\u0444!");
        }
        MegafonService megafonService = (MegafonService)this.context.getService(MegafonService.class, this.context.getModuleId());
        MegafonProduct product = megafonService.getProduct(contractProduct.getProductId());
        if (product == null) {
            throw new BGException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u0440\u043e\u0434\u0443\u043a\u0442 \u0441 ID = " + contractProduct.getProductId());
        }
        MegafonApiClient apiClient = new MegafonApiClient(this.context.getModuleId());
        this.checkAlreadyActivatedProduct(apiClient, contractProduct, product.getProductOfferingId());
        if (!this.allowBalance(new BigDecimal(product.getPrice()), contractProduct.getContractId())) {
            throw new RuntimeException(String.format("\u041d\u0435 \u0445\u0432\u0430\u0442\u0430\u0435\u0442 \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0434\u043b\u044f \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435 CID=%s. \u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 ID:%s = %s.", contractProduct.getContractId(), product.getId(), product.getPrice()));
        }
        return apiClient.checkActivateProduct(MegafonUtils.defineCorrectMSISDN(contractProduct), product.getProductOfferingId(), contractProduct.getStartTime());
    }

    private void checkAlreadyActivatedProduct(MegafonApiClient apiClient, MegafonContractProduct contractProduct, String uuid) {
        JSONObject filters = new JSONObject();
        filters.put("productCategoryIds", 1);
        filters.put("productStatusIds", MegafonContractProductStatus.ACTIVE.getStatus());
        filters.put("showAllowanceBalance", true);
        filters.put("fields", (Object)"productId,productOfferingId,allowances(allowanceBalances),productOfferingName,status");
        JSONArray tariffs = apiClient.getTariffInfo(MegafonUtils.defineCorrectMSISDN(contractProduct), filters);
        for (int i = 0; i < tariffs.length(); ++i) {
            JSONObject tariff = tariffs.optJSONObject(i);
            long productOfferingId = tariff.optLong("productOfferingId");
            if (productOfferingId != Utils.parseLong((String)uuid)) continue;
            JSONArray allowances = tariff.getJSONArray("allowances");
            for (int j = 0; j < allowances.length(); ++j) {
                JSONObject allowance = allowances.getJSONObject(j);
                JSONArray allowanceBalances = allowance.getJSONArray("allowanceBalances");
                for (int k = 0; k < allowanceBalances.length(); ++k) {
                    JSONObject volumeStatus;
                    JSONObject balance = allowanceBalances.getJSONObject(k);
                    if (!balance.has("volumeStatus") || balance.isNull("volumeStatus") || !(volumeStatus = balance.getJSONObject("volumeStatus")).has("volumeStatusId") || volumeStatus.getInt("volumeStatusId") != 2) continue;
                    throw new RuntimeException(String.format("\u041d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435 = %s \u0443\u0436\u0435 \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d \u043f\u0440\u043e\u0434\u0443\u043a\u0442 \u0441 productOfferingId = %s", contractProduct.getContractId(), uuid));
                }
            }
        }
    }

    public void contractProductUpdate(MegafonContractProduct contractProduct) throws Exception {
        LocalDateTime startDate = contractProduct.getStartTime();
        if (startDate == null) {
            throw new BGException("\u0414\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u043f\u0435\u0440\u0438\u043e\u0434\u0430 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430!");
        }
        if (!contractProduct.getStartTime().toLocalDate().isBefore(LocalDate.now())) {
            throw new BGException("\u0414\u0430\u0442\u0430 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0432 \u043f\u0440\u043e\u0448\u043b\u043e\u043c!");
        }
        this.contractProductDao.update(contractProduct);
    }

    public void productActivateRequest(MegafonContractProduct megafonContractProduct) throws Exception {
        if (megafonContractProduct.getStatus() != null && megafonContractProduct.getStatus() != MegafonContractProductStatus.INACTIVE) {
            throw new RuntimeException("\u0414\u043b\u044f \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u0441\u0442\u0430\u0442\u0443\u0441 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \"\u041d\u0435\u0430\u043a\u0442\u0438\u0432\u0435\u043d\"!");
        }
        if (megafonContractProduct.getTariffId() <= 0) {
            throw new RuntimeException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u0442\u0430\u0440\u0438\u0444!");
        }
        MegafonService megafonService = (MegafonService)this.context.getService(MegafonService.class, this.context.getModuleId());
        MegafonProduct product = megafonService.getProduct(megafonContractProduct.getProductId());
        if (product == null) {
            throw new RuntimeException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u0440\u043e\u0434\u0443\u043a\u0442 \u0441 ID = " + megafonContractProduct.getProductId());
        }
        LocalDate now = LocalDate.now();
        if (megafonContractProduct.getStartTime() == null || megafonContractProduct.getStartTime().toLocalDate().isBefore(now)) {
            throw new RuntimeException("\u0414\u0430\u0442\u0430 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u0438 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0432 \u043f\u0440\u043e\u0448\u043b\u043e\u043c!");
        }
        if (megafonContractProduct.getStartTime().toLocalDate().isAfter(now)) {
            this.contractProductDao.update(megafonContractProduct);
            return;
        }
        if (!this.allowBalance(MegafonUtils.defineCorrectProductPrice(new BigDecimal(product.getPrice())), megafonContractProduct.getContractId())) {
            throw new RuntimeException(String.format("\u041d\u0435 \u0445\u0432\u0430\u0442\u0430\u0435\u0442 \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0434\u043b\u044f \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435 CID=%s. \u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 ID:%s = %s.", megafonContractProduct.getContractId(), product.getId(), product.getPrice()));
        }
        String msisdn = MegafonUtils.defineCorrectMSISDN(megafonContractProduct);
        MegafonApiClient megafonClient = new MegafonApiClient(this.context.getModuleId());
        int activateResult = megafonClient.activateSim(megafonContractProduct.getContractId(), msisdn);
        if (activateResult == 1) {
            this.getLogger().info("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0440\u0430\u0441\u0445\u043e\u0434\u0430 \u0437\u0430 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044e \u0441\u0438\u043c \u043a\u0430\u0440\u0442\u044b \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440={}", (Object)megafonContractProduct.getContractId());
            MegafonUtils.contractAddCharge(this.context, this.getModuleSetup(), megafonContractProduct.getContractId(), new BigDecimal(150), "\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u0441\u0438\u043c MSISDN=" + msisdn);
        }
        MegafonUtils.addPaymentForActivateProduct(this.context, megafonClient, product, megafonContractProduct);
        this.getLogger().debug("ProductActivate => contractId={}, productId={}, productTitle={}", new Object[]{megafonContractProduct.getContractId(), product.getId(), product.getTitle()});
        if (this.checkProductOnMSISDN(msisdn, product.getProductOfferingId())) {
            this.getLogger().debug("\u041f\u0440\u043e\u0434\u0443\u043a\u0442 [productOfferingId={}, productTitle={}] \u0443\u0436\u0435 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u043d\u0430 MSISDN={} \u0438 \u0431\u0443\u0434\u0435\u0442 \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d \u0438 \u0434\u043e\u043b\u0436\u0435\u043d \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c\u0441\u044f \u043f\u043e\u0441\u043b\u0435 \u043f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0431\u0430\u043b\u0430\u043d\u0441\u0430.", new Object[]{product.getProductOfferingId(), product.getTitle(), msisdn});
            this.productActivate(megafonContractProduct);
            megafonContractProduct.setStatus(MegafonContractProductStatus.ACTIVE);
            return;
        }
        long orderId = megafonClient.productActivate(megafonContractProduct, product.getProductOfferingId());
        this.getLogger().debug("ProductActivate result: contractId={}, productId={}, orderId={}", new Object[]{megafonContractProduct.getContractId(), product.getId(), orderId});
        megafonContractProduct.setStatus(MegafonContractProductStatus.ACTIVATION_ORDERED);
        megafonContractProduct.setOrderId(orderId);
        this.contractProductDao.update(megafonContractProduct);
        this.getLogger().debug("\u0421\u043e\u0437\u0434\u0430\u043d \u043f\u0440\u043e\u0434\u0443\u043a\u0442 \u0434\u043b\u044f \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438, \u043f\u0440\u0438\u0441\u0432\u043e\u0435\u043d orderId. Product={}", (Object)megafonContractProduct);
        MegafonCheckOrderStatus.getInstance().checkOrders();
    }

    private boolean checkProductOnMSISDN(String msisdn, String UUID) {
        JSONArray tariffs = this.tariffInfoRequest(msisdn);
        for (int i = 0; i < tariffs.length(); ++i) {
            JSONObject tariff = tariffs.optJSONObject(i);
            String productOfferingId = String.valueOf(tariff.optLong("productOfferingId"));
            if (!UUID.equals(productOfferingId)) continue;
            return true;
        }
        return false;
    }

    private boolean checkActiveProductOnMSISDN(String msisdn, String UUID) {
        JSONArray tariffs = this.tariffInfoRequest(msisdn);
        for (int i = 0; i < tariffs.length(); ++i) {
            JSONObject tariff = tariffs.optJSONObject(i);
            String productOfferingId = String.valueOf(tariff.optLong("productOfferingId"));
            if (!productOfferingId.equals(UUID)) continue;
            JSONObject activationPeriod = tariff.optJSONObject("activationPeriod");
            Date deactivateDate = TimeUtils.parseDate((String)activationPeriod.optString("dateTo"), (String)"yyyy-MM-dd'T'HH:mm:ss");
            return deactivateDate.after(new Date());
        }
        return false;
    }

    private JSONArray tariffInfoRequest(String msisdn) {
        MegafonApiClient apiClient = new MegafonApiClient(this.context.getModuleId());
        JSONObject filters = new JSONObject();
        filters.put("productCategoryIds", 1);
        filters.put("productStatusIds", MegafonContractProductStatus.ACTIVE.getStatus());
        filters.put("showAllowanceBalance", true);
        filters.put("fields", (Object)"productId,productOfferingId,allowances(allowanceBalances),productOfferingName,status,activationPeriod");
        return apiClient.getTariffInfo(msisdn, filters);
    }

    private boolean allowBalance(BigDecimal price, int contractId) {
        boolean bl;
        BalanceUtils bu = new BalanceUtils(this.getConnection());
        try {
            ContractDao contractDao = new ContractDao(this.getConnection(), 0);
            Contract contract = (Contract)contractDao.get(contractId);
            BigDecimal resultBalance = bu.getBalance(LocalDate.now(), contractId).subtract(contract.getBalanceLimit());
            bl = resultBalance.compareTo(price) >= 0;
        }
        catch (Throwable throwable) {
            try {
                try {
                    bu.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (BGException e) {
                throw new RuntimeException(e);
            }
        }
        bu.close();
        return bl;
    }

    public void productDeactivateRequest(MegafonContractProduct megafonContractProduct) throws Exception {
        if (megafonContractProduct.getStatus() != null && megafonContractProduct.getStatus() != MegafonContractProductStatus.ACTIVE) {
            throw new RuntimeException("\u0414\u043b\u044f \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u0441\u0442\u0430\u0442\u0443\u0441 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \"\u0410\u043a\u0442\u0438\u0432\u0435\u043d\"!");
        }
        MegafonService megafonService = (MegafonService)this.context.getService(MegafonService.class, this.context.getModuleId());
        MegafonProduct product = megafonService.getProduct(megafonContractProduct.getProductId());
        if (product == null) {
            throw new RuntimeException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u0440\u043e\u0434\u0443\u043a\u0442 \u0441 ID = " + megafonContractProduct.getProductId());
        }
        this.getLogger().debug("ProductDeactivate => contractId={}, productId={}, productTitle={}", new Object[]{megafonContractProduct.getContractId(), product.getId(), product.getTitle()});
        MegafonApiClient megafonClient = new MegafonApiClient(this.context.getModuleId());
        long orderId = megafonClient.productDeactivate(megafonContractProduct, product.getProductOfferingId());
        this.getLogger().debug("ProductActivate result: contractId={}, productId={}, orderId={}", new Object[]{megafonContractProduct.getContractId(), product.getId(), orderId});
        megafonContractProduct.setStatus(MegafonContractProductStatus.DEACTIVATION_ORDERED);
        megafonContractProduct.setOrderId(orderId);
        this.contractProductDao.update(megafonContractProduct);
        MegafonCheckOrderStatus.getInstance().checkOrders();
    }

    public void productActivate(MegafonContractProduct megafonContractProduct) throws Exception {
        MegafonProduct product = this.getProductOrThrow(megafonContractProduct.getProductId());
        TariffService tariffService = (TariffService)this.context.getService(TariffService.class, 0);
        TariffPlan tariffWithActivate = tariffService.tariffPlanGet(megafonContractProduct.getTariffId());
        if (tariffWithActivate == null) {
            throw new RuntimeException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0442\u0430\u0440\u0438\u0444\u043d\u044b\u0439 \u043f\u043b\u0430\u043d \u0441 ID=" + megafonContractProduct.getTariffId());
        }
        MegafonUtils.npayServiceAdd(this.getModuleSetup(), this.context, product.getNpayServiceId(), (IdTitle)product, megafonContractProduct);
        ContractTariffService contractTariffService = (ContractTariffService)this.context.getService(ContractTariffService.class, 0);
        if (contractTariffService.contractTariffList(megafonContractProduct.getContractId(), new Date(), 0, 0).stream().noneMatch(ct -> ct.getTariffPlanId() == tariffWithActivate.getId())) {
            this.getLogger().debug("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0442\u0430\u0440\u0438\u0444\u0430 \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440. cid={}, serviceId={}", (Object)megafonContractProduct.getContractId(), (Object)tariffWithActivate.getId());
            contractTariffService.contractTariffUpdate(ContractTariff.builder().setContractId(megafonContractProduct.getContractId()).setComment("\u0410\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u0442\u0430\u0440\u0438\u0444\u0430 \u043f\u0440\u0438 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u041c\u0435\u0433\u0430\u0444\u043e\u043d. \u041f\u0440\u043e\u0434\u0443\u043a\u0442: " + product.getTitle()).setPeriod(new Period(megafonContractProduct.getStartTime().toLocalDate(), null)).setTariffPlanId(tariffWithActivate.getId()).build());
        }
        megafonContractProduct.setStatus(MegafonContractProductStatus.ACTIVE);
        megafonContractProduct.setOrderId(0L);
        megafonContractProduct.setEndTime(LocalDateTime.now().plusMonths(1L).withDayOfMonth(1));
        this.contractProductDao.update(megafonContractProduct);
    }

    public void productDeactivate(MegafonContractProduct megafonContractProduct) throws Exception {
        MegafonProduct product = this.getProductOrThrow(megafonContractProduct.getProductId());
        MegafonUtils.removeNpayService(this.getModuleSetup(), this.context, product.getNpayServiceId(), (IdTitle)product, megafonContractProduct);
        LocalDateTime now = LocalDateTime.now();
        megafonContractProduct.setStatus(MegafonContractProductStatus.DISABLED);
        megafonContractProduct.setEndTime(now);
        this.contractProductDao.update(megafonContractProduct);
        TariffService tariffService = (TariffService)this.context.getService(TariffService.class, 0);
        TariffPlan tariffWithActivate = tariffService.tariffPlanGet(megafonContractProduct.getTariffId());
        if (tariffWithActivate == null) {
            this.logError(new BGException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0442\u0430\u0440\u0438\u0444\u043d\u044b\u0439 \u043f\u043b\u0430\u043d \u0441 ID=" + megafonContractProduct.getTariffId()));
        }
    }

    private MegafonProduct getProductOrThrow(int productId) throws Exception {
        MegafonService megafonService = (MegafonService)this.context.getService(MegafonService.class, this.context.getModuleId());
        MegafonProduct product = megafonService.getProduct(productId);
        if (product == null) {
            throw new RuntimeException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u0440\u043e\u0434\u0443\u043a\u0442 \u0441 ID = " + productId);
        }
        return product;
    }

    public void optionActivateRequest(MegafonContractProduct contractProduct, MegafonOption option) throws Exception {
        if (contractProduct.getEndTime() != null && contractProduct.getEndTime().isBefore(LocalDateTime.now())) {
            throw new BGException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043e\u043f\u0446\u0438\u044e \u0434\u043b\u044f \u043d\u0435\u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430!");
        }
        String msisdn = MegafonUtils.defineCorrectMSISDN(contractProduct);
        if (!this.allowBalance(option.getPrice(), contractProduct.getContractId())) {
            throw new RuntimeException(String.format("\u041d\u0435 \u0445\u0432\u0430\u0442\u0430\u0435\u0442 \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0434\u043b\u044f \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435 CID=%s. \u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u043e\u043f\u0446\u0438\u0438 ID:%s = %s.", contractProduct.getContractId(), option.getId(), option.getPrice()));
        }
        MegafonApiClient megafonClient = new MegafonApiClient(this.context.getModuleId());
        this.getLogger().debug("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u0438 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438. cid={}, msisdn={}, productOfferingId={}", new Object[]{contractProduct.getContractId(), msisdn, option.getProductOfferingId()});
        megafonClient.checkActivateProduct(msisdn, option.getProductOfferingId(), LocalDateTime.now());
        MegafonUtils.addPaymentForActivateOption(this.context, megafonClient, option, contractProduct);
        long orderId = megafonClient.optionActivate(msisdn, LocalDateTime.now(), null, option.getProductOfferingId());
        this.getLogger().debug("OptionActivateRequest result: contractId={}, optionId={}, orderId={}", new Object[]{contractProduct.getContractId(), option.getId(), orderId});
        MegafonContractOption contractOption = new MegafonContractOption();
        contractOption.setContractId(contractProduct.getContractId());
        contractOption.setOptionId(option.getId());
        contractOption.setContractProductId(contractProduct.getContractId());
        contractOption.setStatus(MegafonContractProductStatus.ACTIVATION_ORDERED);
        contractOption.setOrderId(orderId);
        contractOption.setStartTime(LocalDateTime.now());
        this.contractOptionDao.update(contractOption);
        MegafonCheckOrderStatus.getInstance().checkOrders();
    }

    public void optionActivate(MegafonContractProduct contractProduct, MegafonContractOption contractOption) throws Exception {
        MegafonService megafonService = (MegafonService)this.context.getService(MegafonService.class, this.context.getModuleId());
        MegafonOption option = megafonService.getMegafonOption(contractOption.getOptionId());
        this.getLogger().debug("OptionActivate cid={}, msisdn={}, productOfferingId={}, optionId={}", new Object[]{contractProduct.getContractId(), contractProduct.getMsisdn(), option.getProductOfferingId(), option.getId()});
        MegafonUtils.npayServiceAdd(this.getModuleSetup(), (ServerContext)ServerContext.get(), option.getNpayServiceId(), (IdTitle)option, contractProduct);
        contractOption.setOrderId(0L);
        contractOption.setStatus(MegafonContractProductStatus.ACTIVE);
        if (option.getOptionType().equals((Object)MegafonOptionType.PROLONGATE)) {
            contractOption.setEndTime(contractProduct.getEndTime());
        } else {
            contractOption.setEndTime(LocalDateTime.now().plusDays(30L));
        }
        this.contractOptionDao.update(contractOption);
    }

    public void synchronizeContractProducts(int contractId, String msisdn, String additionalMsisdn) throws Exception {
        if (Utils.isBlankString((String)msisdn)) {
            throw new BGException("\u041d\u0435 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 MSISDN");
        }
        boolean isMNPProcess = Utils.notBlankString((String)additionalMsisdn);
        msisdn = isMNPProcess ? additionalMsisdn : msisdn;
        this.getLogger().info("\u0421\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u043e\u0432 \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c \u041c\u0435\u0433\u0430\u0444\u043e\u043d. MSISDN={}, contractId={}", (Object)msisdn, (Object)contractId);
        MegafonService megafonService = (MegafonService)this.context.getService(MegafonService.class, this.context.getModuleId());
        Map allProducts = megafonService.getProductList().stream().collect(Collectors.toMap(MegafonProduct::getProductOfferingId, Function.identity()));
        ArrayList<MegafonContractProduct> productsForActivate = new ArrayList<MegafonContractProduct>();
        TariffService tariffService = (TariffService)this.context.getService(TariffService.class, 0);
        MegafonApiClient apiClient = new MegafonApiClient(this.context.getModuleId());
        JSONObject requestFilters = new JSONObject();
        requestFilters.put("productCategoryIds", 1);
        requestFilters.put("productStatusIds", MegafonContractProductStatus.ACTIVE.getStatus());
        requestFilters.put("showAllowanceBalance", true);
        requestFilters.put("fields", (Object)"productId,productOfferingId,allowances(allowanceBalances),productOfferingName,status,activationPeriod");
        JSONArray tariffs = apiClient.getTariffInfo(msisdn, requestFilters);
        for (int i = 0; i < tariffs.length(); ++i) {
            JSONObject tariff = tariffs.optJSONObject(i);
            String productOfferingId = String.valueOf(tariff.optLong("productOfferingId"));
            if (!this.thisTariffIsActive(tariff)) continue;
            if (this.thisProductAlreadyActive(megafonService, contractId, msisdn, productOfferingId)) {
                this.getLogger().info("\u041f\u0440\u043e\u0434\u0443\u043a\u0442 productOfferingId={} \u0443\u0436\u0435 \u0430\u043a\u0442\u0438\u0432\u0435\u043d \u0432 \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0435 \u043d\u0430 cid={}, msisdn={}", new Object[]{productOfferingId, contractId, msisdn});
                continue;
            }
            JSONObject statusInfo = tariff.optJSONObject("status");
            JSONObject activationPeriod = tariff.optJSONObject("activationPeriod");
            Date deactivateDate = TimeUtils.parseDate((String)activationPeriod.optString("dateTo"), (String)"yyyy-MM-dd'T'HH:mm:ss");
            LocalDateTime activateDate = TimeUtils.parseLocalDateTime((String)statusInfo.optString("changeDateTime"), (String)"yyyy-MM-dd'T'HH:mm:ss");
            this.getLogger().info("\u041d\u0430\u0439\u0434\u0435\u043d \u043f\u0440\u043e\u0434\u0443\u043a\u0442 \u0434\u043b\u044f \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u0432 \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0435. productOfferingId={}, dateFrom={}, dateTo={}", new Object[]{productOfferingId, TimeUtils.format((LocalDateTime)activateDate, (String)"dd.MM.yyyy HH:mm:ss"), TimeUtils.format((Date)deactivateDate, (String)"dd.MM.yyyy HH:mm:ss")});
            MegafonProduct product = (MegafonProduct)allProducts.get(productOfferingId);
            if (product == null) {
                throw new RuntimeException("\u0412 \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u0441 productOfferingId=" + productOfferingId);
            }
            MegafonContractProduct contractProduct = new MegafonContractProduct();
            contractProduct.setContractId(contractId);
            contractProduct.setProductId(product.getId());
            contractProduct.setMsisdn(msisdn);
            if (isMNPProcess) {
                contractProduct.setAdditionalMsisdn(additionalMsisdn);
            }
            contractProduct.setStatus(MegafonContractProductStatus.ACTIVE);
            contractProduct.setStartTime(activateDate);
            LocalDateTime deactivationDateTime = deactivateDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            contractProduct.setEndTime(deactivationDateTime.getYear() == 2999 ? null : TimeUtils.convertDateToLocalDateTime((Date)deactivateDate));
            List tariffPlans = tariffService.getTariffListByLabelId(product.getTariffLabelId());
            this.getLogger().debug("productOfferingId={}, \u0431\u0443\u0434\u0435\u0442 \u0432\u0437\u044f\u0442 \u0442\u0430\u0440\u0438\u0444 tariffId={}", (Object)productOfferingId, (Object)(!tariffPlans.isEmpty() ? ((TariffPlan)tariffPlans.get(0)).getId() : 0));
            contractProduct.setTariffId(!tariffPlans.isEmpty() ? ((TariffPlan)tariffPlans.get(0)).getId() : 0);
            productsForActivate.add(contractProduct);
        }
        this.getLogger().info("contractId={}, msisdn={}, \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u044b \u0434\u043b\u044f \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438={}", new Object[]{contractId, msisdn, productsForActivate});
        if (productsForActivate.isEmpty()) {
            throw new RuntimeException("\u041d\u0435\u0442 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u043e\u0432 \u0434\u043b\u044f \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u0438");
        }
        for (MegafonContractProduct contractProduct : productsForActivate) {
            this.getLogger().debug("\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430={}", (Object)contractProduct);
            this.productActivate(contractProduct);
        }
    }

    private boolean thisTariffIsActive(JSONObject tariff) {
        JSONArray allowances = tariff.getJSONArray("allowances");
        for (int j = 0; j < allowances.length(); ++j) {
            JSONObject allowance = allowances.getJSONObject(j);
            JSONArray allowanceBalances = allowance.getJSONArray("allowanceBalances");
            for (int k = 0; k < allowanceBalances.length(); ++k) {
                JSONObject volumeStatus;
                JSONObject balance = allowanceBalances.getJSONObject(k);
                if (!balance.has("volumeStatus") || balance.isNull("volumeStatus") || !(volumeStatus = balance.getJSONObject("volumeStatus")).has("volumeStatusId") || volumeStatus.getInt("volumeStatusId") != 2) continue;
                return true;
            }
        }
        return false;
    }

    private boolean thisProductAlreadyActive(MegafonService megafonService, int contractId, String msisdn, String productOfferingId) throws Exception {
        List activeProductOnContract = this.getContractProductList(null, contractId, MegafonContractProductStatus.ACTIVE).getList();
        for (MegafonContractProduct activeProduct : activeProductOnContract) {
            MegafonProduct activeProductSpec = megafonService.getProduct(activeProduct.getProductId());
            if (!activeProduct.getMsisdn().equals(msisdn) || !activeProductSpec.getProductOfferingId().equals(productOfferingId)) continue;
            return true;
        }
        return false;
    }

    public SearchResult<MegafonContractOption> getContractOptions(Page page, int contractId) throws Exception {
        if (page == null) {
            page = new Page();
        }
        ArrayList<String> conditions = new ArrayList<String>();
        ArrayList<Integer> parameters = new ArrayList<Integer>();
        if (contractId > 0) {
            conditions.add("contract_id = ?");
            parameters.add(contractId);
        }
        String whereClause = conditions.isEmpty() ? "" : String.join((CharSequence)" AND ", conditions);
        Result<MegafonContractOption> result = this.contractOptionDao.list(page, whereClause, "id", parameters.toArray());
        return new SearchResult(result.getPage()).setList(result.getList());
    }

    public int MNPProcessStart(int contractId, String msisdn, String additionalMsisdn) throws Exception {
        BigDecimal mnpProcessPrice = Utils.parseBigDecimal((String)Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId)).get("megafon.mnp.price"), (BigDecimal)BigDecimal.valueOf(100L));
        if (!this.allowBalance(mnpProcessPrice, contractId)) {
            throw new BGException("\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0434\u043b\u044f MNP. \u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c=" + String.valueOf(mnpProcessPrice));
        }
        int reserveTypeId = this.getModuleSetup().getInt("megafon.mnp.resevretype", 0);
        if (reserveTypeId <= 0) {
            throw new BGException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u0442\u0438\u043f \u0440\u0435\u0437\u0435\u0440\u0432\u0430 \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043c\u043e\u0434\u0443\u043b\u044f!");
        }
        Reserve reserve = new Reserve();
        reserve.setContractId(contractId);
        reserve.setComment(String.format("\u0417\u0430 \u043f\u0435\u0440\u0435\u043d\u043e\u0441 \u043d\u043e\u043c\u0435\u0440\u0430: %s. \u0412\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440: %s", msisdn, additionalMsisdn));
        reserve.setTypeId(reserveTypeId);
        reserve.setSum(mnpProcessPrice);
        ReserveService reserveService = (ReserveService)this.context.getService(ReserveService.class, 0);
        return reserveService.updateReserve(reserve);
    }

    public String getContractOptionInfo(int contractOptionId) throws Exception {
        MegafonContractOption contractOption = (MegafonContractOption)this.contractOptionDao.get(contractOptionId);
        MegafonOptionDao megafonOptionDao = new MegafonOptionDao(this.getConnection(), this.moduleId);
        MegafonOption megafonOption = (MegafonOption)megafonOptionDao.get(contractOption.getOptionId());
        String uuid = megafonOption.getProductOfferingId();
        MegafonContractProduct contractProduct = (MegafonContractProduct)this.contractProductDao.get(contractOption.getContractProductId());
        MegafonApiClient apiClient = new MegafonApiClient(this.moduleId);
        JSONObject filters = new JSONObject();
        filters.put("productCategoryIds", 1);
        filters.put("productStatusIds", MegafonContractProductStatus.ACTIVE.getStatus());
        filters.put("showAllowanceBalance", true);
        filters.put("fields", (Object)"productId,productOfferingId,allowances(allowanceBalances),productOfferingName,status,activationPeriod");
        JSONArray tariffInfo = apiClient.getTariffInfo(MegafonUtils.defineCorrectMSISDN(contractProduct), filters);
        JSONObject result = new JSONObject();
        for (int i = 0; i < tariffInfo.length(); ++i) {
            JSONObject tariff = tariffInfo.optJSONObject(i);
            long productOfferingId = tariff.optLong("productOfferingId");
            if (productOfferingId != Utils.parseLong((String)uuid)) continue;
            String productOfferingName = tariff.optString("productOfferingName");
            String statusName = tariff.optJSONObject("status").optJSONObject("status").optString("name");
            JSONObject activationPeriod = tariff.optJSONObject("activationPeriod");
            result.put("productOfferingId", productOfferingId);
            result.put("productOfferingName", (Object)productOfferingName);
            result.put("statusName", (Object)statusName);
            result.put("activationPeriod", (Object)activationPeriod);
        }
        return result.toString();
    }
}

