/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mangooffice.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGMaskTextField;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.mangooffice.common.bean.MangoAccountProduct;
import ru.bitel.bgbilling.modules.mangooffice.common.bean.MangoPhone;
import ru.bitel.bgbilling.modules.mangooffice.common.service.MangoService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public class MangoContractPhonePanel
extends BGUPanel {
    private int contractId;
    private MangoService mangoService = null;
    private BGTableModel<MangoPhone> model;
    private BGUTable table = new BGUTable(this.model);
    private JPanel addPanel = new JPanel(new GridBagLayout());
    private BGUComboBox<IdTitle> productComboBox = new BGUComboBox();
    private PhoneField phoneField = new PhoneField();
    private List<MangoAccountProduct> productList = null;
    private Map<Integer, MangoAccountProduct> productMap = null;
    protected List<IdTitle> tariffTypeList = null;
    protected Map<Integer, IdTitle> tariffTypeMap = null;

    protected void jbInit() throws Exception {
        this.contractId = ((ClientContext)this.getContext()).getContractId();
        this.mangoService = (MangoService)((ClientContext)this.getContext()).getPort(MangoService.class);
        this.model = new BGTableModel<MangoPhone>("\u041d\u043e\u043c\u0435\u0440\u0430"){

            protected void initColumns() {
                this.addColumnId();
                this.addColumn("\u041f\u0440\u043e\u0434\u0443\u043a\u0442", -1, 80, -1, "productId", true);
                this.addColumn("\u041d\u043e\u043c\u0435\u0440", -1, 250, -1, "phone", true);
                this.addColumn("\u0414\u0430\u0442\u0430 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f", -1, 150, -1, "dateFrom", true, DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
                this.addColumn("\u0414\u0430\u0442\u0430 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f", -1, 150, -1, "dateTo", true, DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
                this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", -1, 150, -1, "day", true);
            }

            public Object getValueAt(MangoPhone val, int column) throws Exception {
                switch (column) {
                    case 1: {
                        IdTitle tariff;
                        MangoAccountProduct product;
                        String title = "<\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>";
                        if (MangoContractPhonePanel.this.productMap != null && MangoContractPhonePanel.this.tariffTypeMap != null && (product = MangoContractPhonePanel.this.productMap.get(val.getAccountProductId())) != null && (tariff = MangoContractPhonePanel.this.tariffTypeMap.get(product.getPlanId())) != null) {
                            title = tariff.getTitle();
                        }
                        return title;
                    }
                    case 5: {
                        return val.getStatus() == 0 ? "\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d" : "\u0423\u0434\u0430\u043b\u0435\u043d";
                    }
                }
                return super.getValue((Object)val, column);
            }
        };
        this.table.setModel(this.model);
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        okCancel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.addPanel.setBorder(BorderFactory.createCompoundBorder((Border)new BGTitleBorder("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043d\u043e\u043c\u0435\u0440 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430"), BorderFactory.createEmptyBorder(0, 3, 3, 3)));
        this.addPanel.add((Component)new JLabel("\u041f\u0440\u043e\u0434\u0443\u043a\u0442: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.addPanel.add((Component)this.productComboBox, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.addPanel.add((Component)new JLabel("\u0422\u0435\u043b\u0435\u0444\u043e\u043d: "), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.addPanel.add((Component)((Object)this.phoneField), new GridBagConstraints(3, 0, 1, 1, 0.1, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.addPanel.add((Component)Box.createVerticalBox(), new GridBagConstraints(4, 2, 1, 1, 1.0, 0.001, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.addPanel.add((Component)okCancel, new GridBagConstraints(4, 2, 1, 1, 1.0, 0.0, 13, 13, new Insets(5, 5, 5, 5), 0, 0));
        this.addPanel.setVisible(false);
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.addPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        okCancel.addActionListener(e -> {
            if (e.getActionCommand().equals("ok")) {
                String phoneNumber = this.phoneField.getData();
                if (phoneNumber.length() != 11) {
                    ClientUtils.showErrorMessageDialog((String)"\u0422\u0435\u043b\u0435\u0444\u043e\u043d \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c 11 \u0446\u0438\u0444\u0440");
                    return;
                }
                IdTitle product = (IdTitle)this.productComboBox.getSelectedItem();
                if (product == null) {
                    ClientUtils.showErrorMessageDialog((String)"\u0414\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d \u043f\u0440\u043e\u0434\u0443\u043a\u0442");
                    return;
                }
                try {
                    this.mangoService.phoneAdd(product.getId(), phoneNumber);
                    this.performAction("refresh", "refresh");
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
            this.addPanel.setVisible(false);
        });
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            if (e.getActionCommand() == "refresh") {
                ArrayList productTitleList = new ArrayList();
                this.productList = this.mangoService.getProductList(this.contractId);
                if (this.productList != null && this.productList.size() > 0) {
                    this.productMap = new HashMap<Integer, MangoAccountProduct>();
                    this.productList.forEach(product -> this.productMap.put(product.getId(), (MangoAccountProduct)product));
                    this.productList.forEach(product -> {
                        IdTitle t = this.tariffTypeMap.get(product.getPlanId());
                        if (t != null) {
                            productTitleList.add(new IdTitle(product.getId(), t.getTitle()));
                        }
                    });
                }
                this.productComboBox.setData(productTitleList);
                this.model.setData(this.mangoService.getPhoneList(this.contractId));
            }
        });
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            this.addPanel.setVisible(true);
            this.phoneField.clear();
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            MangoPhone phone = (MangoPhone)this.model.getSelectedRow();
            if (phone == null) {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0437\u0430\u043a\u0440\u044b\u0432\u0430\u0435\u043c\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430");
                return;
            }
            if (ClientUtils.confirm((String)("\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u044c \u043d\u043e\u043c\u0435\u0440: " + phone.getPhone()), (String)"\u0417\u0430\u043a\u0440\u044b\u0442\u0438\u0435")) {
                this.mangoService.phoneRemove(phone.getId());
                this.performAction("refresh", "refresh");
            }
        });
    }

    private class PhoneField
    extends BGMaskTextField {
        PhoneField() {
            super(" (   )       ", "()", new BGMaskTextField.FieldValidator[]{new BGMaskTextField.IntegerValidator(), new BGMaskTextField.IntegerValidator(), new BGMaskTextField.IntegerValidator()});
            this.setHorizontalAlignment(0);
        }
    }
}

