/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.client;

import bitel.billing.module.admin.bgsecure.ActionsPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.bgsecure.client.RequestRecordLogTable;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.RecordAction;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.RequestRecordLog;
import ru.bitel.bgbilling.kernel.bgsecure.common.service.RoleService;
import ru.bitel.bgbilling.kernel.module.common.bean.BGSAction;
import ru.bitel.bgbilling.kernel.module.common.bean.BGSActionGroup;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.Async;

public class BGSActionGroupPanel
extends BGUPanel {
    private final RoleService roleService;
    private BGSActionGroupTableModel tableModel;

    public BGSActionGroupPanel(RoleService roleService) {
        this.roleService = roleService;
    }

    @Override
    protected void jbInit() throws Exception {
        this.tableModel = new BGSActionGroupTableModel();
        BGUTable table = new BGUTable(this.tableModel);
        BGSwingUtilites.handleEdit((JTable)table, this, "edit");
        this.setLayout(new GridBagLayout());
        this.add((Component)new JScrollPane(table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(3, 3, 3, 0), 0, 0));
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh(e -> {
            if (this.tableModel != null) {
                this.tableModel.setData(this.roleService.getBGSActionGroups());
            }
        });
        new AbstractBGUPanel.BGActionNew(e -> new BGSActionGroupEditor(new BGSActionGroup()).open());
        new AbstractBGUPanel.BGActionEdit(e -> this.getSelectedGroup().ifPresent(group -> new BGSActionGroupEditor((BGSActionGroup)group).open()));
        new AbstractBGUPanel.BGActionDelete(e -> this.getSelectedGroup().ifPresent(group -> {
            if (ClientUtils.confirmDelete(group.getTitle())) {
                this.tryCall(() -> {
                    this.roleService.deleteBGSActionGroup((BGSActionGroup)group);
                    this.performAction("refresh");
                });
            }
        }));
    }

    private Optional<BGSActionGroup> getSelectedGroup() {
        return Optional.ofNullable(this.tableModel).map(a -> (BGSActionGroup)a.getSelectedRow());
    }

    class BGSActionGroupTableModel
    extends BGTableModel<BGSActionGroup> {
        public BGSActionGroupTableModel() {
            super(BGSActionGroupTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "title", false, HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    class BGSActionGroupEditor
    extends BGEditorDialog<BGSActionGroup> {
        private final JTextField title;
        private final ActionsPanel actionsPanel;
        private final JToggleButton selectFromRecord;

        public BGSActionGroupEditor(BGSActionGroup data) {
            super("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0433\u0440\u0443\u043f\u043f\u044b", data);
            this.title = new JTextField();
            this.actionsPanel = new ActionsPanel();
            this.selectFromRecord = new JToggleButton("\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u0438\u0437 \u0437\u0430\u043f\u0438\u0441\u0438 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0439 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439");
            this.selectFromRecord.setEnabled(false);
        }

        @Override
        public void doDialogPanel() {
            Async.of(() -> {
                this.actionsPanel.init(((ClientContext)BGSActionGroupPanel.this.getContext()).getModule(), 0);
                this.actionsPanel.setData();
                this.actionsPanel.setSelectedActions(((BGSActionGroup)this.data).getActions());
                this.selectFromRecord.setEnabled(true);
            });
            this.panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0433\u0440\u0443\u043f\u043f\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0439"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 3, 0, 3), 0, 0));
            this.panel.add((Component)this.title, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 3, 0, 3), 0, 0));
            this.panel.add((Component)new JLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 0, 3), 0, 0));
            this.panel.add((Component)this.actionsPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 3, 0, 3), 0, 0));
            this.tryCall(() -> this.initRequestRecordLogPanel());
            this.title.setText(((BGSActionGroup)this.data).getTitle());
        }

        private void initRequestRecordLogPanel() throws Exception {
            List requestRecordLogList = BGSActionGroupPanel.this.roleService.searchRequestRecordLogList().getList().stream().filter(rec -> rec.getEndRecordingTime() != null).collect(Collectors.toList());
            if (Utils.notEmptyCollection(requestRecordLogList)) {
                SelectFromRecordPanel selectFromRecordPanel = new SelectFromRecordPanel(this.actionsPanel);
                this.selectFromRecord.addActionListener(e -> selectFromRecordPanel.setVisible(this.selectFromRecord.isSelected()));
                this.panel.add((Component)this.selectFromRecord, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 3, 0, 3), 0, 0));
                this.panel.add((Component)selectFromRecordPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 3, 0, 3), 0, 0));
            }
        }

        @Override
        public boolean doApply() throws Exception {
            if (Utils.isBlankString(this.title.getText())) {
                ClientUtils.showErrorMessageDialog("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0433\u0440\u0443\u043f\u043f\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0439!");
                return false;
            }
            ((BGSActionGroup)this.data).setTitle(this.title.getText().trim());
            ((BGSActionGroup)this.data).setActions(this.actionsPanel.getSelectedActions());
            return this.tryCallBoolean(() -> {
                BGSActionGroupPanel.this.roleService.updateBGSActionGroup((BGSActionGroup)this.data);
                BGSActionGroupPanel.this.performAction("refresh");
            });
        }
    }

    private final class SelectFromRecordPanel
    extends JPanel {
        public SelectFromRecordPanel(ActionsPanel actionsPanel) {
            this.setLayout(new GridBagLayout());
            RequestRecordLogTable requestRecordLogTable = new RequestRecordLogTable((ClientContext)BGSActionGroupPanel.this.getContext());
            BGButton select = new BGButton("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0432 \u043d\u0430\u0431\u043e\u0440");
            select.addActionListener(e -> {
                RequestRecordLog log = requestRecordLogTable.getSelectedRequest();
                if (log != null) {
                    Set<RecordAction> actionsFromLog = log.getActions();
                    ArrayList<BGSAction> newActions = new ArrayList<BGSAction>();
                    for (RecordAction recordAction : actionsFromLog) {
                        BGSAction bgsAction = new BGSAction();
                        bgsAction.mid = recordAction.getModuleId();
                        bgsAction.actionID = recordAction.getActionId();
                        newActions.add(bgsAction);
                    }
                    List<BGSAction> selectedActions = actionsPanel.getSelectedActions();
                    selectedActions.addAll(newActions);
                    actionsPanel.setSelectedActions(selectedActions);
                    this.setVisible(false);
                }
            });
            this.add((Component)new JScrollPane(requestRecordLogTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)select, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            BGSActionGroupPanel.this.tryCall(() -> requestRecordLogTable.setData(BGSActionGroupPanel.this.roleService.searchRequestRecordLogList().getList()));
            this.setVisible(false);
        }
    }
}

