/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.groupaction.client;

import bitel.billing.module.admin.TransferManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.common.BGControlPanelListSelect;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.kernel.admin.groupaction.client.ContractGroupOperation;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class AddContractGroup
extends ContractGroupOperation.ContractGroupOperationItem {
    private BGControlPanelListSelect groups = new BGControlPanelListSelect();
    private JRadioButton add = new JRadioButton("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c", true);
    private JRadioButton del = new JRadioButton("\u0423\u0434\u0430\u043b\u0438\u0442\u044c", false);
    private JCheckBox showOnlyUsing = new JCheckBox("\u0422\u043e\u043b\u044c\u043a\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0435", false);
    private Document doc;

    public AddContractGroup() {
        super(new GridBagLayout());
    }

    @Override
    protected void jbInit() throws Exception {
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.add((Component)this.add, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        buttonPanel.add((Component)this.del, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add.addActionListener(e -> {
            this.add.setSelected(this.add.isSelected());
            this.del.setSelected(!this.add.isSelected());
        });
        this.del.addActionListener(e -> {
            this.del.setSelected(this.del.isSelected());
            this.add.setSelected(!this.del.isSelected());
        });
        JPanel groupPanel = new JPanel(new GridBagLayout());
        groupPanel.setBorder(new BGTitleBorder(" \u0413\u0440\u0443\u043f\u043f\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 "));
        groupPanel.setMinimumSize(new Dimension(180, 200));
        groupPanel.setPreferredSize(new Dimension(180, 200));
        groupPanel.add((Component)this.showOnlyUsing, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.showOnlyUsing.addActionListener(e -> this.tryCall(() -> {
            List<String> selectedItems = this.getSelectedIdList();
            this.getGroups(this.showOnlyUsing.isSelected());
            this.selectByIds(Utils.toString(selectedItems));
        }));
        groupPanel.add((Component)this.groups, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)buttonPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)groupPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    @Override
    protected void setData() {
        this.tryCall(() -> this.getGroups(this.showOnlyUsing.isSelected()));
    }

    @Override
    protected boolean doItemOperation(String cids) {
        Request req = new Request().setModule("contract").setAction("ContractGroupOperation").setAttribute("cids", cids).setAttribute("mids", this.groups.getListValues());
        if (this.add.isSelected()) {
            req.setAttribute("type", "addToGroup");
        }
        if (this.del.isSelected()) {
            req.setAttribute("type", "deleteFromGroup");
        }
        return ClientUtils.checkStatus(TransferManager.getDocument(req));
    }

    @Override
    protected String getOperationTitle() {
        return "\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435/\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u0432 \u0433\u0440\u0443\u043f\u043f\u0443/\u0438\u0437 \u0433\u0440\u0443\u043f\u043f\u044b";
    }

    private void getDocument() {
        Request req = new Request().setModule("admin").setAction("GetContractGroupList");
        this.doc = TransferManager.getDocument(req);
    }

    private void getGroups(boolean enabled) throws Exception {
        if (this.doc == null) {
            this.getDocument();
        }
        ArrayList<BGUListItem> items = new ArrayList<BGUListItem>();
        Element node = XMLUtils.selectElement(this.doc, "//table/data");
        if (node != null && node.hasChildNodes()) {
            NodeList list = node.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Element item = (Element)list.item(i);
                if (enabled && !"true".equals(XMLUtils.getAttribute(item, "f1", "false"))) continue;
                String moduleId = XMLUtils.getAttribute(item, "f0", null);
                items.add(new BGUListItem(moduleId, XMLUtils.getAttribute(item, "f2", null)));
            }
        }
        this.groups.getList().setData(items);
    }

    public List<String> getSelectedIdList() {
        return Utils.toList(this.groups.getListValues());
    }

    public void selectByIds(String sids) {
        this.groups.setListValues(sids);
    }
}

