/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.groupaction.client;

import bitel.billing.module.common.BGComponentBorder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelListSelect;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGFileChooser;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTabPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGTextArea;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.kernel.admin.common.bean.FieldNameSQL;
import ru.bitel.bgbilling.kernel.admin.common.service.AdminService;
import ru.bitel.bgbilling.kernel.contract.base.client.ContractEditor;
import ru.bitel.bgbilling.kernel.contract.search.client.ContractOpen;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginManagerClient;
import ru.bitel.bgbilling.kernel.plugin.common.BGPluginBase;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.model.IdTitle;

public class ContractGroupOperation
extends BGUTabPanel {
    private static final String PREFIX_BITEL_BILLING_MODULE_SERVICES = "bitel.billing.module.services.";
    public static final String TAB_ID = "groupOperation";
    private BGFileChooser fileChooser = new BGFileChooser((Component)((Object)this));
    private BGControlPanelListSelect contractList = new BGControlPanelListSelect();
    private Collection<ContractGroupOperationItem> operations = new ArrayList<ContractGroupOperationItem>();
    private Map<String, Element> elements = new HashMap<String, Element>();

    public ContractGroupOperation() {
        super(new ClientContext("admin", 0, 0, ClientUtils.getRBName(ContractGroupOperation.class)), TAB_ID, "\u0413\u0440\u0443\u043f\u043f\u043e\u0432\u044b\u0435 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438");
    }

    protected void jbInit() throws Exception {
        BGButton all = new BGButton("\u0412\u0441\u0435");
        BGButton next = new BGButton("\u0421\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439");
        BGButton contractsFromSearch = new BGButton("\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u044b");
        BGButton openedContracts = new BGButton("\u041e\u0442\u043a\u0440\u044b\u0442\u044b\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u044b");
        next.setPreferredSize(new Dimension(200, next.getPreferredSize().height));
        all.setPreferredSize(new Dimension(200, all.getPreferredSize().height));
        BGSwingUtilites.wrapBorder((JPanel)this.contractList, (String)" \u0414\u043e\u0433\u043e\u0432\u043e\u0440\u044b ");
        JPanel panelLeft = new JPanel(new GridBagLayout());
        panelLeft.add((Component)contractsFromSearch, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        panelLeft.add((Component)openedContracts, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        panelLeft.add((Component)this.contractList, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        panelLeft.add((Component)this.getDataButtonsPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        buttonPanel.add((Component)next, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        buttonPanel.add((Component)all, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.setBorder(null);
        JPanel panelRight = new JPanel(new GridBagLayout());
        panelRight.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        panelRight.add((Component)buttonPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        for (Element itemElement : XMLUtils.selectElements((Node)((ClientContext)this.getContext()).getModuleDoc(), (String)"/module/ContractGroupOperation/item")) {
            String className = itemElement.getAttribute("class");
            if (className == null) continue;
            try {
                ContractGroupOperationItem item = (ContractGroupOperationItem)((Object)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]));
                item.init(this.elements);
                this.operations.add(item);
            }
            catch (Exception item) {}
        }
        this.loadModules();
        for (ContractGroupOperationItem operationItem : this.operations) {
            operationItem.setVisible(false);
            panel.add((Component)((Object)operationItem), new GridBagConstraints(0, panel.getComponentCount(), 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 0, 5), 0, 0));
            JCheckBox ocb = new JCheckBox(operationItem.getOperationTitle(), false);
            panel.add((Component)ocb, new GridBagConstraints(0, panel.getComponentCount(), 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 10, 0, 5), 0, 0));
            ocb.setVisible(true);
            JCheckBox checkBox = new JCheckBox(operationItem.getOperationTitle(), true);
            checkBox.setFocusPainted(false);
            BGComponentBorder componentBorder = new BGComponentBorder((Component)checkBox, (JComponent)((Object)operationItem), BorderFactory.createEtchedBorder());
            checkBox.addActionListener(e -> {
                operationItem.setVisible(false);
                ocb.setVisible(true);
                ocb.setSelected(false);
            });
            operationItem.setBorder((Border)componentBorder);
            ocb.addActionListener(e -> {
                operationItem.setData();
                operationItem.setVisible(true);
                ocb.setVisible(false);
                checkBox.setSelected(true);
            });
        }
        panel.add(Box.createVerticalGlue(), new GridBagConstraints(0, panel.getComponentCount(), 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)new BGSplitPaneNoBorder(1, (Component)panelLeft, (Component)panelRight, 300L), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        next.addActionListener(e -> {
            List model = this.contractList.getList().getData();
            for (BGUListItem item : model) {
                if (!item.isSelected()) continue;
                String id = item.getIdStr();
                if (id != null && !this.doOperation(id)) {
                    ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044e");
                }
                item.setSelected(false);
                this.contractList.repaint();
                break;
            }
        });
        all.addActionListener(e -> {
            boolean result = this.doOperation(this.contractList.getListValues());
            this.contractList.setListItemSelected(false);
            if (!result) {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044e");
            }
        });
        contractsFromSearch.addActionListener(e -> this.getContracts());
        openedContracts.addActionListener(e -> this.getOpenedContracts());
    }

    private JPanel getDataButtonsPanel() {
        ActionListener actionListener = e -> this.loadFrom(e.getActionCommand());
        BGButton loadIdsFromFile = new BGButton("\u0438\u0437 \u0444\u0430\u0439\u043b\u0430", "file_i", actionListener);
        BGButton loadNumbersFromFile = new BGButton("\u0438\u0437 \u0444\u0430\u0439\u043b\u0430", "file_n", actionListener);
        BGButton loadIdsFromClipboard = new BGButton("\u0438\u0437 \u0431\u0443\u0444\u0435\u0440\u0430", "cb_i", actionListener);
        BGButton loadNumbersFromClipboard = new BGButton("\u0438\u0437 \u0431\u0443\u0444\u0435\u0440\u0430", "cb_n", actionListener);
        BGButton loadIdsFromSQL = new BGButton("SQL", "sql_i", actionListener);
        BGButton loadNumbersFromSQL = new BGButton("SQL", "sql_n", actionListener);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041a\u043e\u0434\u044b:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        panel.add((Component)loadIdsFromFile, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)loadIdsFromClipboard, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)loadIdsFromSQL, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u041d\u043e\u043c\u0435\u0440\u0430:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        panel.add((Component)loadNumbersFromFile, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)loadNumbersFromClipboard, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)loadNumbersFromSQL, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    public void loadModules() {
        this.tryCall(() -> {
            for (BGModule bgModule : ((AdminService)((ClientContext)this.getContext()).getWebService(AdminService.class)).getModules()) {
                String moduleId = String.valueOf(bgModule.getId());
                String title = bgModule.getTitle();
                String pkg = bgModule.getInstalledModule().getPackageClient();
                this.addGroupOperation(pkg + ".ContractGroupOperationFactory", moduleId, title);
                if (!pkg.startsWith(PREFIX_BITEL_BILLING_MODULE_SERVICES)) continue;
                String moduleName = pkg.substring(PREFIX_BITEL_BILLING_MODULE_SERVICES.length());
                this.addGroupOperation("ru.bitel.bgbilling.modules." + moduleName + ".client.ContractGroupOperationFactory", moduleId, title);
            }
        });
        for (BGPluginBase bGPluginBase : BGPluginManagerClient.getManager().getPluginsMap().values()) {
            this.addGroupOperation(bGPluginBase.getId() + ".client.ContractGroupOperationFactory", "", bGPluginBase.getName());
        }
    }

    private void addGroupOperation(String className, String moduleId, String title) {
        try {
            Class<?> clazz = Class.forName(className);
            if (ContractGroupOperationFactory.class.isAssignableFrom(clazz)) {
                ContractGroupOperationFactory groupOperationFactory = (ContractGroupOperationFactory)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                for (ContractGroupOperationItem operationItem : groupOperationFactory.getContractGroupOperations(moduleId, title)) {
                    this.operations.add(operationItem.init(this.elements));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void getContracts() {
        ContractOpen contractOpen = (ContractOpen)BGClientBase.getFrame().getTabbedPane().getTab("findContract");
        if (contractOpen == null) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0414\u041e\u0413\u041e\u0412\u041e\u0420\u042b \u0432 \u043f\u0430\u043d\u0435\u043b\u0438 \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
        } else {
            ContractOpen.SearchData searchData = contractOpen.getSearchData();
            if (searchData != null && Utils.notEmptyCollection(searchData.getDataForUI())) {
                this.fillContracts(searchData.getDataForUI().stream().map(a -> new IdTitle(a.optInt("cid"), a.optString("contractTitle"))).toList());
            }
        }
    }

    public void getOpenedContracts() {
        List<JPanel> panels = BGClientBase.getFrame().getTabbedPane().getTabList();
        if (Utils.notEmptyCollection(panels)) {
            ArrayList<IdTitle> contracts = new ArrayList<IdTitle>();
            for (JPanel contractEditorPanel : panels.stream().filter(p -> p instanceof ContractEditor).toList()) {
                ContractEditor contractEditor = (ContractEditor)((Object)contractEditorPanel);
                contracts.add(new IdTitle(contractEditor.getContractId(), contractEditor.getContractTitle()));
            }
            this.fillContracts(contracts);
        }
    }

    private void fillContracts(List<IdTitle> contracts) {
        if (Utils.isEmptyCollection(contracts)) {
            return;
        }
        ArrayList items = new ArrayList();
        contracts.forEach(a -> items.add(new BGUListItem(a.getId(), a.getTitle(), true)));
        this.contractList.getList().setData(items);
        int size = contracts.size();
        if (size > 0) {
            BGSwingUtilites.wrapBorder((JPanel)this.contractList, (String)(" \u0414\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u0432 \u0441\u043f\u0438\u0441\u043a\u0435: " + contracts.size()));
        } else {
            BGSwingUtilites.wrapBorder((JPanel)this.contractList, (String)" \u0414\u043e\u0433\u043e\u0432\u043e\u0440\u044b ");
        }
    }

    private void loadFrom(String command) {
        boolean needConvertToIds = command.endsWith("_n");
        if (command.startsWith("file_")) {
            try {
                if (this.fileChooser.showOpenDialog() == 0) {
                    FileReader fileReader = new FileReader(this.fileChooser.getSelectedFile());
                    String contracts = this.parseFile(needConvertToIds, new BufferedReader(fileReader));
                    fileReader.close();
                    this.loadFromFile(needConvertToIds, contracts);
                }
            }
            catch (IOException ex) {
                ClientUtils.showErrorMessageDialog((String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0447\u0442\u0435\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430!");
            }
        } else if (command.startsWith("cb_")) {
            try {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                Transferable transferable = clipboard.getContents(null);
                if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    StringReader reader = new StringReader((String)transferable.getTransferData(DataFlavor.stringFlavor));
                    String contracts = this.parseFile(needConvertToIds, new BufferedReader(reader));
                    reader.close();
                    this.loadFromFile(needConvertToIds, contracts);
                }
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0437\u0431\u043e\u0440\u0430 \u0434\u0430\u043d\u043d\u044b\u0445!");
            }
        } else if (command.startsWith("sql_")) {
            ArrayList<String> list = new ArrayList<String>();
            new SQLDialog("SQL \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440", list, needConvertToIds).open();
            if (!list.isEmpty()) {
                try (StringReader reader = new StringReader(Utils.toString(list, (String)"\n"));){
                    String contracts = this.parseFile(needConvertToIds, new BufferedReader(reader));
                    this.loadFromFile(needConvertToIds, contracts);
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0430\u0437\u0431\u043e\u0440\u0430 \u0434\u0430\u043d\u043d\u044b\u0445!");
                }
            }
        }
    }

    private void loadFromFile(boolean needConvertToIds, String contracts) {
        this.tryCall(() -> this.fillContracts(((AdminService)((ClientContext)this.getContext()).getWebService(AdminService.class)).getContractEntries(contracts, needConvertToIds)));
    }

    private String parseFile(boolean needConvertToIds, BufferedReader reader) throws IOException {
        StringBuilder contracts = new StringBuilder();
        String delim = needConvertToIds ? "\n" : ",";
        boolean append = false;
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (append) {
                contracts.append(delim);
            }
            contracts.append(line);
            append = true;
        }
        return contracts.toString();
    }

    private boolean doOperation(String cids) {
        if (cids.isEmpty()) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u044b");
            return false;
        }
        List operations = this.operations.stream().filter(ContractGroupOperationItem::isOperationEnabled).collect(Collectors.toList());
        if (operations.size() == 1 && cids.length() < 20 && Utils.toIntegerList((String)cids).size() == 1) {
            for (ContractGroupOperationItem item : operations) {
                if (item.doItemOperation(cids)) continue;
                return false;
            }
        } else {
            for (ContractGroupOperationItem item : operations) {
                item.doItemOperation(cids);
            }
        }
        return true;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {});
    }

    public static abstract class ContractGroupOperationItem
    extends AbstractBGUPanel<ClientContext, BGUPanel> {
        protected Map<String, Element> elements;

        public ContractGroupOperationItem(LayoutManager layoutManager) {
            super(layoutManager, (Object)new ClientContext("admin", 0, 0, null, null));
        }

        public ContractGroupOperationItem(String module, int moduleId, LayoutManager layoutManager) {
            super(layoutManager, (Object)new ClientContext(module, moduleId, 0, null, null));
        }

        protected ContractGroupOperationItem init(Map<String, Element> elements) {
            this.elements = elements;
            return this;
        }

        protected void setData() {
        }

        protected void build() {
            super.build();
        }

        protected abstract boolean doItemOperation(String var1);

        protected JTextArea getTextArea(String text) {
            JTextArea textArea = new JTextArea();
            textArea.setEnabled(false);
            textArea.setWrapStyleWord(true);
            textArea.setLineWrap(true);
            textArea.setBackground(this.getBackground());
            textArea.setForeground(this.getForeground());
            textArea.setDisabledTextColor(this.getForeground());
            textArea.setText(text);
            return textArea;
        }

        protected abstract String getOperationTitle();

        protected boolean isOperationEnabled() {
            return this.isVisible();
        }
    }

    public static interface ContractGroupOperationFactory {
        public Collection<ContractGroupOperationItem> getContractGroupOperations(String var1, String var2);
    }

    class SQLDialog
    extends BGEditorDialog<List<String>> {
        private boolean flag;
        private JLabel commentLabel;
        private BGTextArea sqlQuery;

        public SQLDialog(String title, List<String> data, boolean flag) {
            super(title, data);
            this.flag = false;
            this.commentLabel = new JLabel();
            this.sqlQuery = new BGTextArea(10, 50);
            this.flag = flag;
            this.commentLabel.setFont(this.commentLabel.getFont().deriveFont(2).deriveFont(this.commentLabel.getFont().getSize2D() * 0.9f));
        }

        public void doDialogPanel() {
            String comment = this.flag ? "\u0412\u0432\u0435\u0434\u0438\u0442\u0435 SELECT \u0437\u0430\u043f\u0440\u043e\u0441 \u0441 \u043f\u043e\u043b\u0435\u043c 'title'" : "\u0412\u0432\u0435\u0434\u0438\u0442\u0435 SELECT \u0437\u0430\u043f\u0440\u043e\u0441 \u0441 \u043f\u043e\u043b\u0435\u043c 'id'";
            this.commentLabel.setText(comment);
            this.addFieldV("SQL \u0437\u0430\u043f\u0440\u043e\u0441:", BGSwingUtilites.wrapScrollPane((JComponent)this.sqlQuery, (int)700, (int)200));
            this.panel.add((Component)this.commentLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 5, 3), 0, 0));
        }

        public boolean doApply() throws Exception {
            ((List)this.data).clear();
            ((List)this.data).addAll(((AdminService)((ClientContext)ContractGroupOperation.this.getContext()).getWebService(AdminService.class)).getContractEntriesFromSqlQuery(this.sqlQuery.getText().trim(), this.flag ? FieldNameSQL.TITLE : FieldNameSQL.ID));
            return true;
        }
    }
}

