/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.script.server.service;

import jakarta.jws.WebService;
import java.util.List;
import java.util.Optional;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.script.common.ScriptFunctionModifiedEvent;
import ru.bitel.bgbilling.kernel.script.common.bean.Revision;
import ru.bitel.bgbilling.kernel.script.common.bean.ScriptBackup;
import ru.bitel.bgbilling.kernel.script.common.bean.ScriptLibrary;
import ru.bitel.bgbilling.kernel.script.common.service.ScriptService;
import ru.bitel.bgbilling.kernel.script.server.bean.ScriptBackupManager;
import ru.bitel.bgbilling.kernel.script.server.bean.ScriptLibraryManager;
import ru.bitel.common.Utils;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.script.common.service.ScriptService")
public class ScriptServiceImpl
extends AbstractService
implements ScriptService {
    private ScriptBackupManager scriptBackupManager;
    private ScriptLibraryManager scriptLibraryManager;

    @Override
    public List<ScriptLibrary> list() throws BGException {
        return this.tryReturn(() -> this.getScriptLibraryManager().list());
    }

    @Override
    public List<ScriptLibrary> pureList() throws BGException {
        return this.tryReturn(() -> this.getScriptLibraryManager().pureList());
    }

    @Override
    public ScriptLibrary getLibrary(int scriptId) throws BGException {
        return this.tryReturn(() -> (ScriptLibrary)this.getScriptLibraryManager().get(scriptId));
    }

    @Override
    public Revision getRevision(int scriptId) throws BGException {
        return this.tryReturn(() -> this.getScriptLibraryManager().getRevisionProperties(scriptId));
    }

    @Override
    public void deleteLibrary(int scriptId) throws BGException {
        this.tryCall(() -> this.getScriptLibraryManager().deleteFull(scriptId));
    }

    @Override
    public int test(int value) {
        return value + 1;
    }

    @Override
    public Revision update(ScriptLibrary lib) throws BGException {
        return this.tryReturn(() -> {
            if (Utils.isBlankString(lib.getName())) {
                throw new BGMessageException("\u041f\u043e\u043b\u0435 '\u0418\u043c\u044f' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c.");
            }
            if (Utils.isBlankString(lib.getTitle())) {
                throw new BGMessageException("\u041f\u043e\u043b\u0435 '\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c.");
            }
            this.getScriptLibraryManager().update(lib);
            this.context.publishAfterCommit(new ScriptFunctionModifiedEvent(0));
            return lib.getRevision();
        });
    }

    @Override
    public void backup(ScriptBackup backup) throws BGException {
        this.tryCall(() -> {
            backup.setId(-1);
            backup.setUserId(this.userId);
            this.getScriptBackupManager().update(backup);
        });
    }

    @Override
    public List<ScriptBackup> listBackup(int scriptId, int type) throws BGException {
        return this.tryReturn(() -> this.getScriptBackupManager().list(scriptId, type));
    }

    @Override
    public void deleteBackup(int backupId) throws BGException {
        this.tryCall(() -> this.getScriptBackupManager().delete(backupId));
    }

    @Override
    public ScriptBackup getBackup(int backupId) throws BGException {
        return this.tryReturn(() -> (ScriptBackup)this.getScriptBackupManager().get(backupId));
    }

    private ScriptLibraryManager getScriptLibraryManager() {
        this.scriptLibraryManager = new ScriptLibraryManager(this.getConnection());
        return Optional.ofNullable(this.scriptLibraryManager).orElse(this.scriptLibraryManager);
    }

    private ScriptBackupManager getScriptBackupManager() {
        this.scriptBackupManager = new ScriptBackupManager(this.getConnection());
        return Optional.ofNullable(this.scriptBackupManager).orElse(this.scriptBackupManager);
    }
}

