/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractGroup;
import ru.bitel.common.dao.AbstractDirectoryIdDao;

public class ContractGroupDao
extends AbstractDirectoryIdDao<ContractGroup> {
    public ContractGroupDao(Connection con) {
        super(con, 0, "contract_group");
    }

    protected ContractGroup getFromRS(ResultSet rs) throws SQLException, BGException {
        return new ContractGroup(rs.getInt("id"), rs.getString("title")).setEnabled(rs.getBoolean("enable")).setEditable(rs.getBoolean("editable")).setComment(rs.getString("comment"));
    }

    protected void updateImpl(ContractGroup contractGroup) throws BGException, SQLException {
        if (contractGroup == null || contractGroup.getTitle() == null || contractGroup.getId() < 0) {
            throw new BGIllegalArgumentException();
        }
        PreparedStatement ps = this.con.prepareStatement("UPDATE contract_group SET title=?, enable=?, editable=?, comment=? WHERE id=?");
        ps.setString(1, contractGroup.getTitle());
        ps.setInt(2, contractGroup.isEnabled() ? 1 : 0);
        ps.setInt(3, contractGroup.isEditable() ? 1 : 0);
        ps.setString(4, contractGroup.getComment());
        ps.setInt(5, contractGroup.getId());
        boolean updated = ps.executeUpdate() > 0;
        ps.close();
        if (!updated && contractGroup.getId() >= 0 && contractGroup.getId() < 64) {
            ps = this.con.prepareStatement("INSERT INTO contract_group SET title=?, enable=?, editable=?, comment=?, id=?");
            ps.setString(1, contractGroup.getTitle());
            ps.setInt(2, contractGroup.isEnabled() ? 1 : 0);
            ps.setInt(3, contractGroup.isEditable() ? 1 : 0);
            ps.setString(4, contractGroup.getComment());
            ps.setInt(5, contractGroup.getId());
            ps.executeUpdate();
            ps.close();
        }
    }

    public List<ContractGroup> list() throws BGException {
        List list = super.list(null, null, new Object[0]);
        HashMap<Integer, ContractGroup> map = new HashMap<Integer, ContractGroup>();
        for (ContractGroup contractGroup : list) {
            map.put(contractGroup.getId(), contractGroup);
        }
        list = null;
        ArrayList<ContractGroup> result = new ArrayList<ContractGroup>(64);
        for (int index = 0; index < 63; ++index) {
            ContractGroup contractGroup = (ContractGroup)map.get(index);
            if (contractGroup == null) {
                contractGroup = new ContractGroup(index, "\u0413\u0440\u0443\u043f\u043f\u0430 " + String.format("%1$02d", index)).setEnabled(false).setEditable(true).setComment("");
            }
            result.add(contractGroup);
        }
        return result;
    }

    public List<ContractGroup> list(boolean all) throws BGException {
        return this.list(all, "id");
    }

    public List<ContractGroup> list(boolean all, String order) throws BGException {
        if (all) {
            return this.list();
        }
        if (order == null) {
            order = "title";
        }
        return super.list("enable=?", order, new Object[]{1});
    }

    public int delete(int id) throws SQLException {
        int result = 0;
        String query = "UPDATE contract SET gr=gr^(1<<?) WHERE (gr&(1<<?))>0";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, id);
            ps.setInt(index++, id);
            result = ps.executeUpdate();
        }
        return result;
    }

    public ContractGroup get(String title) throws BGException {
        return (ContractGroup)this.get("title=?", new Object[]{title});
    }

    public ContractGroup get(int id) throws BGException {
        ContractGroup contractGroup = (ContractGroup)super.get(id);
        if (contractGroup != null) {
            return contractGroup;
        }
        if (id >= 0 && id < 63) {
            contractGroup = new ContractGroup(id, "\u0413\u0440\u0443\u043f\u043f\u0430 " + String.format("%1$02d", id)).setEnabled(false).setEditable(true).setComment("");
        }
        return contractGroup;
    }
}

