<?xml version="1.0" encoding="UTF-8"?><!DOCTYPE xsl:stylesheet  [
	<!ENTITY nbsp   "&#160;">
	<!ENTITY copy   "&#169;">
	<!ENTITY reg    "&#174;">
	<!ENTITY trade  "&#8482;">
	<!ENTITY mdash  "&#8212;">
	<!ENTITY ldquo  "&#8220;">
	<!ENTITY rdquo  "&#8221;"> 
	<!ENTITY pound  "&#163;">
	<!ENTITY yen    "&#165;">
	<!ENTITY euro   "&#8364;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:svg="http://www.w3.org/2000/svg"
	xmlns:xalan="http://xml.apache.org/xalan"
	xmlns:bgcustomer="ru.bitel.bgbilling.kernel.contract.api.common.util.CustomerUtil">

	<xalan:component prefix="bgcustomer" functions="getValue">
		<xalan:script lang="javaclass" src="xalan://ru.bitel.bgbilling.kernel.contract.api.common.util.CustomerUtil"/>
  	</xalan:component>

	<xsl:output encoding="UTF-8" method='xml' indent='yes' />

	<xsl:attribute-set name="text">
		<xsl:attribute name="font-family">arial</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="font-size">12pt</xsl:attribute>
		<xsl:attribute name="start-indent">0.1cm</xsl:attribute>
		<xsl:attribute name="end-indent">0.1cm</xsl:attribute>
		<xsl:attribute name="text-decoration">none</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="text11_bold">
		<xsl:attribute name="font-family">arial</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="font-size">11pt</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="text_underlined">
		<xsl:attribute name="text-decoration">underline</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="text_ban">
		<xsl:attribute name="text-align">right</xsl:attribute>
		
		<xsl:attribute name="font-size">6pt</xsl:attribute>
		<xsl:attribute name="start-indent">0.1cm</xsl:attribute>
		<xsl:attribute name="end-indent">0.1cm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text_bold">
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="font-family">arial</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">12pt</xsl:attribute>
		<xsl:attribute name="start-indent">0.1cm</xsl:attribute>
		<xsl:attribute name="end-indent">0.1cm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text_title">
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="font-family">arial</xsl:attribute>
		
		<xsl:attribute name="font-size">14pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="start-indent">0.1cm</xsl:attribute>
		<xsl:attribute name="end-indent">0.1cm</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="text_italic">
		<xsl:attribute name="text-align">left</xsl:attribute>
		
		<xsl:attribute name="font-size">12pt</xsl:attribute>
		<xsl:attribute name="start-indent">0.1cm</xsl:attribute>
		<xsl:attribute name="end-indent">0.1cm</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="cell_border">
		<xsl:attribute name="border-width">0.7pt</xsl:attribute>
		<xsl:attribute name="border-top-style">solid</xsl:attribute>
		<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
		<xsl:attribute name="border-left-style">solid</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>
		<xsl:attribute name="padding-top">0.1cm</xsl:attribute>
		<xsl:attribute name="padding-top">0.1cm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:template match="/card">
	
		<xsl:variable name="contractId" select="number(contract/@cid)" />
		<xsl:variable name="contract_title" select="contract/@title" />
		<xsl:variable name="contract_comment" select="contract/@comment" />
		<xsl:variable name="fio" select="parameters/parameter[@pid=4]/@value" />
		<xsl:variable name="address" select="parameters/parameter[@pid=19]/@value" />
		<xsl:variable name="phone" select="parameters/parameter[@pid=6]/@value" />
		<xsl:variable name="email" select="parameters/parameter[@pid=20]/@value" />
		<xsl:variable name="tariff_plan" select="contract/tariff/@tariff_plan" />
		<xsl:variable name="pswd" select="contract/@pswd" />
		
		<xsl:variable name="inet_title" select="'Internet'" />
		<xsl:variable name="inet_mid" select="'6'" />
		
		<xsl:variable name="email_title" select="'Email'" />
		<xsl:variable name="email_mid" select="'1'" />
	
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master margin-right="1cm"
					margin-left="1.5cm" margin-bottom="0.7cm" margin-top="0.8cm"
					page-width="21cm" page-height="29.7cm" master-name="first">
					<fo:region-body margin-top="0.0cm"
						margin-bottom="0.0cm" />
					<fo:region-before extent="0.0cm" />
					<fo:region-after extent="0.0cm" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<fo:page-sequence master-reference="first">

				<!-- footer -->
				<!-- 

				<xsl:value-of select="bgcustomer:getValue( $contractId, '/customer/inn', 'н/д' )" />

				<fo:static-content flow-name="xsl-region-after">
					<fo:block font-size="10pt"
						text-align="end" xsl:use-attribute-sets="text">
						Страница
						<fo:page-number />
					</fo:block>
				</fo:static-content>
				 -->
				<!-- footer -->

				<fo:flow flow-name="xsl-region-body">

					<!-- заголовок -->
					<fo:block xsl:use-attribute-sets="text_title" space-after="0.5cm">
				 		Карта регистрации к договору <xsl:value-of select="$contract_title"/> (<xsl:value-of select="$contract_comment"/>)
					</fo:block>
					<!-- заголовок -->
				
					<fo:table table-layout="fixed">
							
						<fo:table-column column-width="6.5cm"/>
						<fo:table-column column-width="proportional-column-width(1)"/>
							
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="text">ФИО:</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="text_bold" text-align="left">
										<xsl:value-of select="$fio"/>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							
							
							<fo:table-row>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="text">Телефон(ы):</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="text_bold" text-align="left">
										<xsl:value-of select="$phone"/>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>	
							
							
							<fo:table-row>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="text">Адрес:</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="text_bold" text-align="left">
										<xsl:value-of select="$address"/>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							
							
							<fo:table-row>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="text">E-mail (рассылка):</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="text_bold" text-align="left">
										<xsl:value-of select="$email"/>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>	
							
							
							<fo:table-row>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="text">Тарифный план</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="text_bold" text-align="left">
										<xsl:value-of select="$tariff_plan"/>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>


							<fo:table-row>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="text">Пароль доступа к статистике:</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="text_bold" text-align="left">
										<xsl:value-of select="$pswd"/>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

						</fo:table-body>
					</fo:table>
					
					<!-- таблица логинов -->
					<xsl:call-template name="login_table">
					
						<xsl:with-param name="inet_title" select="$inet_title" />
						<xsl:with-param name="inet_mid" select="$inet_mid" />
		
						<xsl:with-param name="email_title" select="$email_title" />
						<xsl:with-param name="email_mid" select="$email_mid" />
					
					</xsl:call-template>
					<!-- таблица логинов -->




					<!-- примечание -->
					<fo:block xsl:use-attribute-sets="text_bold">
						Примечание: _______________________________________________________
					</fo:block>
					<!-- примечание -->
					
					
					<!-- печать -->
					<xsl:call-template name="stamp"/>
					<!-- печать -->


					<!-- линия отреза -->
					<fo:table table-layout="fixed" space-before="0.7cm" space-after="0.7cm">

						<fo:table-column column-width="proportional-column-width(1)"/>
							
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell border-bottom-style="solid" border-bottom-width="0.02cm">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
						
					</fo:table>
					<!-- линия отреза -->
					
					
					<!-- заголовок -->
					<fo:block xsl:use-attribute-sets="text_title">
				 		Карта регистрации к договору <xsl:value-of select="$contract_title"/> (<xsl:value-of select="$contract_comment"/>)
					</fo:block>
					<fo:block xsl:use-attribute-sets="text" space-after="0.5cm" text-align="center">
				 		(для абонента)
					</fo:block>
					<!-- заголовок -->
			
				
					<fo:table table-layout="fixed">
							
						<fo:table-column column-width="6.5cm"/>
						<fo:table-column column-width="proportional-column-width(1)"/>
							
						<fo:table-body>
						
						
							<fo:table-row>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="text">
										Договор №:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="text_bold" text-align="left">
										<xsl:value-of select="$contract_title"/>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>	


							<fo:table-row>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="text">
										ФИО:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="text_bold" text-align="left">
										<xsl:value-of select="$fio"/>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>


							<fo:table-row>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="text">
										Тарифный план
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="text_bold" text-align="left">
										<xsl:value-of select="$tariff_plan"/>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>


							<fo:table-row>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="text">
										Пароль доступа к статистике:
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="text_bold" text-align="left">
										<xsl:value-of select="$pswd"/>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

						</fo:table-body>
					</fo:table>
					
					
					<!-- таблица логинов -->
					<xsl:call-template name="login_table">
					
						<xsl:with-param name="inet_title" select="$inet_title" />
						<xsl:with-param name="inet_mid" select="$inet_mid" />
		
						<xsl:with-param name="email_title" select="$email_title" />
						<xsl:with-param name="email_mid" select="$email_mid" />
					
					</xsl:call-template>
					<!-- таблица логинов -->
					
					
					
					<fo:block xsl:use-attribute-sets="text" space-after="0.5cm">
					Электронный адрес (e-mail)  <fo:inline xsl:use-attribute-sets="text_bold"><xsl:value-of select="$email"/></fo:inline>
					</fo:block>
					
					<!-- примечание -->
					<fo:block xsl:use-attribute-sets="text" space-after="0.3cm">
					<fo:inline xsl:use-attribute-sets="text_underlined">Техническая поддержка (круглосуточно)</fo:inline>: XXX-XXX, <fo:inline xsl:use-attribute-sets="text_underlined">XXXXX@XXXXXX.ru</fo:inline>
					</fo:block>
					
					<fo:block xsl:use-attribute-sets="text">
					<fo:inline xsl:use-attribute-sets="text_underlined">Информация о наработке и состоянии Вашего лицевого счета, статистика подключений</fo:inline>: http://www.XXXXXX.ru/, раздел «Клиентам», раздел «СТАТИСТИКА», подраздел «Выделенный канал»
					</fo:block>
					<!-- примечание -->
					
					
					<!-- печать -->
					<xsl:call-template name="stamp"/>
					<!-- печать -->


				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	
	
	
	<xsl:template name="login_row">
    	<xsl:param name="title"/>
    	<xsl:param name="login"/>
    	<xsl:param name="pswd"/>
		
			<fo:table-row>
				<fo:table-cell xsl:use-attribute-sets="cell_border">
					<fo:block xsl:use-attribute-sets="text" text-align="center">
						<xsl:value-of select="$title"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell xsl:use-attribute-sets="cell_border">
					<fo:block xsl:use-attribute-sets="text_bold" text-align="center">
						<xsl:value-of select="$login"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell xsl:use-attribute-sets="cell_border">
					<fo:block xsl:use-attribute-sets="text_bold" text-align="center">
						<xsl:value-of select="$pswd"/>
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
		
	</xsl:template>
	
	
	<xsl:template name="login_table">
	
		<xsl:param name="inet_mid"/>
		<xsl:param name="inet_title"/>
		<xsl:param name="email_mid"/>
		<xsl:param name="email_title"/>
	
		<fo:table table-layout="fixed" space-before="0.4cm" space-after="0.5cm">
							
			<fo:table-column column-width="4cm"/>
			<fo:table-column column-width="proportional-column-width(1)"/>
			<fo:table-column column-width="proportional-column-width(1)"/>
			
			<fo:table-header>
				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="cell_border">
					     <fo:block/>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="cell_border" start-indent="1cm">
						<fo:block xsl:use-attribute-sets="text" text-align="center">
							LOGIN
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="cell_border">
						<fo:block xsl:use-attribute-sets="text" text-align="center">
							PASS
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-header>
		
				
			<fo:table-body>

	
			<!--
				<xsl:for-each select="module/*[name()=concat( 'user_login_', $inet_mid )]">
					<xsl:call-template name="login_row">
						<xsl:with-param name="title" select="$inet_title"/> 
						<xsl:with-param name="login" select="@login"/> 
					<xsl:with-param name="pswd" select="@pswd"/> 
					</xsl:call-template>
				</xsl:for-each>
				
				
				<xsl:for-each select="module/*[name()=concat( 'email_account_', $email_mid )]">
					<xsl:call-template name="login_row">
						<xsl:with-param name="title" select="$email_title"/> 
						<xsl:with-param name="login" select="@account"/> 
						<xsl:with-param name="pswd" select="@password"/> 
					</xsl:call-template>
				</xsl:for-each>
			-->
			
			
				<xsl:call-template name="login_row">
					<xsl:with-param name="title" select="$inet_title"/> 
					<xsl:with-param name="login" select="module/*[name()=concat( 'inet_serv_', $inet_mid )]/@login"/>
					<xsl:with-param name="pswd" select="module/*[name()=concat( 'inet_serv_', $inet_mid )]/@password"/>
				</xsl:call-template>
				
				

				<xsl:call-template name="login_row">
					<xsl:with-param name="title" select="$email_title"/> 
					<xsl:with-param name="login" select="module/*[name()=concat( 'email_account_', $email_mid )]/@account"/> 
					<xsl:with-param name="pswd" select="module/*[name()=concat( 'email_account_', $email_mid )]/@password"/> 
				</xsl:call-template>
				
				
			</fo:table-body>
			
		</fo:table>
		
	</xsl:template>
	
	
	<xsl:template name="stamp">
					<!-- печать -->
					<fo:table table-layout="fixed" space-before="0.5cm" start-indent="0.5cm">
							
						<fo:table-column column-width="proportional-column-width(1)"/>
						<fo:table-column column-width="proportional-column-width(1)"/>
							
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="text11_bold">
										Оператор
									</fo:block>
									<fo:block xsl:use-attribute-sets="text11_bold" space-before="0.3cm">
										Директор направления Интернет 
									</fo:block>
									<fo:block xsl:use-attribute-sets="text11_bold">
										ОАО «XXXXXXXX» 
									</fo:block>
									<fo:block xsl:use-attribute-sets="text11_bold">
										______________/X.X.XXXXXXXX
									</fo:block>
									<fo:block xsl:use-attribute-sets="text11_bold">
										«_____» ____________  2006 г. 
									</fo:block>
									<fo:block xsl:use-attribute-sets="text11_bold">
										М.П.
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="text11_bold">
										Абонент
									</fo:block>
									<fo:block xsl:use-attribute-sets="text11_bold" space-before="0.3cm">
										&nbsp;
									</fo:block>
									<fo:block xsl:use-attribute-sets="text11_bold">
										___________________________
									</fo:block>
									<fo:block xsl:use-attribute-sets="text11_bold">
										______________/____________
									</fo:block>
									<fo:block xsl:use-attribute-sets="text11_bold">
										«_____» ____________  2006 г. 
									</fo:block>
									<fo:block xsl:use-attribute-sets="text11_bold">
										М.П.
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
						
					</fo:table>
					<!-- печать -->
	</xsl:template>
	
	
	
</xsl:stylesheet>
