/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.service.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriod;
import ru.bitel.bgbilling.client.common.BGSplitPane;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.oss.kernel.entity.client.EntityAttributesForm;
import ru.bitel.oss.systems.inventory.service.client.ServiceSpecPanel;
import ru.bitel.oss.systems.inventory.service.common.bean.ServiceSpec;

public class ServiceSpecForm
extends BGUPanel {
    private final ServiceSpecPanel serviceSpecPanel;
    protected JTabbedPane pane;
    protected List<BGUPanel> panels = new ArrayList<BGUPanel>(5);
    protected List<BGUPanel> linkPanels = new ArrayList<BGUPanel>(5);
    protected AtomicReference<ServiceSpec> currentRef = new AtomicReference();
    private BGTextField title = new BGTextField();
    private BGTextField identifier = new BGTextField();
    private BGControlPanelPeriod period = new BGControlPanelPeriod();
    private JTextArea comment = new JTextArea();
    private JTextArea description = new JTextArea();

    public ServiceSpecForm(ServiceSpecPanel productSpecPanel, ClientContext context) {
        super((LayoutManager)new BorderLayout(), context);
        this.serviceSpecPanel = productSpecPanel;
        this.setName("ServiceSpecForm");
    }

    @Override
    protected void jbInit() throws Exception {
        BGSwingUtilites.wrapBorder(this, "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0441\u0435\u0440\u0432\u0438\u0441\u0430");
        this.pane = new JTabbedPane();
        this.add((Component)this.pane, "Center");
        BGSplitPane splitPane = new BGSplitPane();
        JPanel leftPanel = new JPanel(new GridBagLayout());
        BGSwingUtilites.wrapEmptyBorder(leftPanel);
        leftPanel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        leftPanel.add((Component)this.title, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        leftPanel.add((Component)new JLabel("\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440:"), new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 5), 0, 0));
        leftPanel.add((Component)this.identifier, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        leftPanel.add((Component)this.period, new GridBagConstraints(0, 5, 3, 1, 1.0, 0.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        leftPanel.add(Box.createVerticalGlue(), new GridBagConstraints(0, 6, 3, 1, 0.0, 1.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        splitPane.setLeftComponent(leftPanel);
        JPanel rightPanel = new JPanel(new GridBagLayout());
        BGSwingUtilites.wrapEmptyBorder(rightPanel);
        rightPanel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        rightPanel.add((Component)new JScrollPane(this.comment), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        rightPanel.add((Component)new JLabel("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        rightPanel.add((Component)new JScrollPane(this.description), new GridBagConstraints(0, 3, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        splitPane.setRightComponent(rightPanel);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)splitPane, "Center");
        this.pane.addTab("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b", panel);
        EntityAttributesForm bguPanel = new EntityAttributesForm(this.currentRef, (ClientContext)this.getContext());
        this.panels.add(bguPanel);
        this.pane.addTab("\u0410\u0442\u0440\u0438\u0431\u0443\u0442\u044b", bguPanel);
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionNew(e -> {
            ServiceSpec current = new ServiceSpec();
            current.setId(-1);
            current.setEntitySpecId(this.serviceSpecPanel.getEntitySpecId());
            current.setEntityAttributes(new HashMap());
            ServiceSpec parent = (ServiceSpec)this.serviceSpecPanel.getServiceSpecTreeTableModel().getSelectedRow();
            if (parent != null) {
                current.setParentId(parent.getId());
            }
            this.title.setText("");
            this.identifier.setText("");
            this.period.setDateCalendar1(null);
            this.period.setDateCalendar2(null);
            this.comment.setText("");
            this.description.setText("");
            this.currentRef.set(current);
            for (BGUPanel panel : this.panels) {
                panel.performAction("new");
            }
            for (BGUPanel panel : this.linkPanels) {
                panel.performAction("new");
            }
            this.performActionOpen();
        });
        new AbstractBGUPanel.BGActionEdit(e -> {
            if (this.serviceSpecPanel.getServiceSpecTreeTableModel().getSelectedRow() != this.serviceSpecPanel.getServiceSpecTreeTableModel().getRoot()) {
                ServiceSpec current = (ServiceSpec)this.serviceSpecPanel.getServiceSpecTreeTableModel().getSelectedRow();
                current = this.serviceSpecPanel.getServiceService().serviceSpecGet(current.getId());
                if (current != null) {
                    this.title.setText(current.getTitle());
                    this.identifier.setText(current.getIdentifier());
                    this.period.setDateFrom(current.getDateFrom());
                    this.period.setDateTo(current.getDateTo());
                    this.comment.setText(current.getComment());
                    this.description.setText(current.getDescription());
                    current.setEntitySpecId(this.serviceSpecPanel.getEntitySpecId());
                }
                this.currentRef.set(current);
                for (BGUPanel panel : this.panels) {
                    panel.performAction("edit");
                }
                for (BGUPanel panel : this.linkPanels) {
                    panel.performAction("edit");
                }
                this.performActionOpen();
            }
        });
        new AbstractBGUPanel.BGActionDelete(e -> {
            if (!this.isEnabled()) {
                ClientUtils.showErrorMessageDialog("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430");
                return;
            }
            ServiceSpec selected = (ServiceSpec)this.serviceSpecPanel.getServiceSpecTreeTableModel().getSelectedRow();
            if (selected == null || selected == this.serviceSpecPanel.getServiceSpecTreeTableModel().getRoot()) {
                ClientUtils.showMessageDialog("\u0421\u0435\u0440\u0432\u0438\u0441 \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d");
                return;
            }
            if (selected.getChildren() != null) {
                ClientUtils.showMessageDialog("\u0421\u043d\u0430\u0447\u0430\u043b\u0430 \u0443\u0434\u0430\u043b\u0438\u0442\u0435 \u0434\u043e\u0447\u0435\u0440\u043d\u0438\u0435 \u0441\u0435\u0440\u0432\u0438\u0441\u044b");
                return;
            }
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u0442\u043e\u0442 \u0441\u0435\u0440\u0432\u0438\u0441?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f", 0) == 0) {
                for (BGUPanel panel : this.linkPanels) {
                    if (panel.performAction("delete")) continue;
                    return;
                }
                this.serviceSpecPanel.getServiceService().serviceSpecDelete(selected.getId());
                this.serviceSpecPanel.getServiceSpecTreeTableModel().setSelectedRow(selected.getParentId());
                this.serviceSpecPanel.performAction("refresh");
            }
        });
        new AbstractBGUPanel.DefaultAction("ok", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0441\u0435\u0440\u0432\u0438\u0441"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                ServiceSpec current = ServiceSpecForm.this.currentRef.get();
                current.setModuleId(((ClientContext)ServiceSpecForm.this.getContext()).getModuleId());
                current.setTitle(ServiceSpecForm.this.title.getText());
                current.setIdentifier(ServiceSpecForm.this.identifier.getText());
                current.setDateFrom(ServiceSpecForm.this.period.getDateFrom());
                current.setDateTo(ServiceSpecForm.this.period.getDateTo());
                current.setComment(ServiceSpecForm.this.comment.getText());
                current.setDescription(ServiceSpecForm.this.description.getText());
                for (BGUPanel panel : ServiceSpecForm.this.panels) {
                    if (panel.performAction("ok")) continue;
                    return;
                }
                int id = ServiceSpecForm.this.serviceSpecPanel.getServiceService().serviceSpecUpdate(current);
                current.setId(id);
                for (BGUPanel panel : ServiceSpecForm.this.linkPanels) {
                    if (panel.performAction("ok")) continue;
                    return;
                }
                ServiceSpecForm.this.serviceSpecPanel.performAction("refresh");
                ServiceSpecForm.this.serviceSpecPanel.getServiceSpecTreeTableModel().setSelectedRow(id);
                ServiceSpecForm.this.performActionClose();
            }
        };
        final HashSet cutSet = new HashSet();
        new AbstractBGUPanel.MenuAction("ServiceSpec.cut", "\u0412\u044b\u0440\u0435\u0437\u0430\u0442\u044c", (Icon)ClientUtils.getIcon("cut")){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                cutSet.clear();
                List selectedRows = ServiceSpecForm.this.serviceSpecPanel.getServiceSpecTreeTableModel().getSelectedRows();
                if (selectedRows == null) {
                    return;
                }
                for (ServiceSpec d : selectedRows) {
                    cutSet.add(d.getId());
                }
            }
        };
        new AbstractBGUPanel.MenuAction("ServiceSpec.paste", "\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c", (Icon)ClientUtils.getIcon("paste")){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                ServiceSpec parent = (ServiceSpec)ServiceSpecForm.this.serviceSpecPanel.getServiceSpecTreeTableModel().getSelectedRow();
                if (parent != null && cutSet.size() > 0) {
                    ServiceSpecForm.this.serviceSpecPanel.getServiceService().serviceSpecMove(parent.getId(), cutSet);
                    cutSet.clear();
                    ServiceSpecForm.this.serviceSpecPanel.performAction("refresh");
                }
            }
        };
    }
}

