/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffGroup;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffLabelItem;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffPlan;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffPlanSearchParameters;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffVar;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffVarType;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffVarValue;
import ru.bitel.bgbilling.kernel.tariff.common.event.TariffVarModifiedEvent;
import ru.bitel.bgbilling.kernel.tariff.common.service.TariffService;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffLabelManager;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffPlanDao;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffVarDao;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffVarValueDao;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.tariff.common.service.TariffService")
public class TariffServiceImpl
extends AbstractService
implements TariffService {
    private TariffVarValueDao tariffVarValueDao;

    @PostConstruct
    private void init() {
        this.tariffVarValueDao = new TariffVarValueDao(this.getConnection());
    }

    @Override
    public SearchResult<TariffPlan> searchTariffPlans(TariffPlanSearchParameters searchParameters, String[] sort, Page page) throws BGException {
        SearchResult<TariffPlan> searchResult = new SearchResult<TariffPlan>(page, sort);
        try (TariffPlanDao tariffPlanDao = new TariffPlanDao(this.getConnection());){
            tariffPlanDao.searchTariffPlans(searchResult, searchParameters);
        }
        return searchResult;
    }

    @Override
    public List<TariffPlan> tariffPlanList(List<Integer> contractLabelIds, Integer personType, String title) throws BGException {
        return this.tryReturn(() -> {
            if ((contractLabelIds == null || contractLabelIds.isEmpty()) && (personType == null || personType < 0) && Utils.isEmptyString(title)) {
                return this.context.newDirectory(TariffPlan.class, 0).list();
            }
            try (TariffPlanDao tariffPlanDao = new TariffPlanDao(this.getConnection());){
                List<TariffPlan> list = tariffPlanDao.getTariffPlanList(0, contractLabelIds, personType, title);
                return list;
            }
        });
    }

    @Override
    public List<IdTitle> tariffPlanTitles() throws BGException {
        return this.tryReturn(() -> this.context.getDirectory(TariffPlan.class, 0).list().stream().map(IdTitle::toIdTitle).toList());
    }

    @Override
    public TariffPlan tariffPlanGet(int id) throws BGException {
        return this.context.getDirectory(TariffPlan.class, 0).get(id);
    }

    @Override
    public void tariffPlanDelete(int id) throws BGException {
        this.tryCall(() -> this.context.newDirectory(TariffPlan.class, 0).delete(id));
    }

    @Override
    public int tariffPlanUpdate(TariffPlan tariffPlan) throws BGException {
        return this.tryReturn(() -> {
            this.context.getDirectory(TariffPlan.class, 0).update(tariffPlan);
            return tariffPlan.getId();
        });
    }

    @Override
    public TariffGroup tariffGroupGet(int id) throws BGException {
        return this.context.getDirectory(TariffGroup.class, 0).get(id);
    }

    @Override
    public void tariffGroupDelete(int id) throws BGException {
        this.tryCall(() -> this.context.getDirectory(TariffGroup.class, 0).delete(id));
    }

    @Override
    public int tariffGroupUpdate(TariffGroup tariffGroup) throws BGException {
        return this.tryReturn(() -> {
            this.context.newDirectory(TariffGroup.class, 0).update(tariffGroup);
            return tariffGroup.getId();
        });
    }

    @Override
    public List<TariffGroup> tariffGroupList() throws BGException {
        return this.tryReturn(() -> this.context.newDirectory(TariffGroup.class, 0).list());
    }

    @Override
    public List<TariffVar> tariffVars(TariffVarType tariffVarType, List<Integer> tariffPlanIds) throws BGException {
        return this.tryReturn(() -> new TariffVarDao(this.getConnection()).list(tariffVarType, tariffPlanIds));
    }

    @Override
    public TariffVar tariffVarGet(int tariffVarId) throws BGException {
        return this.tryReturn(() -> (TariffVar)new TariffVarDao(this.getConnection()).get(tariffVarId));
    }

    @Override
    public int tariffVarUpdate(TariffVar tariffVar) throws BGException {
        return this.tryReturn(() -> {
            int tariffVarId = new TariffVarDao(this.getConnection()).updateTariffVar(tariffVar);
            EventProcessor.getInstance().publish(new TariffVarModifiedEvent(tariffVarId));
            return tariffVarId;
        });
    }

    @Override
    public int tariffVarDelete(int tariffVarId) throws BGException {
        return this.tryReturn(() -> {
            this.tariffVarValueDao.deleteTariffVarValues(tariffVarId);
            int result = new TariffVarDao(this.getConnection()).delete(tariffVarId);
            EventProcessor.getInstance().publish(new TariffVarModifiedEvent(tariffVarId));
            return result;
        });
    }

    @Override
    public List<IdTitle> tariffVarListItems(int moduleId, String varTypeCode) throws BGException {
        return this.tryReturn(() -> {
            Map<String, Object> resultMap;
            ArrayList result = new ArrayList();
            if ("inet_option".equals(varTypeCode) && !(resultMap = EventProcessor.getInstance().doCrossComponentQuery(null, moduleId, "tariffVarListOptionItems", moduleId)).isEmpty()) {
                resultMap.values().forEach(a -> result.addAll((List)a));
            }
            return result;
        });
    }

    @Override
    public SearchResult<TariffVarValue> tariffVarValues(int tariffVarId, Page page) throws BGException {
        return this.tryReturn(() -> {
            SearchResult<TariffVarValue> searchResult = new SearchResult<TariffVarValue>(page);
            this.tariffVarValueDao.searchTariffVarValue(searchResult, tariffVarId);
            return searchResult;
        });
    }

    @Override
    public void tariffVarValueSet(TariffVarValue tariffVarValue) throws BGException {
        this.tryCall(() -> {
            this.tariffVarValueDao.update(tariffVarValue);
            EventProcessor.getInstance().publish(new TariffVarModifiedEvent(tariffVarValue.getTariffVarId()));
        });
    }

    @Override
    public int tariffVarValueDelete(TariffVarValue tariffVarValue) throws BGException {
        return this.tryReturn(() -> {
            int result = this.tariffVarValueDao.deleteTariffVarValue(tariffVarValue);
            EventProcessor.getInstance().publish(new TariffVarModifiedEvent(tariffVarValue.getTariffVarId()));
            return result;
        });
    }

    @Override
    public List<TariffLabelItem> getTariffLabelTreeItemList(int tariffPlanId) throws BGException {
        TariffLabelManager tariffLabelManager = new TariffLabelManager(this.getConnection());
        List<TariffLabelItem> tariffLabelItems = tariffLabelManager.getTariffLabelItemList();
        if (tariffPlanId > 0) {
            Set<Integer> tariffLabelSet = tariffLabelManager.getTariffLabelIds(tariffPlanId);
            for (TariffLabelItem tariffLabelItem : tariffLabelItems) {
                tariffLabelItem.setSelected(tariffLabelSet.contains(tariffLabelItem.getId()));
            }
        }
        return tariffLabelItems;
    }

    @Override
    public void setTariffLabelTreeItemList(int tariffPlanId, List<TariffLabelItem> items) throws BGException {
        HashSet<Integer> labelIds = new HashSet<Integer>();
        if (items != null) {
            for (TariffLabelItem tariffLabelItem : items) {
                labelIds.add(tariffLabelItem.getId());
            }
        }
        this.tryCall(() -> new TariffLabelManager(this.getConnection()).setTariffLabelIds(tariffPlanId, labelIds));
    }

    @Override
    public Set<Integer> getTariffLabelIds(int tariffPlanId) throws BGException {
        return new TariffLabelManager(this.getConnection()).getTariffLabelIds(tariffPlanId);
    }

    @Override
    public int updateTariffLabelTreeItem(TariffLabelItem tariffLabelItem) throws BGException {
        new TariffLabelManager(this.getConnection()).updateTariffLabelTreeItem(tariffLabelItem);
        return tariffLabelItem != null ? tariffLabelItem.getId() : -1;
    }

    @Override
    public void removeTariffLabelTreeItem(int tariffLabelItemId) throws BGException {
        new TariffLabelManager(this.getConnection()).removeTariffLabelItem(tariffLabelItemId);
    }

    @Override
    public List<TariffPlan> getTariffListByLabelId(int labelId) throws BGException {
        Set<Integer> tariffIds = new TariffLabelManager(this.getConnection()).getTariffIdsByLabelId(labelId);
        if (tariffIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TariffPlan> tariffs = new ArrayList<TariffPlan>();
        TariffService tariffService = this.context.getService(TariffService.class, 0);
        for (Integer id : tariffIds) {
            tariffs.add(tariffService.tariffPlanGet(id));
        }
        return tariffs;
    }

    @Override
    public List<IdTitle> tariffModulesList() throws BGException {
        try (TariffPlanDao tariffPlanDao = new TariffPlanDao(this.getConnection());){
            List<IdTitle> list = tariffPlanDao.getModuleList();
            return list;
        }
    }
}

