/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.object.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGControlPanelListSelect;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.field.BGTextArea;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ObjectType;
import ru.bitel.bgbilling.kernel.contract.object.common.service.ContractObjectService;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public class ObjectTypeDirectory
extends BGPanel {
    private ObjectTypeTableModel objectTypeTableModel = new ObjectTypeTableModel();
    private ContractObjectService contractObjectService;

    public ObjectTypeDirectory() {
        this.jbInit();
    }

    private void jbInit() {
        BGUTable table = new BGUTable(this.objectTypeTableModel);
        table.setSelectionMode(0);
        BGSwingUtilites.handleLDMouseClicked(table, e -> this.editItem());
        this.setLayout(new GridBagLayout());
        this.add((Component)new JScrollPane(table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    @Override
    public void setData() throws Exception {
        this.objectTypeTableModel.setData(this.getContractObjectService().objectTypeList(false));
    }

    @Override
    public void deleteItem() {
        ObjectType objectType = (ObjectType)this.objectTypeTableModel.getSelectedRow();
        if (objectType != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0442\u0438\u043f?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            this.tryCall(() -> {
                this.getContractObjectService().objectTypeDelete(objectType.getId());
                this.setData();
            });
        }
    }

    @Override
    public void editItem() {
        this.objectTypeTableModel.optSelectedRow().ifPresentOrElse(objectType -> new ObjectTypeEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0442\u0438\u043f\u0430 \u043e\u0431\u044a\u0435\u043a\u0442\u0430", (ObjectType)objectType).open(), () -> ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f"));
    }

    @Override
    public void newItem() {
        new ObjectTypeEditor("\u041d\u043e\u0432\u044b\u0439 \u0442\u0438\u043f \u043e\u0431\u044a\u0435\u043a\u0442\u0430", new ObjectType()).open();
    }

    private ContractObjectService getContractObjectService() {
        if (this.contractObjectService == null) {
            this.contractObjectService = this.getContext().getWebService(ContractObjectService.class, 0);
        }
        return this.contractObjectService;
    }

    class ObjectTypeTableModel
    extends BGTableModel<ObjectType> {
        public ObjectTypeTableModel() {
            super(ObjectTypeTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 100, 300, 500, "title", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041c\u0430\u043a\u0440\u043e\u0441", 100, 500, 800, "nameMakros", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0421\u043a\u0440\u044b\u0442\u044b\u0439", 80, 80, 80, "hidden", true);
        }
    }

    class ObjectTypeEditor
    extends BGEditorDialog<ObjectType> {
        private BGTextField titleField;
        private BGTextField macrosField;
        private BGTextArea commentTextArea;
        private JCheckBox hiddenCheckBox;
        private BGControlPanelListSelect modules;

        public ObjectTypeEditor(String title, ObjectType data) {
            super(title, data);
            this.titleField = new BGTextField(40);
            this.macrosField = new BGTextField(40);
            this.commentTextArea = new BGTextArea(4, 40);
            this.hiddenCheckBox = new JCheckBox("\u0421\u043a\u0440\u044b\u0442");
            this.modules = new BGControlPanelListSelect();
        }

        @Override
        public void doDialogPanel() {
            this.panel.setLayout(new GridLayout(1, 2, 10, 0));
            this.panel.add(this.getLeftPanel());
            this.panel.add(this.getRightPanel());
            this.tryCall(() -> this.modules.getList().setData(ObjectTypeDirectory.this.getContext().getPort(ModuleService.class, 0).moduleList().stream().map(a -> new BGUListItem((IdTitle)a)).toList()));
            this.titleField.setText(((ObjectType)this.data).getTitle());
            this.macrosField.setText(((ObjectType)this.data).getNameMakros());
            this.commentTextArea.setText(((ObjectType)this.data).getComment());
            this.hiddenCheckBox.setSelected(((ObjectType)this.data).isHidden());
            this.modules.setListValues(Utils.toString(((ObjectType)this.data).getModuleList()));
        }

        private JPanel getLeftPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435: "), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)this.titleField, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u041c\u0430\u043a\u0440\u043e\u0441: "), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)this.macrosField, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439: "), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)BGSwingUtilites.wrapScrollPane(this.commentTextArea, 400, 80), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.hiddenCheckBox, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getRightPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041c\u043e\u0434\u0443\u043b\u0438: "), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)this.modules, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
            return panel;
        }

        @Override
        public boolean doApply() throws Exception {
            String title = this.titleField.getText();
            if (Utils.isBlankString(title)) {
                ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435!");
                return false;
            }
            ((ObjectType)this.data).setTitle(title);
            ((ObjectType)this.data).setNameMakros(this.macrosField.getText());
            ((ObjectType)this.data).setComment(this.commentTextArea.getText());
            ((ObjectType)this.data).setHidden(this.hiddenCheckBox.isSelected());
            ((ObjectType)this.data).setModuleList(this.modules.getListIds());
            return this.tryCallBoolean(() -> {
                ObjectTypeDirectory.this.getContractObjectService().objectTypeUpdate((ObjectType)this.data);
                ObjectTypeDirectory.this.setData();
            });
        }
    }
}

