/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.mail.server.bean;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.internet.MimeUtility;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import ru.bitel.bgbilling.kernel.admin.mail.common.dto.MailDto;
import ru.bitel.common.model.ContractIdable;

public class MailData
implements ContractIdable {
    private final String mailKey;
    private int moduleId;
    private int contractId;
    private String recipients;
    private String subject;
    private Multipart multipart = new MimeMultipart();
    protected Map<String, MimeBodyPart> map = new HashMap<String, MimeBodyPart>();

    public MailData(String mailKey) {
        this.mailKey = mailKey;
    }

    public String getMailKey() {
        return this.mailKey;
    }

    public int getModuleId() {
        return this.moduleId;
    }

    @Override
    public int getContractId() {
        return this.contractId;
    }

    public MailData setModuleId(int moduleId) {
        this.moduleId = moduleId;
        return this;
    }

    public MailData setContractId(int contractId) {
        this.contractId = contractId;
        return this;
    }

    public String getRecipients() {
        return this.recipients;
    }

    public MailData setRecipients(String recipients) {
        this.recipients = recipients;
        return this;
    }

    public String getSubject() {
        return this.subject;
    }

    public MailData setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public Multipart getMultipart() {
        return this.multipart;
    }

    public MailData setMultipart(Multipart multipart) {
        this.multipart = multipart;
        return this;
    }

    public MimeBodyPart getMimeBodyPart(String key) {
        return this.map.get(key);
    }

    public MailData addTextPart(String key, String text) throws MessagingException {
        return this.addTextPart(key, text, null);
    }

    public MailData addTextPart(String key, String text, String contentType) throws MessagingException {
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setText(text, "utf-8");
        mimeBodyPart.setHeader("Content-Type", contentType != null ? contentType : "text/plain; charset=utf-8;");
        this.multipart.addBodyPart((BodyPart)mimeBodyPart, 0);
        this.map.put(key, mimeBodyPart);
        return this;
    }

    public MailData addPart(String key, String disposition, final String contentType, final String fileName, final byte[] content) throws MessagingException, UnsupportedEncodingException {
        DataSource dataSource = new DataSource(){

            public String getContentType() {
                return contentType != null ? contentType : "application/octet-stream";
            }

            public String getName() {
                return fileName;
            }

            public OutputStream getOutputStream() throws IOException {
                return null;
            }

            public InputStream getInputStream() throws IOException {
                return new ByteArrayInputStream(content);
            }
        };
        MimeBodyPart attach = new MimeBodyPart();
        attach.setHeader("Content-Length", String.valueOf(content.length));
        attach.setDataHandler(new DataHandler(dataSource));
        attach.setFileName(MimeUtility.encodeText((String)fileName, (String)"utf-8", (String)"B"));
        if (disposition != null && ("attachment".equals(disposition) || "inline".equals(disposition))) {
            attach.setDisposition(disposition);
        }
        this.multipart.addBodyPart((BodyPart)attach);
        this.map.put(key, attach);
        return this;
    }

    public MailDto toMailDto() {
        MailDto dto = new MailDto();
        dto.setKey(this.mailKey);
        dto.setTitle(this.mailKey);
        return dto;
    }
}

