/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGIllegalAccessException;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginManagerClient;
import ru.bitel.bgbilling.kernel.plugin.common.BGPlugInElement;

public class BGControlPanelPluginControls
extends JPanel {
    private List<IPluginControls> controlList = new ArrayList<IPluginControls>();
    private Component owner;

    public BGControlPanelPluginControls(String id, Component owner, Object ... data) {
        this.owner = owner;
        this.setLayout(new GridBagLayout());
        int iter = 0;
        for (BGPlugInElement extension : BGPluginManagerClient.getManager().getExtensions(id, false)) {
            Element extensionElement = extension.getElement();
            NodeList list = extensionElement.getElementsByTagName("control");
            for (int index = 0; index < list.getLength(); ++index) {
                Element controlEl = (Element)list.item(index);
                String className = controlEl.getAttribute("class");
                Object comp = null;
                try {
                    comp = Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    if (e instanceof BGIllegalAccessException) continue;
                    ClientUtils.showErrorMessageDialog("\u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442 " + className + " \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0441\u043e\u0437\u0434\u0430\u043d");
                    e.printStackTrace();
                }
                if (comp instanceof IPluginControls && comp instanceof Component) {
                    this.controlList.add(comp);
                    if (!((IPluginControls)comp).beforeAdd(owner, data)) continue;
                    this.add((Component)comp, new GridBagConstraints(0, iter++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                    continue;
                }
                ClientUtils.showErrorMessageDialog("\u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442 " + className + " \u043d\u0435 JComponent \u0438\u043b\u0438 \u043d\u0435 IPluginControls");
            }
        }
    }

    public void invokeSetData(Object ... data) {
        Iterator<IPluginControls> iterator = this.controlList.iterator();
        while (iterator.hasNext()) {
            IPluginControls comp;
            IPluginControls panelComp = comp = iterator.next();
            panelComp.doSetData(this.owner, data);
        }
    }

    public void invokeInitBGPanel(String module, int moduleId) {
        for (IPluginControls comp : this.controlList) {
            if (!(comp instanceof BGPanel)) continue;
            ((BGPanel)((Object)comp)).init(module, moduleId);
        }
    }

    public void invokeDoAction(Object ... data) {
        Iterator<IPluginControls> iterator = this.controlList.iterator();
        while (iterator.hasNext()) {
            IPluginControls comp;
            IPluginControls actionImplComp = comp = iterator.next();
            actionImplComp.doAction(this.owner, data);
        }
    }

    public boolean invokeBeforeAction(Object ... data) {
        boolean result = true;
        Iterator<IPluginControls> iterator = this.controlList.iterator();
        while (iterator.hasNext()) {
            IPluginControls comp;
            IPluginControls actionImplComp = comp = iterator.next();
            result = result && actionImplComp.beforeAction(this.owner, data);
        }
        return result;
    }

    public static interface IPluginControls {
        public boolean beforeAdd(Component var1, Object ... var2);

        public void doSetData(Component var1, Object ... var2);

        public boolean beforeAction(Component var1, Object ... var2);

        public void doAction(Component var1, Object ... var2);
    }
}

