/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import bitel.billing.module.common.BGComboBox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.time.LocalDate;
import java.time.LocalDateTime;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.RowSorterEvent;
import ru.bitel.bgbilling.client.common.AbstractTransactionTableModel;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodWithTime;
import ru.bitel.bgbilling.client.common.BGUTabPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.field.BGSummaTextField;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.common.bean.BGAbstractTransaction;
import ru.bitel.bgbilling.common.bean.BGTransactionType;

public abstract class AbstractTransactionPanel
extends BGUTabPanel {
    protected JToggleButton autopayment = null;
    protected BGUTable transactionTable = null;
    protected JLabel recordCountLabel = new JLabel();
    protected AbstractTransactionTableModel<?> transactionModel = null;
    protected BGSummaTextField summaField = new BGSummaTextField(13);
    protected BGTextField contractTitleField = new BGTextField(10);
    protected BGControlPanelPages pagePanel = new BGControlPanelPages();
    protected BGControlPanelPeriodWithTime periodPanel = new BGControlPanelPeriodWithTime();
    protected BGComboBox<String> typeComboBox;
    protected BGComboBox<AbstractTransactionStatus> statusComboBox = new BGComboBox();

    @Override
    protected void jbInit() throws Exception {
        this.initListeners();
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getFilterPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)new JScrollPane(this.getTable()), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.getBottomPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    protected void initTypeComboBox() {
        this.typeComboBox = new BGComboBox();
        this.typeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"---", BGTransactionType.CARD.name(), BGTransactionType.QR_SBP.name()}));
    }

    protected void initListeners() {
        if (this.statusComboBox != null) {
            if (this.statusComboBox.getItemCount() > 0) {
                this.statusComboBox.setSelectedIndex(0);
            }
            this.statusComboBox.addItemListener(event -> {
                if (event.getStateChange() == 1) {
                    this.pagePanel.setPageIndex(1);
                    this.performAction("refresh");
                }
            });
        }
        if (this.typeComboBox != null) {
            if (this.typeComboBox.getItemCount() > 0) {
                this.typeComboBox.setSelectedIndex(0);
            }
            this.typeComboBox.addItemListener(event -> {
                if (event.getStateChange() == 1) {
                    this.pagePanel.setPageIndex(1);
                    this.performAction("refresh");
                }
            });
        }
        if (this.autopayment != null) {
            this.autopayment.addActionListener(e -> {
                this.pagePanel.setPageIndex(1);
                this.performAction("refresh");
            });
        }
        this.pagePanel.addToHandler(a -> this.performAction("refresh"));
        LocalDateTime now = LocalDate.now().withDayOfMonth(1).atStartOfDay();
        this.periodPanel.setDateFrom(now);
        this.periodPanel.addPropertyChangeListener(e -> {
            if (e.getPropertyName().startsWith("date") || "period".equals(e.getPropertyName())) {
                this.pagePanel.setPageIndex(1);
                this.performAction("refresh");
            }
        });
        this.getTable().getRowSorter().addRowSorterListener(e -> {
            if (e.getType() == RowSorterEvent.Type.SORT_ORDER_CHANGED) {
                this.pagePanel.setPageIndex(1);
                this.performAction("refresh");
            }
        });
    }

    protected void initPopupMenu() {
    }

    protected void initPopupListener() {
        this.initPopupMenu();
        this.getTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (AbstractTransactionPanel.this.getTable().getPopupMenu() != null && SwingUtilities.isRightMouseButton(event) && (AbstractTransactionPanel.this.getTable().getSelectionModel().getSelectionMode() != 0 || AbstractTransactionPanel.this.getTable().pointOnSelectRows(event.getPoint()))) {
                    AbstractTransactionPanel.this.getTable().getPopupMenu().show(AbstractTransactionPanel.this.getTable(), event.getX(), event.getY());
                }
            }
        });
    }

    protected JMenuItem getOpenContractMenuItem() {
        return new JMenuItem("\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440"){
            {
                this.addActionListener(e -> AbstractTransactionPanel.this.transactionModel.optSelectedRow().ifPresent(a -> {
                    BGAbstractTransaction selectedPayment;
                    int contractId;
                    if (a instanceof BGAbstractTransaction && (contractId = (selectedPayment = (BGAbstractTransaction)a).getContractId()) > 0) {
                        ClientUtils.openContract(contractId);
                    }
                }));
            }
        };
    }

    protected JPanel getFilterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        panel.add((Component)this.periodPanel, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        if (this.statusComboBox != null) {
            panel.add((Component)new JLabel("\u0421\u0442\u0430\u0442\u0443\u0441:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 15, 0, 5), 0, 0));
            panel.add(this.statusComboBox, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        }
        if (this.typeComboBox != null) {
            panel.add((Component)new JLabel("\u0422\u0438\u043f:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 15, 0, 5), 0, 0));
            panel.add(this.typeComboBox, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        }
        if (this.autopayment != null) {
            panel.add((Component)this.autopayment, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        }
        panel.add((Component)this.getExtraFilterPanel(), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.recordCountLabel, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)this.pagePanel, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    protected JPanel getExtraFilterPanel() {
        return new JPanel(new GridBagLayout());
    }

    protected JPanel getExtraBottomPanel() {
        return new JPanel(new GridBagLayout());
    }

    protected JPanel getContractFilterPanel() {
        this.contractTitleField = new BGTextField(10);
        this.contractTitleField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent event) {
                if (event.getKeyCode() == 10) {
                    AbstractTransactionPanel.this.pagePanel.setPageIndex(1);
                    AbstractTransactionPanel.this.performAction("refresh");
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0414\u043e\u0433\u043e\u0432\u043e\u0440:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 15, 0, 5), 0, 0));
        panel.add((Component)this.contractTitleField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        return panel;
    }

    protected BGUTable getTable() {
        if (this.transactionTable == null) {
            this.transactionTable = new BGUTable(this.transactionModel);
        }
        return this.transactionTable;
    }

    protected JPanel getBottomPanel() {
        JPanel bottomPanel = new JPanel(new GridBagLayout());
        bottomPanel.add((Component)this.getExtraBottomPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        bottomPanel.add((Component)new JLabel("\u0421\u0443\u043c\u043c\u0430 \u0438\u0442\u043e\u0433\u043e: "), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        bottomPanel.add((Component)this.summaField, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        return bottomPanel;
    }

    protected int getContractId() {
        return -1;
    }
}

