/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.tariff.voice;

import bitel.billing.module.tariff.voice.ServiceConfigGeographicCode;
import bitel.billing.module.tariff.voice.table.CodeNode;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.tree.TreePath;
import ru.bitel.bgbilling.client.common.BGSelectFilePanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class ExportEditor
extends JPanel {
    private ServiceConfigGeographicCode panel;
    private JRadioButton exportAll = new JRadioButton("\u042d\u043a\u0441\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432\u0441\u0435");
    private JRadioButton exportSub = new JRadioButton("\u041f\u043e\u0434\u0443\u0437\u043b\u044b \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u0433\u043e \u0443\u0437\u043b\u0430");
    private BGSelectFilePanel file = new BGSelectFilePanel();

    public ExportEditor(ServiceConfigGeographicCode panel) {
        this.panel = panel;
        this.jbInit();
    }

    private void jbInit() {
        ButtonGroup group = new ButtonGroup();
        group.add(this.exportAll);
        group.add(this.exportSub);
        this.exportAll.setSelected(true);
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        okCancel.addActionListener(e -> this.stopEdit(e.getActionCommand().equals("ok")));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.exportAll, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.exportSub, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(Box.createHorizontalStrut(2), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.file, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)okCancel, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 5, 5), 0, 0));
    }

    public void startEdit() {
        this.setVisible(true);
    }

    private void stopEdit(boolean doExport) {
        if (doExport) {
            File file = this.file.getSelectedFile();
            if (file == null) {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0430\u0439\u043b!");
                return;
            }
            String fromPrefix = null;
            if (this.exportSub.isSelected()) {
                TreePath path = this.panel.getTree().getTree().getSelectionPath();
                if (path == null) {
                    ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0443\u0437\u0435\u043b!");
                    return;
                }
                CodeNode node = (CodeNode)path.getLastPathComponent();
                fromPrefix = node.prefix;
            }
            if (!this.panel.saveToFile(file, fromPrefix)) {
                return;
            }
        }
        this.setVisible(false);
    }
}

