/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.services.call;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.IPField;
import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.services.ServicePanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.BGSwingUtilites;

public class SPP_IPAddress
extends ServicePanel
implements ActionListener {
    private BGTable addrTable = new BGTable();
    private BGComboBox<ComboBoxItem> addrRealm_CB = new BGComboBox();
    private IPField addrIp = new IPField();
    private BGControlPanelPeriodNoB period = new BGControlPanelPeriodNoB();
    private BGDialogToolBar dialogToolBar = new BGDialogToolBar();
    private Vector<Object> editVector = null;
    private JPanel editPanel = new JPanel(new GridBagLayout());
    private boolean init = false;

    public SPP_IPAddress() {
        this.tryCall(() -> this.jbInit());
        this.addrTable.setHeader(this.rb_name, this.moduleDoc, "radius_addr");
    }

    private void jbInit() throws Exception {
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        okCancel.addActionListener(e -> this.stopEdit(e.getActionCommand().equals("ok")));
        JPanel addrPanel = new JPanel(new GridBagLayout());
        addrPanel.add((Component)new JScrollPane(this.addrTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        addrPanel.add((Component)this.editPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.editPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.editPanel.add((Component)new JLabel("IP:"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.editPanel.add((Component)this.addrIp, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.editPanel.add((Component)new JLabel("REALM:"), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.editPanel.add(this.addrRealm_CB, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.editPanel.add((Component)this.period, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.editPanel.add((Component)okCancel, new GridBagConstraints(0, 1, 6, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.editPanel.setVisible(false);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.dialogToolBar, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 11, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)addrPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogToolBar.setDefaultButtons(this);
        this.dialogToolBar.setOrientation(1);
        this.dialogToolBar.setToolBar(new String[]{"newItem", "editItem", "deleteItem"});
        BGSwingUtilites.handleLDMouseClicked(this.addrTable, e -> this.editItem());
    }

    @Override
    public boolean updateData() {
        StringBuilder values = new StringBuilder();
        int n = this.addrTable.getBGTableModel().getRowCount();
        for (int i = 0; i < n; ++i) {
            String addr = this.addrTable.getColumnValueString(i, "ip");
            String realm = this.addrTable.getColumnValueString(i, "realm");
            String period = this.addrTable.getColumnValueString(i, "period");
            if (values.length() > 0) {
                values.append(",");
            }
            values.append(addr);
            values.append(":");
            values.append(realm);
            values.append(":");
            values.append(period);
        }
        if (this.module != null && this.getModuleId() != 0) {
            Request request = new Request();
            request.setModule(this.module);
            request.setModuleId(this.getModuleId());
            request.setAction("IPAddressUpdate");
            request.setAttribute("lid", String.valueOf(this.id));
            request.setAttribute("values", values.toString().trim());
            Document doc = this.getDocument(request);
            if (Utils.notBlankString(doc.getDocumentElement().getAttribute("access_error"))) {
                return true;
            }
            return ClientUtils.checkStatus(doc);
        }
        return true;
    }

    private void init() {
        Request req = new Request();
        req.setModule("call");
        req.setModuleId(this.getModuleId());
        req.setAction("RealmList");
        Document doc = this.getDocument(req);
        Node node = XMLUtils.getNode(doc, "realms");
        ClientUtils.buildComboBox(this.addrRealm_CB, node, null);
    }

    @Override
    public void setData() {
        if (!this.init) {
            this.init();
            this.init = true;
        }
        this.addrIp.setText("0.0.0.0");
        if (this.addrRealm_CB.getItemCount() > 0) {
            this.addrRealm_CB.setSelectedIndex(0);
        }
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("IPAddress");
        request.setModuleId(this.getModuleId());
        request.setAttribute("lid", String.valueOf(this.id));
        this.setDocument(this.getDocument(request));
    }

    @Override
    public void setDocument(Document doc) {
        if (ClientUtils.checkStatus(doc)) {
            this.addrTable.updateData(XMLUtils.getNode(doc, "address"));
        }
    }

    @Override
    public void deleteItem() {
        int row = this.addrTable.getSelectedRow();
        if (row > -1) {
            this.addrTable.getBGTableModel().removeRow(row);
        } else {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443");
        }
    }

    @Override
    public void editItem() {
        int selRow = this.addrTable.getSelectedRow();
        if (selRow < 0) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443");
        }
        String ip = this.addrTable.getColumnValueString(selRow, "ip");
        String realm = this.addrTable.getColumnValueString(selRow, "realm");
        String per = this.addrTable.getColumnValueString(selRow, "period");
        if (realm == null) {
            realm = "default";
        }
        this.addrIp.setText(ip);
        ClientUtils.setComboBoxSelection(this.addrRealm_CB, realm);
        String[] tokens = per.split("\\s*\\-\\s*");
        if (tokens.length > 0) {
            this.period.setDateString1(tokens[0]);
        }
        if (tokens.length > 1) {
            this.period.setDateString2(tokens[1]);
        }
        this.editVector = this.addrTable.getBGTableModel().getDataVector().elementAt(selRow);
        this.startEdit();
    }

    @Override
    public void newItem() {
        this.editVector = null;
        this.addrIp.setText("0.0.0.0");
        this.period.setLocalDateFrom(LocalDate.now());
        if (this.addrRealm_CB.getItemCount() > 0) {
            ClientUtils.setComboBoxSelection(this.addrRealm_CB, "default");
        }
        this.startEdit();
    }

    private void startEdit() {
        this.editPanel.setVisible(true);
    }

    private void stopEdit(boolean save) {
        if (save) {
            ComboBoxItem it = this.addrRealm_CB.getSelectedItem();
            if (it == null) {
                return;
            }
            String realm = it.getObject().toString();
            String ip = this.addrIp.getText();
            String date1 = this.period.getDateString1();
            String date2 = this.period.getDateString2();
            Calendar date1Cal = TimeUtils.parseCalendar(date1, "dd.MM.yyyy");
            Calendar date2Cal = TimeUtils.parseCalendar(date1, "dd.MM.yyyy");
            if (Utils.notEmptyString(ip) && realm != null && !"0.0.0.0".equals(ip)) {
                int n = this.addrTable.getBGTableModel().getRowCount();
                for (int i = 0; i < n; ++i) {
                    if (this.addrTable.getBGTableModel().getDataVector().elementAt(i) == this.editVector) continue;
                    String rowIp = this.addrTable.getColumnValueString(i, "ip");
                    String rowRealm = this.addrTable.getColumnValueString(i, "realm");
                    String rowPeriod = this.addrTable.getColumnValueString(i, "period");
                    if (!realm.equals(rowRealm) || !ip.equals(rowIp)) continue;
                    boolean checkStatus = true;
                    if (Utils.isBlankString(rowPeriod)) {
                        checkStatus = false;
                    } else {
                        String[] tokens = rowPeriod.split("\\s*\\-\\s*");
                        Calendar rowDate1Cal = null;
                        Calendar rowDate2Cal = null;
                        if (tokens.length > 0) {
                            rowDate1Cal = TimeUtils.parseCalendar(tokens[0], "dd.MM.yyyy");
                        }
                        if (tokens.length > 1) {
                            rowDate2Cal = TimeUtils.parseCalendar(tokens[1], "dd.MM.yyyy");
                        }
                        if ((date1 == null || rowDate2Cal == null || TimeUtils.dateBeforeOrEq(date1Cal, rowDate2Cal)) && (date2 == null || rowDate1Cal == null || TimeUtils.dateBeforeOrEq(rowDate1Cal, date2Cal))) {
                            checkStatus = false;
                        }
                    }
                    if (checkStatus) continue;
                    ClientUtils.showErrorMessageDialog("\u0414\u043b\u044f REALM\u0430 " + realm + " \u0432\u044b\u0434\u0435\u043b\u0435\u043d \u0430\u0434\u0440\u0435\u0441 " + rowIp + " \u043d\u0430 \u043f\u0435\u0440\u0438\u043e\u0434, \u043f\u0435\u0440\u0435\u0441\u0435\u043a\u0430\u044e\u0449\u0438\u0439 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439!");
                    return;
                }
                if (this.editVector == null) {
                    this.editVector = new Vector();
                    this.addrTable.getBGTableModel().addRow(this.editVector);
                }
                this.editVector.set(0, realm);
                this.editVector.set(1, ip);
                this.editVector.set(2, date1 + "-" + date2);
                this.editPanel.setVisible(false);
            }
        } else {
            this.editPanel.setVisible(false);
        }
    }
}

