/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract;

import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.table.BGTable;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.XMLUtils;

public class DeleteContractViewer
extends BGPanel {
    CardLayout cardLayout1 = new CardLayout();
    JPanel jPanel1 = new JPanel(new GridBagLayout());
    JPanel jPanel2 = new JPanel(new GridBagLayout());
    JPanel jPanel8 = new JPanel(new GridBagLayout());
    JPanel jPanel9 = new JPanel(new GridBagLayout());
    JPanel filterPanel = new JPanel(new GridBagLayout());
    BGTable archivesTable = new BGTable();
    BGControlPanelPeriodNoB periodPanel = new BGControlPanelPeriodNoB();
    Component component1 = Box.createHorizontalStrut(8);
    Component component2 = Box.createHorizontalStrut(8);
    JComboBox<ComboBoxItem> folder_CB = new JComboBox();
    CardLayout cardLayout2 = new CardLayout();
    JButton closeViewButton = new JButton();
    JTextField nameFilter_TF = new JTextField();
    JTextArea archiveContent_TA = new JTextArea();
    JButton viewButton = new JButton();
    JButton restoreButton = new JButton();
    JButton filterButton = new JButton();
    JButton restoreCloneButton = new JButton();

    public DeleteContractViewer() {
        this.tryCall(() -> this.jbInit());
        this.archivesTable.setHeader(ClientUtils.getRBName(this), "contract_archive");
    }

    private void jbInit() throws Exception {
        this.setLayout(this.cardLayout2);
        this.restoreButton.setText("\u0412\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0444\u0430\u0439\u043b \u0438\u0437 \u0430\u0440\u0445\u0438\u0432\u0430");
        this.restoreButton.addActionListener(e -> this.restoreButton_actionPerformed(e));
        this.viewButton.setText("\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440 \u0430\u0440\u0445\u0438\u0432\u0430");
        this.viewButton.addActionListener(e -> this.viewButton_actionPerformed(e));
        this.closeViewButton.setText("\u0417\u0430\u043a\u0440\u044b\u0442\u044c");
        this.closeViewButton.addActionListener(e -> this.closeViewButton_actionPerformed(e));
        this.restoreCloneButton.setText("\u0412\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043a\u043b\u043e\u043d \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
        this.restoreCloneButton.addActionListener(e -> this.restoreCloneButton_actionPerformed(e));
        this.jPanel8.add((Component)this.filterPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.filterPanel.setBorder(new BGTitleBorder("\u0424\u0438\u043b\u044c\u0442\u0440"));
        JLabel jLabel4 = new JLabel("\u041f\u0430\u043f\u043a\u0430:");
        this.filterPanel.add((Component)jLabel4, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.filterPanel.add(this.folder_CB, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 0), 0, 0));
        JLabel jLabel5 = new JLabel("\u0424\u0438\u043b\u044c\u0442\u0440 \u043f\u043e \u0438\u043c\u0435\u043d\u0438:");
        this.filterPanel.add((Component)jLabel5, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.filterPanel.add((Component)this.nameFilter_TF, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 0), 0, 0));
        JLabel periodLabel = new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434:");
        this.filterPanel.add((Component)periodLabel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.filterPanel.add((Component)this.filterButton, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanel8.add((Component)new JScrollPane(this.archivesTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.nameFilter_TF.setMinimumSize(new Dimension(4, 24));
        this.nameFilter_TF.setPreferredSize(new Dimension(63, 24));
        this.filterButton.setText(">>");
        this.add((Component)this.jPanel8, "table");
        this.add((Component)this.jPanel1, "view");
        this.jPanel8.add((Component)this.jPanel9, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 0), 0, 0));
        this.jPanel1.add((Component)this.jPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)new JScrollPane(this.archiveContent_TA), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.jPanel2.add((Component)this.closeViewButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.jPanel2.add(this.component2, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel9.add(this.component1, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel9.add((Component)this.restoreButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.jPanel9.add((Component)this.restoreCloneButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.jPanel9.add((Component)this.viewButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.filterPanel.add((Component)this.periodPanel, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 5, 0), 0, 0));
        this.filterButton.addActionListener(e -> this.trySetData());
    }

    @Override
    public void setData() throws Exception {
        ComboBoxItem folderItem = (ComboBoxItem)this.folder_CB.getSelectedItem();
        String mask = this.nameFilter_TF.getText().trim();
        if (folderItem != null) {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("ArchiveInfo");
            request.setAttribute("date1", this.periodPanel.getDateString1());
            request.setAttribute("date2", this.periodPanel.getDateString2());
            request.setAttribute("folder", folderItem.getObject());
            request.setAttribute("mask", mask);
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus(doc)) {
                this.archivesTable.updateData(XMLUtils.selectNode(doc, "//table"));
            }
        }
    }

    @Override
    public void init(String module, int moduleId) {
        super.init(module, moduleId);
        this.init();
    }

    private void init() {
        Request request = new Request();
        request.setModule("contract");
        request.setAction("ArchiveFoldersList");
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            this.tryCall(() -> {
                Element foldersEl = XMLUtils.selectElement(doc, "//folder_list");
                this.folder_CB.setModel(ClientUtils.buildComboBox(foldersEl, ""));
            });
        }
    }

    public void restoreButton_actionPerformed(ActionEvent e) {
        ComboBoxItem folderItem = (ComboBoxItem)this.folder_CB.getSelectedItem();
        int pos = this.archivesTable.getSelectedRow();
        if (folderItem != null && pos >= 0 && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440?", "\u0412\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            String fileName = (String)this.archivesTable.getValueAt(pos, 0);
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("ArchiveRestore");
            request.setAttribute("file", fileName);
            request.setAttribute("folder", folderItem.getObject());
            if (ClientUtils.checkStatus(this.getDocument(request))) {
                ClientUtils.showErrorMessageDialog("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d");
            }
            this.trySetData();
        }
    }

    public void restoreCloneButton_actionPerformed(ActionEvent e) {
        ComboBoxItem folderItem = (ComboBoxItem)this.folder_CB.getSelectedItem();
        int pos = this.archivesTable.getSelectedRow();
        if (folderItem != null && pos >= 0 && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043a\u043b\u043e\u043d \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430?", "\u0412\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            String fileName = (String)this.archivesTable.getValueAt(pos, 0);
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("ArchiveRestoreClone");
            request.setAttribute("file", fileName);
            request.setAttribute("folder", folderItem.getObject());
            if (ClientUtils.checkStatus(this.getDocument(request))) {
                ClientUtils.showErrorMessageDialog("\u041a\u043b\u043e\u043d \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d");
            }
            this.trySetData();
        }
    }

    public void closeViewButton_actionPerformed(ActionEvent e) {
        this.cardLayout2.show(this, "table");
    }

    public void viewButton_actionPerformed(ActionEvent e) {
        int row = this.archivesTable.getSelectedRow();
        if (row < 0) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443!");
            return;
        }
        ComboBoxItem folderItem = (ComboBoxItem)this.folder_CB.getSelectedItem();
        String fileName = (String)this.archivesTable.getValueAt(row, 0);
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("GetArchiveContent");
        request.setAttribute("file", fileName);
        request.setAttribute("folder", folderItem.getObject());
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            this.tryCall(() -> {
                Element archive = XMLUtils.selectElement(doc, "//archive");
                String str = ClientUtils.linesToString(archive);
                this.archiveContent_TA.setText(str);
                this.cardLayout2.show(this, "view");
            });
        }
    }
}

