/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.xml;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.beans.Introspector;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import ru.bitel.common.xml.strategy.MarshallerStrategy;

public class JAXBMarshaller {
    private final ConcurrentMap<JAXBContextCache, JAXBContext> contextMap = new ConcurrentHashMap<JAXBContextCache, JAXBContext>(8);
    private final Set<Class<?>> defaultClasses;
    private final MarshallerStrategy strategy;

    public JAXBMarshaller(MarshallerStrategy strategy, Set<Class<?>> defaultClasses) {
        this.defaultClasses = new HashSet(defaultClasses.size() + 4);
        this.defaultClasses.addAll(strategy.getDefaultClasses());
        this.defaultClasses.addAll(defaultClasses);
        this.strategy = strategy;
    }

    public void marshal(Object element, String name, Result result) throws JAXBException {
        JAXBContext newContext;
        JAXBElement root;
        element = this.strategy.prepareForMarshal(element);
        HashSet classes = new HashSet();
        classes.addAll(this.defaultClasses);
        classes.add(ru.bitel.common.model.Result.class);
        if (element instanceof List) {
            List list = (List)element;
            root = new ru.bitel.common.model.Result(list);
            if (list.size() > 0 && (obj = list.get(0)) != null) {
                classes.add(obj.getClass());
            }
        } else if (element instanceof ru.bitel.common.model.Result) {
            root = element;
            ru.bitel.common.model.Result r = (ru.bitel.common.model.Result)element;
            if (r.getList() != null && r.getList().size() > 0 && (obj = r.getList().get(0)) != null) {
                classes.add(obj.getClass());
            }
            if (r.getAttributes() != null) {
                for (Object o : r.getAttributes().values()) {
                    if (o instanceof List && ((List)o).size() > 0) {
                        classes.add(((List)o).get(0).getClass());
                        continue;
                    }
                    if (o instanceof Collection && ((Collection)o).size() > 0) {
                        classes.add(((Collection)o).iterator().next().getClass());
                        continue;
                    }
                    if (o == null) continue;
                    classes.add(o.getClass());
                }
            }
        } else {
            root = element;
            if (root instanceof JAXBElement) {
                classes.add(((JAXBElement)root).getDeclaredType());
            } else {
                classes.add(element.getClass());
            }
        }
        Class<?> rootClass = root.getClass();
        if (name != null) {
            root = new JAXBElement(new QName(name), rootClass, root);
        } else {
            XmlRootElement r = rootClass.getAnnotation(XmlRootElement.class);
            if (r == null) {
                root = new JAXBElement(new QName(JAXBMarshaller.inferName(rootClass)), rootClass, (Object)root);
            }
        }
        Class[] types = classes.toArray(new Class[classes.size()]);
        JAXBContextCache cache = new JAXBContextCache(this, types);
        JAXBContext context = (JAXBContext)this.contextMap.get(cache);
        if (context == null && (context = this.contextMap.putIfAbsent(cache, newContext = JAXBContext.newInstance((Class[])types))) == null) {
            context = newContext;
        }
        this.strategy.newMarshaller(context).marshal((Object)root, result);
    }

    private static String inferName(Class<?> clazz) {
        return Introspector.decapitalize(clazz.getSimpleName());
    }

    class JAXBContextCache {
        private final Class<?>[] types;
        private final int hashCode;

        public JAXBContextCache(JAXBMarshaller this$0, Class<?>[] types) {
            this.types = types;
            this.hashCode = Arrays.hashCode(types);
        }

        public boolean equals(Object obj) {
            return Arrays.equals(this.types, ((JAXBContextCache)obj).types);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

