/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.tree.old;

import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.TariffRequest;
import ru.bitel.common.TimeUtils;

public class PeriodTariffTreeNode
extends DefaultTariffTreeNode {
    private Calendar date1;
    private Calendar date2;
    protected boolean needCheckPeriodOnReset = false;

    @Override
    public void init(String dataStr, int deep, int nodeID) {
        super.init(dataStr, deep, nodeID);
        Map<String, String> map = this.getDataInHash();
        this.date1 = TimeUtils.parseCalendar((String)map.get("date1"), (String)"dd.MM.yyyy");
        this.date2 = TimeUtils.parseCalendar((String)map.get("date2"), (String)"dd.MM.yyyy");
    }

    @Override
    public void processRequest(TariffRequest request) {
        Object dateObject = request.getRequestParam("time");
        Calendar date = dateObject instanceof Calendar ? (Calendar)dateObject : TimeUtils.convertDateToCalendar((Date)((Date)dateObject));
        String action = (String)request.getRequestParam("action");
        if (action != null && action.equals("reset")) {
            if (!this.needCheckPeriodOnReset || date != null && (this.date1 == null || TimeUtils.dateBeforeOrEq((Calendar)this.date1, (Calendar)date)) && (this.date2 == null || TimeUtils.dateBeforeOrEq((Calendar)date, (Calendar)this.date2))) {
                this.processForChilds(request);
            }
        } else if (date != null && (this.date1 == null || TimeUtils.dateBeforeOrEq((Calendar)this.date1, (Calendar)date)) && (this.date2 == null || TimeUtils.dateBeforeOrEq((Calendar)date, (Calendar)this.date2))) {
            this.processForChilds(request);
        } else {
            request.addHistoryMsg("Not accepted on period 2 date=" + TimeUtils.formatDate((Calendar)date) + "; date1=" + TimeUtils.formatDate((Calendar)this.date1) + "; date2=" + TimeUtils.formatDate((Calendar)this.date2) + "\n");
        }
    }
}

