/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.table.server.table;

import bitel.billing.server.contract.logon.ContractLogonBase;
import bitel.billing.server.contract.logon.ContractLogonError;
import bitel.billing.server.contract.logon.LogonManager;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableColumn;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableRowData;
import ru.bitel.bgbilling.kernel.table.server.bean.BGTableInfoBase;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.SearchResult;

public class TableWebLogonLogError
extends BGTableInfoBase {
    public TableWebLogonLogError() {
        this.columns = new BGUTableColumn[]{BGUTableColumn.buildColumnTextCenter("\u0414\u0430\u0442\u0430 \u0438 \u0432\u0440\u0435\u043c\u044f", "date").setWidth(150), BGUTableColumn.buildColumnTextCenter("\u0414\u043e\u0433\u043e\u0432\u043e\u0440", "contractTitle").setWidth(150), BGUTableColumn.buildColumnTextCenter("IP \u0430\u0434\u0440\u0435\u0441", "ip").setWidth(300), BGUTableColumn.buildColumnTextCenter("\u041b\u043e\u0433\u0438\u043d", "login").setWidth(150), BGUTableColumn.buildColumnTextLeft("\u041e\u0448\u0438\u0431\u043a\u0430", "errorCode").setWidth(-1)};
    }

    @Override
    public List<BGUTableRowData> getRows(BGUTableParams tableParams, int moduleId) throws Exception {
        String contracts = tableParams.get("contracts");
        LogonManager logonManager = new LogonManager(this.getContext().getConnection());
        SearchResult searchResult = new SearchResult(tableParams.getPeriod(), tableParams.getPage());
        logonManager.searchLogonError(contracts, (SearchResult<ContractLogonBase>)searchResult);
        this.page = searchResult.getPage();
        DateFormat dateFormat = TimeUtils.getDateFormat((String)"dd.MM.yyyy HH:mm:ss");
        ArrayList<BGUTableRowData> rowDatas = new ArrayList<BGUTableRowData>();
        for (ContractLogonBase item : searchResult.getList()) {
            ContractLogonError contractLogonError = (ContractLogonError)item;
            StringBuilder builder = new StringBuilder().append("[").append(contractLogonError.getErrorCode()).append("] ").append(contractLogonError.getRequestData());
            BGUTableRowData rowData = new BGUTableRowData().addValue("contractTitle", contractLogonError.getContractTitle()).addValue("date", dateFormat.format(contractLogonError.getDateTime())).addValue("ip", contractLogonError.getRemoteIP()).addValue("login", contractLogonError.getLogin()).addValue("errorCode", builder.toString());
            rowDatas.add(rowData);
        }
        return rowDatas;
    }
}

