/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.dynamic.server;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class ExcludeCompilationResources {
    private static ExcludeCompilationResources INSTANCE;
    private final Path excludeCompilationFile = Paths.get(new File("").getAbsolutePath(), "data", "compilation_exclude");
    private final List<String> excludePackages = new ArrayList<String>();
    private final List<String> excludeClasses = new ArrayList<String>();

    private ExcludeCompilationResources() {
        this.reload();
    }

    public static ExcludeCompilationResources getInstance(boolean reload) {
        if (INSTANCE == null) {
            INSTANCE = new ExcludeCompilationResources();
        }
        if (reload) {
            INSTANCE.reload();
        }
        return INSTANCE;
    }

    private void reload() {
        this.excludeClasses.clear();
        this.excludePackages.clear();
        try {
            if (Files.notExists(this.excludeCompilationFile, new LinkOption[0])) {
                Files.createFile(this.excludeCompilationFile, new FileAttribute[0]);
            }
            try (Stream<String> lines = Files.lines(this.excludeCompilationFile);){
                lines.forEach(l -> {
                    if (l.startsWith("class::")) {
                        this.excludeClasses.add((String)l);
                    } else if (l.startsWith("package::")) {
                        this.excludePackages.add((String)l);
                    }
                });
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void saveExcludeResources(List<String> resources) {
        try {
            Files.write(this.excludeCompilationFile, resources.stream().filter(r -> r.startsWith("class::") || r.startsWith("package::")).toList(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
            this.reload();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getAllExcludeResources() {
        ArrayList<String> all = new ArrayList<String>();
        all.addAll(this.excludePackages);
        all.addAll(this.excludeClasses);
        return all;
    }

    public boolean classIsExclude(String className) {
        Object name;
        Object object = name = className.startsWith("class::") ? className : "class::" + className;
        if (this.excludeClasses.contains(name)) {
            return true;
        }
        String cleanClassName = ((String)name).replace("class::", "");
        for (String p : this.excludePackages) {
            String cleanPackageName = p.replace("package::", "");
            if (!cleanClassName.startsWith(cleanPackageName + ".")) continue;
            return true;
        }
        return false;
    }
}

