/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.basic.server.action.web;

import bitel.billing.server.contract.bean.ContractUtils;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.container.web.action.XSLManager;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractCard;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.GetContractCardsListEvent;
import ru.bitel.common.FOUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.util.FileDownload;

@WebAction(title="\u041a\u0430\u0440\u0442\u043e\u0447\u043a\u0438")
public class ActionCards
extends AbstractAction {
    public ActionCards() {
        super("contract");
    }

    @Override
    @WebOperation(title="\u0421\u043f\u0438\u0441\u043e\u043a \u043a\u0430\u0440\u0442\u043e\u0447\u0435\u043a")
    public void execute() throws BGException {
        this.setResultParam("cards", this.getCardList());
        this.setResultParam("jspPage", "contract/cards.jsp");
        if (this.req.getBoolean("getBody", false)) {
            this.requestDispatcher(this.moduleName, "../contract/cards");
        }
    }

    @WebOperation(title="\u0421\u043a\u0430\u0447\u0438\u0432\u0430\u043d\u0438\u0435 \u043a\u0430\u0440\u0442\u043e\u0447\u043a\u0438")
    public void cardGet() throws BGException {
        this.setResultParam("contentType", "binary");
        try {
            String idCard = this.req.get("id");
            String contractcard = this.setup.get("contractcard." + idCard);
            if (contractcard == null) {
                throw new BGException("contractcard." + idCard + "=null");
            }
            idCard = contractcard.replaceAll("^([^:]+):.*", "$1");
            if (Utils.isBlankString((String)idCard)) {
                throw new BGException("idCard=" + idCard);
            }
            String titleCard = contractcard.replaceAll("^[^:]+:([^:]*).*", "$1");
            StringBuilder fileName = new StringBuilder();
            fileName.append(titleCard);
            fileName.append(".pdf");
            this.context.getResponse().setContentType("application/pdf");
            this.context.getResponse().setHeader("Content-Disposition", FileDownload.getContentDisposition((HttpServletRequest)this.context.getRequest(), (String)fileName.toString(), (boolean)false));
            DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
            dFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = dFactory.newDocumentBuilder();
            Document document = docBuilder.newDocument();
            Element card = document.createElement("card");
            Element user = XMLUtils.createElement((Element)card, (String)"user");
            user.setAttribute("id", String.valueOf(this.userId));
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            XMLStreamWriter w = factory.createXMLStreamWriter(new DOMResult(card));
            new ContractUtils(this.con).addContractXML(this.contractId, w, true);
            document.appendChild(card);
            ServletOutputStream out = this.context.getResponse().getOutputStream();
            XSLManager.getInstance().transform((Source)new DOMSource(document), idCard, FOUtils.renderSAXResult((OutputStream)out, (String)"application/pdf"));
            out.flush();
            out.close();
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    protected List<ContractCard> getCardList() throws BGException {
        String card;
        ArrayList<ContractCard> cards = new ArrayList<ContractCard>();
        Contract contract = null;
        if (this.contractId > 0) {
            contract = ContractDao.getContract(this.con, this.contractId);
        }
        int i = 1;
        while ((card = this.setup.get("contractcard." + i, null)) != null) {
            String[] arr = card.split(":", 3);
            if (arr.length > 1) {
                if (contract != null && arr.length > 2 && (contract.getGroups() & Utils.enumToMask((String)arr[2])) == 0L) {
                    ++i;
                    continue;
                }
                ContractCard contractCard = new ContractCard();
                contractCard.setId(String.valueOf(i));
                contractCard.setTitle(arr[1]);
                cards.add(contractCard);
            }
            ++i;
        }
        EventProcessor.getInstance().request(new GetContractCardsListEvent(this.userId, this.contractId, cards));
        return cards;
    }
}

