/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.bean.customer.parameter.provider;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.customer.parameter.provider.CustomerParameterProvider;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.customer.parameter.provider.CustomerParameterProviderUtils;

public class CustomerParameterProviderPB
extends BGLogger
implements CustomerParameterProvider {
    private static final int DEFAULT_TIMEOUT_SECONDS = 3;
    private static final int MAX_RETRIES = 4;
    private static final int RETRY_DELAY_MS = 2000;
    private static final String SEARCH_URL = "https://pb.nalog.ru/search-proc.json";
    private static final String COMPANY_URL = "https://pb.nalog.ru/company-proc.json";
    private final HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(3L)).build();
    private static final CustomerParameterProviderPB INSTANCE = new CustomerParameterProviderPB();

    private CustomerParameterProviderPB() {
    }

    public static CustomerParameterProviderPB getInstance() {
        return INSTANCE;
    }

    @Override
    public JSONObject searchDataByINN(String inn) throws Exception {
        return this.getCompanyData(inn);
    }

    @Override
    public JSONObject searchDataByOGRN(String ogrn) throws Exception {
        return this.getCompanyData(ogrn);
    }

    public String getGuiTitle() {
        return "\u0424\u041d\u0421. \u041f\u0440\u043e\u0437\u0440\u0430\u0447\u043d\u044b\u0439 \u0431\u0438\u0437\u043d\u0435\u0441";
    }

    private JSONObject getCompanyData(String inn) {
        try {
            JSONObject actualIDAndToken = this.getActualIDAndToken(this.getRequestToken(this.getPreviewRequestID(inn)));
            String id = actualIDAndToken.optString("id");
            String token = actualIDAndToken.optString("token");
            this.getLogger().debug("Actual ID and TOKEN = {}; {}", (Object)id, (Object)token);
            return this.parseCompanyData(this.companyDataSearchRequest(id, token));
        }
        catch (IOException | InterruptedException | PBAPIException e) {
            throw new RuntimeException(e);
        }
    }

    private JSONObject parseCompanyData(JSONObject raw) throws PBAPIException {
        JSONObject result = new JSONObject();
        JSONObject vyp = raw.optJSONObject("vyp");
        if (vyp == null) {
            throw new PBAPIException("\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043e\u0431\u044a\u0435\u043a\u0442 'vyp' \u0432 \u043e\u0442\u0432\u0435\u0442\u0435");
        }
        result.put("isActive", vyp.optString("sulst_name_ex").equals("\u0414\u0435\u0439\u0441\u0442\u0432\u0443\u044e\u0449\u0430\u044f \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f"));
        result.put("title", (Object)vyp.optString("\u041d\u0430\u0438\u043c\u042e\u041b\u0421\u043e\u043a\u0440"));
        result.put("fullTitle", (Object)vyp.optString("\u041d\u0430\u0438\u043c\u042e\u041b\u041f\u043e\u043b\u043d"));
        result.put("regDate", (Object)vyp.optString("\u0414\u0430\u0442\u0430\u0420\u0435\u0433"));
        result.put("ogrn", (Object)vyp.optString("\u041e\u0413\u0420\u041d"));
        result.put("kpp", (Object)vyp.optString("\u041a\u041f\u041f"));
        result.put("inn", (Object)vyp.optString("\u0418\u041d\u041d"));
        result.put("address", (Object)CustomerParameterProviderUtils.capitalizeEachWord(vyp.optString("\u0410\u0434\u0440\u0435\u0441\u0420\u0424")));
        result.put("postIndex", (Object)vyp.optString("index"));
        JSONObject masruk = vyp.optJSONArray("masruk").optJSONObject(0);
        JSONObject supervisor = new JSONObject();
        supervisor.put("name", (Object)CustomerParameterProviderUtils.capitalizeEachWord(masruk.optString("name")));
        supervisor.put("position", (Object)CustomerParameterProviderUtils.capitalizeFirstWordOnly(masruk.optString("position")));
        result.put("supervisor", (Object)supervisor);
        return result;
    }

    private String getPreviewRequestID(String inn) throws IOException, InterruptedException {
        this.getLogger().debug("\u0417\u0430\u043f\u0440\u043e\u0441 requestId");
        JSONObject requestId = this.sendRequest(this.getHttpPOSTRequest(URI.create(SEARCH_URL), "queryAll=" + inn + "&mode=search-all&mspUI1=1&mspUI2=1&mspUI3=1&msplp1=1&msplp2=1&msplp3=1&uprType1=1&uprType0=1&orgFl=1&orgUl=1&npTypeDoc=1"));
        this.getLogger().debug("\u041e\u0442\u0432\u0435\u0442= {}", (Object)requestId);
        return requestId.optString("id");
    }

    private String getRequestToken(String previewID) throws IOException, InterruptedException {
        this.getLogger().debug("getRequestToken. previewID={}", (Object)previewID);
        JSONObject response = this.sendRequest(this.getHttpPOSTRequest(URI.create(SEARCH_URL), "id=" + previewID + "&method=get-response"));
        this.getLogger().debug("Response= {}", (Object)response);
        JSONObject ul = response.optJSONObject("ul");
        this.getLogger().debug("ul={}", (Object)ul);
        if (ul == null) {
            throw new RuntimeException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0442\u043e\u043a\u0435\u043d\u0430. \u041e\u0442\u0432\u0435\u0442=" + String.valueOf(response));
        }
        JSONArray data = ul.optJSONArray("data");
        String token = data.optJSONObject(0).optString("token");
        this.getLogger().debug("token = {}", (Object)token);
        return token;
    }

    private JSONObject getActualIDAndToken(String token) throws IOException, InterruptedException {
        this.getLogger().debug("getActualIDAndToken. token = {}", (Object)token);
        return this.sendRequest(this.getHttpPOSTRequest(URI.create(COMPANY_URL), "token=" + token + "&method=get-request"));
    }

    private JSONObject companyDataSearchRequest(String requestId, String token) throws IOException, InterruptedException {
        this.getLogger().debug("companyDataSearchRequest");
        return this.sendRequest(this.getHttpPOSTRequest(URI.create(COMPANY_URL), "method=get-response&id=" + requestId + "&token=" + token));
    }

    private HttpRequest getHttpPOSTRequest(URI uri, String body) {
        HttpRequest request = HttpRequest.newBuilder(uri).timeout(Duration.ofSeconds(3L)).header("Accept", "application/json").header("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString(body, StandardCharsets.UTF_8)).build();
        this.getLogger().debug("HttpRequest = {}, Body = {}", (Object)request.toString(), (Object)body);
        return request;
    }

    private JSONObject sendRequest(HttpRequest request) {
        try {
            HttpResponse<String> response = this.retryOnNullRequest(request);
            if (response.statusCode() != 200) {
                throw new PBAPIException(String.format("Response error. code=%s, msg=%s", response.statusCode(), response.body()));
            }
            String body = response.body();
            try {
                return new JSONObject(body);
            }
            catch (JSONException ex) {
                this.getLogger().error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0430\u0440\u0441\u0438\u043d\u0433\u0430 JSON. Body=" + body, (Throwable)ex);
                ex.printStackTrace();
                throw new RuntimeException(ex);
            }
        }
        catch (IOException | InterruptedException | PBAPIException e) {
            throw new RuntimeException(e);
        }
    }

    private HttpResponse<String> retryOnNullRequest(HttpRequest request) throws IOException, InterruptedException {
        int attempt = 0;
        while (true) {
            if (attempt >= 4) {
                throw new RuntimeException("\u0418\u0441\u0442\u0435\u043a\u043b\u043e \u043a\u043e\u043b-\u0432\u043e \u043f\u043e\u043f\u044b\u0442\u043e\u043a \u0434\u043b\u044f \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0434\u0430\u043d\u043d\u044b\u0445 \u043f\u043e \u0437\u0430\u043f\u0440\u043e\u0441\u0443 = " + request.toString());
            }
            HttpResponse<String> resp = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
            String body = resp.body();
            if (body != null && !body.equals("null")) {
                return resp;
            }
            ++attempt;
            Thread.sleep(2000L);
        }
    }

    @Override
    public boolean checkSourceCondition() throws Exception {
        return true;
    }

    public static final class PBAPIException
    extends Exception {
        public PBAPIException(String message, Throwable cause) {
            super(message, cause);
        }

        public PBAPIException(String message) {
            super(message);
        }
    }
}

