/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.container.ws.common;

import jakarta.jws.WebService;
import jakarta.xml.ws.BindingProvider;
import jakarta.xml.ws.Service;
import jakarta.xml.ws.WebServiceException;
import jakarta.xml.ws.WebServiceFeature;
import jakarta.xml.ws.handler.HandlerResolver;
import jakarta.xml.ws.soap.MTOM;
import jakarta.xml.ws.soap.MTOMFeature;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import ru.bitel.common.Utils;

public abstract class WSClient {
    private static final Map<WSKey, WSService> SERVICE_MAP;
    private final Map<WSKey, WSService> serviceMap;

    protected <T> T getPort(String url, Class<T> iface, int mid) {
        return this.getPort(url, iface, null, mid);
    }

    protected WSClient() {
        this(false);
    }

    protected WSClient(boolean staticCache) {
        this.serviceMap = staticCache ? SERVICE_MAP : new ConcurrentHashMap<WSKey, WSService>();
    }

    protected WSService getService(WSKey key) {
        return this.serviceMap.get(key);
    }

    protected void putService(WSKey key, WSService service) {
        this.serviceMap.put(key, service);
    }

    protected WSService getService(String url, Class<?> iface, String module, int mid) throws MalformedURLException {
        return this.getService(new WSKey(this, url, iface, module, mid), url, iface, module, mid);
    }

    public static String getNamespace(String packageName) {
        String[] tokens;
        if (packageName.length() == 0) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(packageName, ".");
        if (tokenizer.countTokens() == 0) {
            tokens = new String[]{};
        } else {
            tokens = new String[tokenizer.countTokens()];
            for (int i = tokenizer.countTokens() - 1; i >= 0; --i) {
                tokens[i] = tokenizer.nextToken();
            }
        }
        StringBuilder namespace = new StringBuilder("http://");
        for (int i = 0; i < tokens.length; ++i) {
            if (i != 0) {
                namespace.append('.');
            }
            namespace.append(tokens[i]);
        }
        namespace.append('/');
        return namespace.toString();
    }

    protected WSService getService(WSKey key, String url, Class<?> iface, String module, int moduleId) throws MalformedURLException {
        return this.getService(key, url, iface, module, moduleId, false);
    }

    protected WSService getService(WSKey key, String url, Class<?> iface, String module, int mid, boolean forceServerWsdl) throws MalformedURLException {
        Service webService;
        String s;
        WSService result = this.getService(key);
        if (result != null) {
            return result;
        }
        WebService service = iface.getAnnotation(WebService.class);
        if (service == null) {
            throw new IllegalArgumentException("WebService annotation not found!");
        }
        String n = service.targetNamespace();
        if (Utils.isEmptyString((String)n)) {
            n = WSClient.getNamespace(iface.getPackage().getName());
        }
        if (Utils.isEmptyString((String)(s = service.serviceName()))) {
            s = iface.getSimpleName();
        }
        String name = iface.getSimpleName();
        String ifaceName = iface.getName();
        if (ifaceName.startsWith("ru.bitel.bgbilling.")) {
            module = ifaceName.substring(0, ifaceName.length() - iface.getSimpleName().length() - 1);
            if (module.endsWith(".common.service")) {
                module = module.substring(0, module.length() - 15);
            } else if (module.endsWith(".common")) {
                module = module.substring(0, module.length() - 7);
            }
        } else if (ifaceName.startsWith("ru.bitel.oss.")) {
            module = ifaceName.substring(0, ifaceName.length() - iface.getSimpleName().length() - 1);
            if (module.endsWith(".common.service")) {
                module = module.substring(0, module.length() - 15);
            } else if (module.endsWith(".common")) {
                module = module.substring(0, module.length() - 7);
            }
        } else if (ifaceName.startsWith("api.")) {
            module = ifaceName.substring(4, ifaceName.length() - iface.getSimpleName().length() - 1);
            url = url.replaceFirst("/executer\\z", "/api");
        } else {
            module = ifaceName.substring(0, ifaceName.length() - iface.getSimpleName().length() - 1);
        }
        String endpointAddress = url + "/" + module + "/" + (String)(mid > 0 ? mid + "/" : "") + name;
        URL wsdlURL = iface.getResource(iface.getSimpleName() + ".wsdl");
        if (wsdlURL == null || forceServerWsdl) {
            wsdlURL = URI.create(endpointAddress + "?wsdl").toURL();
            webService = Service.create((URL)wsdlURL, (QName)new QName(n, s));
        } else {
            try {
                webService = Service.create((URL)wsdlURL, (QName)new QName(n, s));
            }
            catch (WebServiceException ex) {
                ex.printStackTrace();
                wsdlURL = URI.create(endpointAddress + "?wsdl").toURL();
                webService = Service.create((URL)wsdlURL, (QName)new QName(n, s));
            }
        }
        webService.setHandlerResolver(this.newHandlerResolver(webService));
        result = new WSService(this, webService, endpointAddress);
        this.putService(key, result);
        return result;
    }

    protected <T> T getPort(String url, Class<T> iface, String module, int moduleId) {
        try {
            Object port;
            WSService service;
            WSKey key = new WSKey(this, url, iface, module, moduleId);
            try {
                service = this.getService(key, url, iface, module, moduleId);
                Service webService = service.service;
                MTOMFeature mtomFeature = null;
                MTOM mtom = iface.getAnnotation(MTOM.class);
                if (mtom != null) {
                    mtomFeature = new MTOMFeature(mtom.enabled(), mtom.threshold());
                }
                port = mtomFeature != null ? webService.getPort(iface, new WebServiceFeature[]{mtomFeature}) : webService.getPort(iface);
            }
            catch (WebServiceException ex) {
                this.serviceMap.remove(key);
                service = this.getService(key, url, iface, module, moduleId, true);
                Service webService = service.service;
                MTOMFeature mtomFeature = null;
                MTOM mtom = iface.getAnnotation(MTOM.class);
                if (mtom != null) {
                    mtomFeature = new MTOMFeature(mtom.enabled(), mtom.threshold());
                }
                port = mtomFeature != null ? webService.getPort(iface, new WebServiceFeature[]{mtomFeature}) : webService.getPort(iface);
            }
            Map requestContext = ((BindingProvider)port).getRequestContext();
            requestContext.put("jakarta.xml.ws.session.maintain", true);
            requestContext.put("jakarta.xml.ws.service.endpoint.address", service.endpointAddress);
            HashMap<String, List<String>> httpHeaders = new HashMap<String, List<String>>();
            httpHeaders.put("Accept-Encoding", Collections.singletonList("gzip"));
            requestContext.put("jakarta.xml.ws.http.request.headers", httpHeaders);
            return (T)port;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public abstract HandlerResolver newHandlerResolver(Service var1);

    static {
        System.setProperty("jakarta.xml.soap.SAAJMetaFactory", "com.sun.xml.messaging.saaj.soap.SAAJMetaFactoryImpl");
        SERVICE_MAP = new ConcurrentHashMap<WSKey, WSService>();
    }

    protected class WSService {
        final Service service;
        final String endpointAddress;

        public WSService(WSClient this$0, Service service, String endpointAddress) {
            this.service = service;
            this.endpointAddress = endpointAddress;
        }
    }

    protected class WSKey {
        final String url;
        final Class<?> iface;
        final String module;
        final int mid;

        public WSKey(WSClient this$0, String url, Class<?> iface, String module, int mid) {
            this.url = url;
            this.iface = iface;
            this.module = module;
            this.mid = mid;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.iface == null ? 0 : this.iface.hashCode());
            result = 31 * result + this.mid;
            result = 31 * result + (this.module == null ? 0 : this.module.hashCode());
            result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WSKey other = (WSKey)obj;
            if (this.iface == null ? other.iface != null : !this.iface.equals(other.iface)) {
                return false;
            }
            if (this.mid != other.mid) {
                return false;
            }
            if (this.module == null ? other.module != null : !this.module.equals(other.module)) {
                return false;
            }
            return !(this.url == null ? other.url != null : !this.url.equals(other.url));
        }
    }
}

