/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.object.server.service;

import bitel.billing.server.ApplicationModule;
import bitel.billing.server.contract.object.bean.ListValueManager;
import bitel.billing.server.contract.object.bean.ObjectTypeManager;
import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.security.server.PermissionOfRoles;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractModuleManager;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractStatusDao;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ContractObject;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ListValue;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ModuleEntity;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ObjectParam;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ObjectParamType;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ObjectParameterGroupAttr;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ObjectType;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ObjectTypeParameter;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ParamAddressValue;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ParamDateValue;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ParamFlagValue;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ParamListValue;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ParamTextValue;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ParamValue;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ParameterHistoryEntry;
import ru.bitel.bgbilling.kernel.contract.object.common.dto.ContractObjectModuleDTO;
import ru.bitel.bgbilling.kernel.contract.object.common.dto.ContractObjectParameterDTO;
import ru.bitel.bgbilling.kernel.contract.object.common.service.ContractObjectService;
import ru.bitel.bgbilling.kernel.contract.object.server.bean.ContractObjectDao;
import ru.bitel.bgbilling.kernel.contract.object.server.bean.ObjectParamDao;
import ru.bitel.bgbilling.kernel.contract.object.server.bean.ObjectParamTypeDao;
import ru.bitel.bgbilling.kernel.contract.object.server.bean.ParamValueManager;
import ru.bitel.bgbilling.kernel.contract.object.server.utils.ObjectUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.ContractAddObjectEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractDeleteObjectEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractObjectParameterBeforeUpdateEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractObjectParameterUpdateEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractUpdateObjectEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ObjectMoveEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.server.util.ClosedDateChecker;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;
import ru.bitel.oss.kernel.entity.common.bean.AddressStruct;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrBoolean;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrDate;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrList;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrText;
import ru.bitel.oss.kernel.entity.common.bean.enums.EntitySpecAttrType;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.contract.object.common.service.ContractObjectService")
public class ContractObjectServiceImpl
extends AbstractService
implements ContractObjectService {
    private ContractObjectDao contractObjectDao;
    private ParamValueManager paramValueManager;

    @PostConstruct
    protected void init() {
        this.contractObjectDao = new ContractObjectDao(this.getConnection(), this.userId);
        this.paramValueManager = new ParamValueManager(this.getConnection());
    }

    @Override
    public List<ContractObject> contractObjectList(int contractId) throws Exception {
        return this.contractObjectDao.list(contractId);
    }

    @Override
    public SearchResult<ContractObject> contractObjectTable(int contractId, String filterTitle, int filterType, Page page) throws Exception {
        SearchResult searchResult = new SearchResult(page);
        this.contractObjectDao.contractObjectTable((SearchResult<ContractObject>)searchResult, contractId, filterTitle, filterType);
        return searchResult;
    }

    @Override
    public ContractObject contractObjectGet(int contractId, int objectId) throws Exception {
        return (ContractObject)this.contractObjectDao.get(objectId);
    }

    @Override
    public int contractObjectUpdate(int contractId, ContractObject contractObject) throws Exception {
        boolean isNewObject;
        Date dateFromOld = null;
        Date dateToOld = null;
        boolean bl = isNewObject = contractObject.getId() <= 0;
        if (!isNewObject) {
            ContractObject old = (ContractObject)this.contractObjectDao.get(contractObject.getId());
            if (old.getTypeId() != contractObject.getTypeId()) {
                throw new BGMessageException("\u041f\u0435\u0440\u0435\u0434\u0430\u043d \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0442\u0438\u043f \u043e\u0431\u044a\u0435\u043a\u0442\u0430!");
            }
            dateFromOld = old.getDateFrom();
            dateToOld = old.getDateTo();
        }
        Calendar closedDate = null;
        closedDate = ClosedDateChecker.getClosePeriodDateIfChecking("ActionObjectUpdate", 0, this.userId);
        if (closedDate != null) {
            ClosedDateChecker.checkDatesForUpdate(closedDate, dateFromOld, dateToOld, contractObject.getDateFrom(), contractObject.getDateTo());
        }
        this.contractObjectDao.update((Object)contractObject);
        if (isNewObject) {
            this.context.publishAfterCommit(new ContractAddObjectEvent(this.userId, contractObject));
        } else {
            this.context.publishAfterCommit(new ContractUpdateObjectEvent(this.userId, contractObject));
        }
        return contractObject.getId();
    }

    @Override
    public void contractObjectDelete(int contractId, int objectId) throws Exception {
        ContractObject object = (ContractObject)this.contractObjectDao.get(objectId);
        if (object != null) {
            new ContractStatusDao(this.getConnection()).deleteContractObjectStatus(contractId, object.getId());
            this.contractObjectDao.delete(object.getId());
            this.paramValueManager.deleteActivityParamValues(object.getId());
            EventProcessor.getInstance().request(new ObjectMoveEvent(this.userId, object.getContractId(), object.getId(), 0));
            this.context.publishAfterCommit(new ContractDeleteObjectEvent(this.userId, object));
        }
    }

    @Override
    public void contractObjectClone(int contractId, int objectId, boolean clonePeriod) throws Exception {
        ContractObject original = (ContractObject)this.contractObjectDao.get(objectId);
        if (original == null) {
            throw new BGMessageException("\u041e\u0431\u044a\u0435\u043a\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
        }
        ContractObject copy = ContractObject.builder().setContractId(original.getContractId()).setTitle(original.getTitle()).setEntitySpecId(original.getEntitySpecId()).setTypeId(original.getTypeId()).setEntityAttributes(original.getEntityAttributes()).build();
        if (clonePeriod) {
            copy.setDateFrom(original.getDateFrom());
            copy.setDateTo(original.getDateTo());
        }
        this.contractObjectDao.update((Object)copy);
        this.paramValueManager.copyObjectParams(objectId, copy.getId());
    }

    @Override
    public void contractObjectOrder(int contractId, int objectId, boolean up) throws Exception {
        this.contractObjectDao.orderObject(objectId, up);
    }

    @Override
    public List<ContractObjectParameterDTO> contractObjectParameters(int contractId, int objectId) throws Exception {
        ArrayList<ContractObjectParameterDTO> list = new ArrayList<ContractObjectParameterDTO>();
        Connection con = this.getConnection();
        ContractObject object = (ContractObject)this.contractObjectDao.get(objectId);
        if (object == null) {
            return list;
        }
        ObjectType type = new ObjectTypeManager(con).getType(object.getTypeId());
        if (type == null) {
            return list;
        }
        Map<Integer, ListValue> listValuesMap = new ListValueManager(con).getValuesMap();
        Map<Integer, ObjectParam> paramMap = new ObjectParamDao(con).getParamMap();
        List<ObjectParamType> typeParamList = new ObjectParamTypeDao(con).getTypeParamList(type.getId());
        Map<Integer, ParamValue> valuesMap = new ParamValueManager(con).getObjectParamMap(objectId);
        for (ObjectParamType typeParam : typeParamList) {
            ObjectParam objectParam = paramMap.get(typeParam.getParamId());
            if (objectParam == null) continue;
            String valueData = "";
            ParamValue value = valuesMap.get(objectParam.getId());
            boolean parameterAllowed = PermissionOfRoles.checkReadObjectParameter(objectParam.getId(), this.userId);
            if (parameterAllowed) {
                if (value != null) {
                    switch ((EntitySpecAttrType)EntitySpecAttrType.optEntitySpecAttrType((int)objectParam.getTypeId()).get()) {
                        case TEXT: {
                            valueData = ((ParamTextValue)value).getValue();
                            break;
                        }
                        case BOOLEAN: {
                            valueData = String.valueOf(((ParamFlagValue)value).getValue());
                            break;
                        }
                        case ADDRESS: {
                            valueData = ((ParamAddressValue)value).getAddress();
                            break;
                        }
                        case DATE: {
                            valueData = TimeUtils.formatDate((Calendar)((ParamDateValue)value).getValue());
                            break;
                        }
                        case LIST: {
                            ListValue listValue = listValuesMap.get(((ParamListValue)value).getValue());
                            valueData = listValue != null ? listValue.getTitle() : "";
                            break;
                        }
                        default: {
                            break;
                        }
                    }
                }
            } else {
                valueData = "<\u0421\u041a\u0420\u042b\u0422\u041e>";
            }
            list.add(new ContractObjectParameterDTO(objectParam.getId(), objectParam.getTypeId(), objectParam.getTitle(), objectParam.isHistory() ? "loopa" : "loopa_fade", valueData));
        }
        return list;
    }

    @Override
    public List<ContractObjectModuleDTO> contractObjectModuleList(int contractId, int objectId) throws Exception {
        ObjectTypeManager typeManager;
        ObjectType type;
        ArrayList<ContractObjectModuleDTO> modules = new ArrayList<ContractObjectModuleDTO>();
        ContractObject object = (ContractObject)this.contractObjectDao.get(objectId);
        if (object != null && (type = (typeManager = new ObjectTypeManager(this.getConnection())).getType(object.getTypeId())) != null) {
            ContractModuleManager contractModuleManager = new ContractModuleManager(this.getConnection());
            Set<Integer> contractModuleIds = contractModuleManager.getContractModuleSet(object.getContractId());
            for (Integer moduleId : type.getModuleList()) {
                BGModule module;
                if (!contractModuleIds.contains(moduleId) || (module = ModuleCache.getInstance().getModule(moduleId)) == null) continue;
                ContractObjectModuleDTO moduleDTO = ContractObjectModuleDTO.builder().setModuleId(moduleId).setTitle(module.getTitle()).setModule(module.getName()).setClientPackage(module.getInstalledModule().getPackageClient()).build();
                ApplicationModule moduleBean = ModuleCache.getInstance().getApplicationModule(module.getName());
                if (moduleBean != null) {
                    List<ModuleEntity> entityList = moduleBean.getObjectEntities(this.getConnection(), module.getId(), objectId);
                    if (entityList == null) continue;
                    moduleDTO.setModuleEntities(entityList);
                }
                modules.add(moduleDTO);
            }
        }
        return modules;
    }

    @Override
    public EntityAttr objectParameterGet(int contractId, int objectId, int parameterId) throws Exception {
        try (ContractObjectDao contractObjectDao = new ContractObjectDao(this.getConnection(), this.userId);){
            EntityAttr entityAttr = contractObjectDao.getObjectParameter(objectId, parameterId);
            return entityAttr;
        }
    }

    @Override
    public AddressStruct objectParameterAddressStructGet(int contractId, int objectId, int parameterId) throws Exception {
        if (objectId <= 0 || parameterId <= 0) {
            throw new BGIllegalArgumentException();
        }
        AddressStruct address = null;
        String query = "SELECT address.hid, country.title as country, street.cityid as cityid, city.title as city, area.title as area, quarter.title as quarter, house.streetid as streetid, street.title as street, house.frac, house.box_index, house.house, address.pod, address.floor, address.flat, address.room, address.comment, address.format_key, address.address FROM object_param_value_address AS address LEFT JOIN address_house as house on address.hid=house.id LEFT JOIN address_area as area ON house.areaid=area.id LEFT JOIN address_quarter as quarter ON house.quarterid=quarter.id LEFT JOIN address_street as street ON house.streetid=street.id LEFT JOIN address_city as city ON street.cityid=city.id LEFT JOIN address_country as country ON city.country_id=country.id WHERE address.object_id=? AND address.param_id=? ";
        try (PreparedStatement ps = this.getConnection().prepareStatement(query);){
            ps.setInt(1, objectId);
            ps.setInt(2, parameterId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    address = this.getAddressStruct(rs);
                }
            }
        }
        return address;
    }

    private AddressStruct getAddressStruct(ResultSet rs) throws Exception {
        String area = rs.getString("area");
        String quarter = rs.getString("quarter");
        return AddressStruct.builder().setHouseId(rs.getInt("hid")).setIndex(rs.getString("box_index")).setCountry(rs.getString("country")).setCity(rs.getString("city")).setArea(area != null ? area : null).setQuarter(quarter != null ? quarter : null).setStreet(rs.getString("street")).setHouse(String.valueOf(rs.getInt("house"))).setFrac(rs.getString("frac")).setFlat(rs.getString("flat")).setRoom(rs.getString("room")).setPod(rs.getInt("pod") == 0 ? "" : rs.getString("pod")).setFloor(rs.getInt("floor") == 0 ? "" : rs.getString("floor")).setFullAddress(rs.getString("address")).setComment(rs.getString("comment")).build();
    }

    @Override
    public void objectParameterAddressUpdate(int contractId, EntityAttrAddress entityAttrAddress) throws Exception {
        if (entityAttrAddress == null) {
            throw new BGIllegalArgumentException();
        }
        this.changeObjectParam((EntityAttr)entityAttrAddress);
    }

    @Override
    public void objectParameterAddressDelete(int contractId, int objectId, int parameterId) throws Exception {
        if (objectId <= 0 || parameterId <= 0) {
            throw new BGIllegalArgumentException();
        }
        EntityAttrAddress entityAttrAddress = new EntityAttrAddress(objectId, parameterId);
        entityAttrAddress.setHouseId(-1);
        this.changeObjectParam((EntityAttr)entityAttrAddress);
    }

    private void changeObjectParam(EntityAttr entityAttr) throws Exception {
        ContractObject contractObject = (ContractObject)this.contractObjectDao.get(entityAttr.getEntityId());
        if (contractObject == null) {
            throw new BGMessageException("\u041e\u0431\u044a\u0435\u043a\u0442 \u0441 \u043a\u043e\u0434\u043e\u043c " + entityAttr.getEntityId() + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
        }
        int contractId = contractObject.getContractId();
        ContractObjectParameterBeforeUpdateEvent beforeUpdate = new ContractObjectParameterBeforeUpdateEvent(this.userId, contractId, entityAttr);
        beforeUpdate = EventProcessor.getInstance().request(beforeUpdate);
        String error = beforeUpdate.getError();
        if (Utils.notBlankString((String)error)) {
            throw new BGMessageException(error);
        }
        this.contractObjectDao.updateObjectParameter(entityAttr.getEntityId(), entityAttr);
        ContractObjectParameterUpdateEvent afterUpdate = new ContractObjectParameterUpdateEvent(this.userId, contractId, entityAttr);
        this.context.publishAfterCommit(afterUpdate);
    }

    @Override
    public void objectParameterTextUpdate(int contractId, EntityAttrText entityAttrText) throws Exception {
        if (entityAttrText == null) {
            throw new BGIllegalArgumentException();
        }
        this.changeObjectParam((EntityAttr)entityAttrText);
    }

    @Override
    public void objectParameterFlagUpdate(int contractId, EntityAttrBoolean entityAttrBoolean) throws Exception {
        if (entityAttrBoolean == null) {
            throw new BGIllegalArgumentException();
        }
        this.changeObjectParam((EntityAttr)entityAttrBoolean);
    }

    @Override
    public void objectParameterDateUpdate(int contractId, EntityAttrDate entityAttrDate) throws Exception {
        if (entityAttrDate == null) {
            throw new BGIllegalArgumentException();
        }
        this.changeObjectParam((EntityAttr)entityAttrDate);
    }

    @Override
    public void objectParameterListUpdate(int contractIdId, EntityAttrList entityAttrList) throws Exception {
        if (entityAttrList == null) {
            throw new BGIllegalArgumentException();
        }
        this.changeObjectParam((EntityAttr)entityAttrList);
    }

    @Override
    public List<ParameterHistoryEntry> objectParameterHistoryList(int contractId, int objectId, int parameterId, int parameterType) throws Exception {
        if (objectId <= 0 || parameterId <= 0) {
            throw new BGIllegalArgumentException();
        }
        return this.paramValueManager.getParameterHistory(objectId, parameterId, parameterType);
    }

    @Override
    public void objectParameterHistoryClear(int contractId, int objectId, int parameterId, int parameterType) throws Exception {
        if (objectId <= 0 || parameterId <= 0) {
            throw new BGIllegalArgumentException();
        }
        this.paramValueManager.clearParameterHistory(objectId, parameterId, parameterType);
    }

    @Override
    public List<ObjectType> objectTypeList(boolean onlyVisible) throws Exception {
        return new ObjectTypeManager(this.getConnection()).getTypeList(onlyVisible);
    }

    @Override
    public List<IdTitle> objectTypeTitles(boolean onlyVisible) throws Exception {
        return new ObjectTypeManager(this.getConnection()).getTypeList(onlyVisible).stream().map(IdTitle::toIdTitle).toList();
    }

    @Override
    public int objectTypeUpdate(ObjectType objectType) throws Exception {
        return new ObjectTypeManager(this.getConnection()).updateType(objectType);
    }

    @Override
    public ObjectType objectTypeGet(int typeId) throws Exception {
        return new ObjectTypeManager(this.getConnection()).getType(typeId);
    }

    @Override
    public void objectTypeDelete(int typeId) throws Exception {
        new ObjectTypeManager(this.getConnection()).deleteType(typeId);
    }

    @Override
    public SearchResult<ObjectParameterGroupAttr> objectParamSearch() throws Exception {
        SearchResult searchResult = new SearchResult();
        ArrayList<ObjectParameterGroupAttr> list = new ArrayList<ObjectParameterGroupAttr>();
        searchResult.setList(list);
        for (ObjectParam param : new ObjectParamDao(this.getConnection()).getParamList()) {
            list.add((ObjectParameterGroupAttr)ObjectParameterGroupAttr.builder().setId(param.getId()).setTitle(param.getTitle()).setType(param.getTypeId()).setComment(param.getComment()).setHistory(param.isHistory()).build());
        }
        return searchResult;
    }

    @Override
    public ObjectParameterGroupAttr objectParamGet(int parameterId) throws Exception {
        return ObjectUtils.convertObjectParamToContractObjectParam(new ObjectParamDao(this.getConnection()).getParameter(parameterId));
    }

    @Override
    public void objectParamUpdate(ObjectParameterGroupAttr contractObjectParam) throws Exception {
        ObjectParam parameter = ObjectUtils.convertContractObjectParamToObjectParam(contractObjectParam);
        if (parameter != null) {
            new ObjectParamDao(this.getConnection()).updateParam(parameter);
        }
    }

    @Override
    public void objectParamDelete(int id) throws Exception {
        new ObjectParamDao(this.getConnection()).deleteParam(id);
    }

    @Override
    public List<ObjectTypeParameter> objectTypeParameterList(int objectTypeId) throws Exception {
        ArrayList<ObjectTypeParameter> objectTypeParameters = new ArrayList<ObjectTypeParameter>();
        Map<Integer, ObjectParam> paramMap = new ObjectParamDao(this.getConnection()).getParamMap();
        for (ObjectParamType typeParam : new ObjectParamTypeDao(this.getConnection()).getTypeParamList(objectTypeId)) {
            ObjectTypeParameter objectTypeParameter = new ObjectTypeParameter();
            objectTypeParameter.setParameterId(typeParam.getParamId());
            ObjectParam param = paramMap.get(typeParam.getParamId());
            objectTypeParameter.setParameterTitle(param != null ? param.getTitle() : "???");
            objectTypeParameter.setParameterTypeTitle(param != null ? EntitySpecAttrType.optEntitySpecAttrType((int)param.getTypeId()).map(a -> a.getTypeTitle()).orElse("???") : "???");
            objectTypeParameters.add(objectTypeParameter);
        }
        return objectTypeParameters;
    }

    @Override
    public List<IdTitle> getAvailableTypeForObjectType(int objectTypeId) throws Exception {
        Set typeParamSet = new ObjectParamTypeDao(this.getConnection()).getTypeParamList(objectTypeId).stream().mapToInt(ObjectParamType::getParamId).boxed().collect(Collectors.toSet());
        return new ObjectParamDao(this.getConnection()).getParamMap().entrySet().stream().filter(entry -> !typeParamSet.contains(entry.getKey())).map(entry -> new IdTitle(((Integer)entry.getKey()).intValue(), ((ObjectParam)((Object)((Object)entry.getValue()))).getTitle())).collect(Collectors.toList());
    }

    @Override
    public void updateLinkParameterWithObjectType(int objectTypeId, int parameterId, boolean add) throws Exception {
        ObjectParamType typeParam = new ObjectParamType().setTypeId(objectTypeId).setParamId(parameterId);
        if (add) {
            new ObjectParamTypeDao(this.getConnection()).addTypeParam(typeParam);
        } else {
            new ObjectParamTypeDao(this.getConnection()).deleteTypeParam(typeParam);
        }
    }

    @Override
    public void parameterMoving(int objectTypeParameterId, int parameterId, boolean moveToUp) throws Exception {
        ObjectParamType typeParam = new ObjectParamType().setTypeId(objectTypeParameterId).setParamId(parameterId);
        if (moveToUp) {
            new ObjectParamTypeDao(this.getConnection()).moveUp(typeParam);
        } else {
            new ObjectParamTypeDao(this.getConnection()).moveDown(typeParam);
        }
    }

    @Override
    public List<ListValue> getValuesForListParameter(int parameterId) throws Exception {
        return new ListValueManager(this.getConnection()).getValues(parameterId);
    }

    @Override
    public List<ObjectParameterGroupAttr> getListParameters() throws Exception {
        return new ObjectParamDao(this.getConnection()).getParamList(EntitySpecAttrType.LIST.getCode()).stream().map(o -> ObjectUtils.convertObjectParamToContractObjectParam(o)).collect(Collectors.toList());
    }

    @Override
    public void updateListParameterValue(ListValue listValue) throws Exception {
        new ListValueManager(this.getConnection()).updateValue(listValue);
    }

    @Override
    public void deleteListParameterValue(int valueId) throws Exception {
        new ListValueManager(this.getConnection()).deleteValue(valueId);
    }
}

