/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius.info;

import java.nio.ByteBuffer;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttribute;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeInfo;
import ru.bitel.bgbilling.kernel.network.radius.eap.EAPMessage;
import ru.bitel.bgbilling.kernel.network.tlv.Tlv;
import ru.bitel.common.Utils;

public class EapInfo
extends RadiusAttributeInfo<EAPMessage> {
    public EapInfo(int vendor, int code, String name, Element attr, List<RadiusAttributeInfo<?>> children) {
        super(vendor, code, name, 1, attr, children);
        this.fragmented = true;
    }

    @Override
    public RadiusAttribute<?> read(ByteBuffer bb, RadiusAttributeInfo.RadiusAttributeHeader header) {
        ByteBuffer eapData;
        ByteBuffer allData;
        byte type;
        int[] tag = new int[1];
        ByteBuffer data = this.sliceData(bb, header.length);
        ByteBuffer dataWithoutTag = this.tagUnwrap(data, header);
        byte code = dataWithoutTag.get(0);
        byte identifier = dataWithoutTag.get(1);
        if (code == 1 || code == 2) {
            int eapLength = dataWithoutTag.getShort(2) & 0xFFFF;
            type = dataWithoutTag.get(4);
            if (eapLength <= header.length) {
                allData = dataWithoutTag;
            } else {
                int raType;
                allData = ByteBuffer.allocate(eapLength - 5);
                allData.put(dataWithoutTag);
                int position = bb.position();
                while (position < bb.limit() && (raType = bb.get(position) & 0xFF) == 79) {
                    bb.position(position + 1);
                    header.length = bb.get() & 0xFF;
                    data = this.sliceData(bb, header.length);
                    allData.put(data);
                    position = bb.position();
                }
                if (allData.position() != allData.capacity()) {
                    throw new IllegalArgumentException();
                }
            }
            allData.position(5);
            eapData = allData.slice();
            allData.clear();
        } else {
            allData = dataWithoutTag;
            type = 0;
            eapData = null;
        }
        return new RadiusAttribute<EAPMessage>(this, tag[0], allData, new EAPMessage(code, identifier, type, eapData));
    }

    @Override
    public EAPMessage unwrapValue(ByteBuffer dataWithoutTag) {
        ByteBuffer eapData;
        byte type;
        byte code = dataWithoutTag.get(0);
        byte identifier = dataWithoutTag.get(1);
        if (code == 1 || code == 2) {
            type = dataWithoutTag.get(4);
            dataWithoutTag.position(5);
            eapData = dataWithoutTag.slice();
            dataWithoutTag.clear();
        } else {
            type = 0;
            eapData = null;
        }
        return new EAPMessage(code, identifier, type, eapData);
    }

    @Override
    public ByteBuffer wrapValue(EAPMessage value) {
        ByteBuffer data;
        if (value.code == 1 || value.code == 2) {
            int eapLength = value.getData().capacity();
            data = ByteBuffer.allocate(eapLength + 5);
            data.put(value.code);
            data.put(value.identifier);
            data.putShort((short)(eapLength & 0xFFFF));
            data.put(value.type);
            data.put(value.getData());
        } else {
            data = ByteBuffer.allocate(5);
            data.put(value.code);
            data.put(value.identifier);
            data.putShort((short)5);
            data.put(value.type);
        }
        data.clear();
        return data;
    }

    @Override
    public String valueToString(Tlv<?, EAPMessage> attribute) {
        return "{" + Utils.bytesToString(attribute.getDataAsByteArray()) + "}";
    }
}

