/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGUTabPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.table.client.BGDataSourceTableModel;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServType;
import ru.bitel.bgbilling.modules.inet.common.service.InetServService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;

public class InetSearchPanel
extends BGUTabPanel {
    private InetServService inetServService = null;
    private BGUTableParams tableParams = null;
    private JLabel recordCount = new JLabel();
    private BGDataSourceTableModel tableModel = new BGDataSourceTableModel("InetSearch");
    private BGUComboBox<InetServType> serviceType = new BGUComboBox();
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private JTextField searchFieldValue = new JTextField(25);
    private BGUComboBox<KeyValue> searchFields = new BGUComboBox();
    private List<KeyValue> searchFieldItems = Arrays.asList(new KeyValue("login", "\u041b\u043e\u0433\u0438\u043d"), new KeyValue("ip", "IP \u0430\u0434\u0440\u0435\u0441, \u0441\u0435\u0442\u044c, \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d"), new KeyValue("vlan", "VLAN"), new KeyValue("identifier", "\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440"), new KeyValue("macAddress", "MAC-\u0430\u0434\u0440\u0435\u0441"), new KeyValue("title", "\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"));

    public InetSearchPanel(ClientContext ctx) {
        super(ctx);
    }

    protected void jbInit() {
        BGUTable table = new BGUTable((TableModel)this.tableModel);
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                InetServ inetServ;
                if (e.getClickCount() == 2 && (inetServ = (InetServ)InetSearchPanel.this.tableModel.getSelectRow(InetServ.class)) != null) {
                    ClientUtils.openContract((int)inetServ.getContractId());
                }
            }
        });
        this.searchFields.setData(this.searchFieldItems);
        this.searchFieldValue.setHorizontalAlignment(0);
        this.searchFieldValue.setMinimumSize(new Dimension(150, 25));
        BGButton clearField = new BGButton("X");
        clearField.addActionListener(e -> this.searchFieldValue.setText(""));
        Action find = this.getActionMap().get("find");
        BGButton searchButton = new BGButton(find);
        this.searchFieldValue.setAction(find);
        this.pagePanel.addToHandler(a -> this.doSearch());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.searchFields, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)this.searchFieldValue, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)clearField, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)new JLabel("\u0422\u0438\u043f \u0441\u0435\u0440\u0432\u0438\u0441\u0430"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 30, 0, 5), 0, 0));
        panel.add((Component)this.serviceType, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)searchButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 30, 0, 5), 0, 0));
        panel.add((Component)this.recordCount, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 30, 0, 15), 0, 0));
        panel.add((Component)this.pagePanel, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add(panel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add(BGSwingUtilites.wrapEmptyBorder((JComponent)new JScrollPane((Component)table)), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    private InetServService getInetServService() {
        if (this.inetServService == null) {
            this.inetServService = (InetServService)((ClientContext)this.getContext()).getPort(InetServService.class);
        }
        return this.inetServService;
    }

    private void doSearch() {
        if (this.tableParams != null) {
            this.tableParams.setPage(this.pagePanel.getPage());
            this.tableModel.loadData((ClientContext)this.getContext(), this.tableParams, this.pagePanel, this.recordCount);
        }
    }

    private boolean checkIPv4(String value) {
        String[] a = value.split("\\.");
        if (a.length != 4) {
            return false;
        }
        for (String a1 : a) {
            int v = Utils.parseInt((String)a1);
            if (a1.matches("^\\d+$") && v >= 0 && v <= 255) continue;
            return false;
        }
        return true;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            List typeList = this.getInetServService().inetServTypeList();
            typeList.add(0, new InetServType().setId(0).setTitle("\u041b\u044e\u0431\u043e\u0439"));
            this.serviceType.setData(typeList);
            this.tableModel.loadData((ClientContext)this.getContext(), null);
        });
        new AbstractBGUPanel.DefaultAction("find", "\u041d\u0430\u0439\u0442\u0438"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                if (Utils.isBlankString((String)InetSearchPanel.this.searchFieldValue.getText())) {
                    ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u043e\u0438\u0441\u043a\u043e\u0432\u043e\u0433\u043e \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
                    return;
                }
                InetSearchPanel.this.pagePanel.setPageIndex(1);
                InetServType selectedType = (InetServType)InetSearchPanel.this.serviceType.getSelectedItem();
                KeyValue selectedItem = (KeyValue)InetSearchPanel.this.searchFields.getSelectedItem();
                String filterValue = InetSearchPanel.this.searchFieldValue.getText();
                int vlanInt = -1;
                if ("vlan".equals(selectedItem.getKey())) {
                    vlanInt = Utils.parseInt((String)filterValue, (int)-1);
                    if (vlanInt == -1) {
                        ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0451\u043d VLAN!");
                        return;
                    }
                } else if ("ip".equals(selectedItem.getKey())) {
                    boolean error = true;
                    if (filterValue.indexOf(45) > -1) {
                        String[] a = filterValue.split("-");
                        if (a.length == 2 && InetSearchPanel.this.checkIPv4(a[0]) && InetSearchPanel.this.checkIPv4(a[1])) {
                            error = false;
                        }
                    } else if (filterValue.indexOf(47) > -1) {
                        String[] a = filterValue.split("/");
                        if (a.length == 2 && InetSearchPanel.this.checkIPv4(a[0]) && Utils.parseInt((String)a[1]) < 33) {
                            error = false;
                        }
                    } else if (InetSearchPanel.this.checkIPv4(filterValue)) {
                        error = false;
                    }
                    if (error) {
                        ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435! \n\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0430\u0434\u0440\u0435\u0441(A.B.C.D), \u0441\u0435\u0442\u044c(A.B.C.D/N) \u0438\u043b\u0438 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d(A1.B1.C1.D1-A2.B2.C2.D2)");
                        return;
                    }
                }
                InetSearchPanel.this.tableParams = new BGUTableParams().addParam("typeId", selectedType != null ? selectedType.getId() : 0).addParam("filter_key", selectedItem.getKey()).addParam("filter_value", filterValue);
                InetSearchPanel.this.doSearch();
            }
        };
    }
}

