/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.server.file;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.filestorage.common.bean.BGServerFile;
import ru.bitel.bgbilling.kernel.filestorage.server.FileStorage;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Message;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.TopicManager;
import ru.bitel.bgbilling.plugins.helpdesk.server.filestorage.HelpdeskFileStorage;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.io.Base64;
import ru.bitel.common.util.FileDownload;

public class FileUtils
extends BGLogger {
    private BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.helpdesk");

    public int uploadHelpdeskFile(BGServerFile serverFile, InputStream inputStream) throws BGException {
        try {
            Path path = Files.createTempFile("aaa", "bbb", new FileAttribute[0]);
            Files.write(path, Utils.readByBlock((InputStream)inputStream), new OpenOption[0]);
            return this.uploadHelpdeskFile(serverFile, path);
        }
        catch (IOException e) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430.\n\u0418\u043b\u0438 \u043f\u0440\u0438\u0448\u043b\u0438 \u0431\u0438\u0442\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u0444\u0430\u0439\u043b\u0430.\n" + e.getMessage());
        }
    }

    public int uploadHelpdeskFile(BGServerFile serverFile, Path path) throws BGException {
        block13: {
            try (Connection connection = this.getConnection();){
                FileStorage fileStorage = this.getFileStorage(connection);
                fileStorage.updateFile(serverFile);
                if (serverFile.getId() > 0) {
                    try {
                        String rootPath = this.plugin.getSetup().get("file.storage.root.path");
                        if (!Utils.isEmptyString((String)rootPath)) {
                            String fileExtension = serverFile.getTitle().substring(serverFile.getTitle().lastIndexOf(".") + 1);
                            fileStorage.saveFile(serverFile.getId(), path, fileExtension);
                        } else {
                            fileStorage.saveFile(serverFile.getId(), path, null);
                        }
                        break block13;
                    }
                    catch (Exception e) {
                        fileStorage.deleteFile(serverFile.getId());
                        throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430.\n\u0418\u043b\u0438 \u043f\u0440\u0438\u0448\u043b\u0438 \u0431\u0438\u0442\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u0444\u0430\u0439\u043b\u0430.\n" + e.getMessage());
                    }
                }
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0438\u0441\u0438 \u0432 \u0411\u0414");
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
        return serverFile.getId();
    }

    public void downloadHelpdeskFile(HttpServletRequest request, HttpServletResponse response) throws BGException, BGMessageException {
        int fileId = Utils.parseInt((String)request.getHeader("bgbilling-file-id"));
        int contractId = Utils.parseInt((String)request.getHeader("bgbilling-contract-id"));
        if (fileId <= 0 || contractId <= 0) {
            throw new BGIllegalArgumentException();
        }
        try (Connection connection = this.getConnection();){
            FileStorage fileStorage = this.getFileStorage(connection);
            BGServerFile serverFile = fileStorage.getFileById(fileId);
            if (serverFile == null) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u0438\u0441\u043a\u0430 \u0444\u0430\u0439\u043b\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c (1)");
            }
            TopicManager topicManager = new TopicManager(connection, this.plugin);
            Message message = topicManager.getMessage(serverFile.getOwnerId());
            if (message != null) {
                serverFile.setContractId(topicManager.getTopicOwnerId(message.getTopicId()));
            }
            if (serverFile.getContractId() != contractId) {
                throw new BGException("ID \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0438 OwnerId \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0442! fileId = " + fileId + "; contractId = " + contractId + "; fileContractId = " + serverFile.getContractId());
            }
            try {
                JSONObject jsonObject = new JSONObject();
                BGServerFile.toJSON((BGServerFile)serverFile, (JSONObject)jsonObject);
                response.setContentType("application/octet-stream");
                response.setContentLength((int)serverFile.getSize());
                response.setHeader("Content-Disposition", FileDownload.getContentDisposition((HttpServletRequest)request, (String)serverFile.getTitle(), (boolean)false));
                response.setHeader("bgbilling-file-info", Base64.encodeUTF8((String)jsonObject.toString()));
                ServletOutputStream out = response.getOutputStream();
                fileStorage.loadStream(fileId, (OutputStream)out);
                out.close();
            }
            catch (Exception e) {
                throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u0438\u0441\u043a\u0430 \u0444\u0430\u0439\u043b\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c (2).\n" + e.getLocalizedMessage());
            }
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    public FileStorage getFileStorage(Connection connection) throws BGException {
        return new HelpdeskFileStorage(connection);
    }

    private Connection getConnection() {
        return Setup.getSetup().getDBConnection();
    }
}

