/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstarctDaoConstant;
import ru.bitel.bgbilling.modules.hd.server.bean.CPHost;

public class CPHostManager
extends AbstarctDaoConstant {
    public CPHostManager(Connection con, int moduleId) {
        super(con, "hd_cp_host", moduleId);
    }

    public List<CPHost> getHostList(int contractServiceId) throws SQLException {
        ArrayList<CPHost> result = new ArrayList<CPHost>();
        String query = "SELECT * FROM " + this.tableName + " WHERE cpid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractServiceId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    CPHost host = new CPHost();
                    host.setHost(rs.getString("host"));
                    host.setAddr(rs.getString("addr"));
                    result.add(host);
                }
            }
        }
        return result;
    }

    public void deleteHost(int cpid) throws SQLException {
        String query = "DELETE FROM " + this.tableName + " WHERE cpid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, cpid);
            ps.executeUpdate();
        }
    }

    public void updateHost(int cpid, List<CPHost> hostList) throws SQLException {
        this.deleteHost(cpid);
        String query = "INSERT INTO " + this.tableName + " (cpid, host, addr) VALUES (?, ?, ?)";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, cpid);
            for (CPHost host : hostList) {
                ps.setString(2, host.getHost());
                ps.setString(3, host.getAddr());
                ps.executeUpdate();
            }
        }
    }

    public int checkHost(String packages, int cpid, String host) throws SQLException {
        int result = 0;
        String contractPackageTable = "hd_contract_package_" + this.moduleId;
        String query = "SELECT cp.cid FROM " + this.tableName + " AS host INNER JOIN " + contractPackageTable + " AS cp ON host.cpid=cp.id AND cp.status=? WHERE pid IN ( " + packages + ") AND host.cpid!=? LIMIT 1";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, 1);
            ps.setInt(2, cpid);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = rs.getInt(1);
                }
            }
        }
        return result;
    }
}

