/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.email.server.table;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableColumn;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableRowData;
import ru.bitel.bgbilling.kernel.table.server.bean.BGTableInfoBase;
import ru.bitel.bgbilling.modules.email.common.bean.Domain;
import ru.bitel.bgbilling.modules.email.server.bean.Account;
import ru.bitel.bgbilling.modules.email.server.bean.AccountManager;
import ru.bitel.bgbilling.modules.email.server.bean.DomainManager;
import ru.bitel.bgbilling.modules.email.server.bean.EmailUtils;
import ru.bitel.common.Utils;

public class TableFindEmail
extends BGTableInfoBase {
    public TableFindEmail() {
        this.columns = new BGUTableColumn[]{BGUTableColumn.buildColumnTextLeft((String)"\u0414\u043e\u0433\u043e\u0432\u043e\u0440", (String)"contractTitle"), BGUTableColumn.buildColumnTextLeft((String)"\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", (String)"contractComment").setMaxWidth(-1), BGUTableColumn.buildColumnTextLeft((String)"E-Mail", (String)"email").setMaxWidth(-1), BGUTableColumn.buildColumnTextRight((String)"\u041a\u0432\u043e\u0442\u0430", (String)"quota").setWidth(150), BGUTableColumn.buildColumnTextCenter((String)"\u0421\u0442\u0430\u0442\u0443\u0441", (String)"status").setWidth(150)};
    }

    public List<BGUTableRowData> getRows(BGUTableParams tableParams, int moduleId) throws Exception {
        ServerContext serverContext = (ServerContext)ServerContext.get();
        String mask = tableParams.get("mask", "");
        int domainID = Utils.parseInt((String)tableParams.get("domain", ""));
        if (Utils.notEmptyString((String)mask)) {
            Connection con = serverContext.getConnection();
            DomainManager domainManager = new DomainManager(con, moduleId);
            AccountManager accountManager = new AccountManager(con, moduleId);
            List<Account> accountList = accountManager.findAccounts(mask, domainID);
            Map<Long, String> quotas = EmailUtils.getQuotasMap(moduleId);
            try (ContractDao contractDao = new ContractDao(con, 0);){
                List<BGUTableRowData> list = accountList.stream().map(a -> {
                    Domain domain = null;
                    Contract contract = null;
                    try {
                        domain = domainManager.get(a.getDomainId());
                        contract = (Contract)contractDao.get(a.getContractId());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    String quota = (String)quotas.get(a.getQuota());
                    return new BGUTableRowData().addValue("status", a.getStringStatus()).addValue("email", a.getAccount() + "@" + domain.getName()).addValue("quota", Optional.ofNullable(quota).orElse("??? [#" + a.getQuota() + "]")).addValue("contractId", a.getContractId()).addValue("contractTitle", Optional.ofNullable(contract).map(c -> c.getTitle()).orElse("??? [#" + a.getContractId() + "]")).addValue("contractComment", Optional.ofNullable(contract).map(c -> c.getComment()).orElse("??? [#" + a.getContractId() + "]"));
                }).toList();
                return list;
            }
        }
        return new ArrayList<BGUTableRowData>();
    }
}

