/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.email.client;

import bitel.billing.module.services.ServicePanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.table.client.BGDataSourceTableModel;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableRowData;
import ru.bitel.bgbilling.modules.email.common.service.EmailService;
import ru.bitel.common.client.BGButtonPanelRestoreOkCancelHelp;
import ru.bitel.common.client.BGSwingUtilites;

public class ServicePropertiesPanel
extends ServicePanel {
    private JPopupMenu popupMenu = null;
    private JPanel editorPanel = new JPanel();
    private BGDataSourceTableModel accountTableModel = new BGDataSourceTableModel("Account");
    private BGButtonPanelRestoreOkCancelHelp controlPanel = new BGButtonPanelRestoreOkCancelHelp();

    public ServicePropertiesPanel() {
        this.setTabbedPanel();
        this.jbInit();
    }

    private void jbInit() {
        this.controlPanel.addActionListener(e -> this.actionPerformed(e));
        this.setLayout(this.cardLayout1);
        this.add(this.getTablePanel(), "table");
        this.add(this.editorPanel, "editor");
        this.editorPanel.setLayout(new GridBagLayout());
        this.editorPanel.add((Component)this.editorsTabbedPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.editorPanel.add((Component)this.controlPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 10, 5, 10), 0, 0));
    }

    private JPanel getTablePanel() {
        this.popupMenu = new JPopupMenu();
        BGUTable table = new BGUTable((TableModel)this.accountTableModel);
        table.setSelectionMode(0);
        BGSwingUtilites.handleMouseClicked((Component)table, e -> this.tableMouseClicked(table, (MouseEvent)e));
        this.initTransferContractPopup(this.popupMenu, table, "MoveEmail", "id", "id");
        this.initWrapContractPopup(this.popupMenu, table, "MoveEmail", "id", "id");
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        return panel;
    }

    private void tableMouseClicked(BGUTable table, MouseEvent event) {
        if (SwingUtilities.isRightMouseButton(event) && event.getClickCount() == 1 && Arrays.stream(table.getSelectedRows()).anyMatch(i -> i == table.rowAtPoint(event.getPoint()))) {
            this.popupMenu.show((Component)table, event.getX(), event.getY());
        } else if (event.getClickCount() == 2) {
            this.editItem();
        }
    }

    public void setData() throws Exception {
        if (this.getContractId() > -1 && this.getModuleId() > -1) {
            this.cardLayout1.show((Container)((Object)this), "table");
            BGUTableParams tableParams = new BGUTableParams().setContractId(this.getContractId());
            this.accountTableModel.loadData(this.getContext(), tableParams);
        }
    }

    public void newItem() {
        if (this.editorPanel.isVisible()) {
            this.showMessageDialog();
            return;
        }
        this.initServiceSubPanel(this.editorsTabbedPane, 0);
        this.editorsTabbedPane.setSelectedIndex(0);
        this.cardLayout1.show((Container)((Object)this), "editor");
    }

    public void editItem() {
        BGUTableRowData rowData;
        if (!this.editorPanel.isVisible()) {
            rowData = (BGUTableRowData)this.accountTableModel.getSelectedRow();
            if (rowData == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 E-Mail");
                return;
            }
        } else {
            this.showMessageDialog();
            return;
        }
        this.initServiceSubPanel(this.editorsTabbedPane, rowData.getId());
        this.editorsTabbedPane.setSelectedIndex(0);
        this.cardLayout1.show((Container)((Object)this), "editor");
    }

    public void deleteItem() {
        if (!this.editorPanel.isVisible()) {
            BGUTableRowData rowData = (BGUTableRowData)this.accountTableModel.getSelectedRow();
            if (rowData == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 E-Mail");
                return;
            }
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0430\u043a\u043a\u0430\u0443\u043d\u0442?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                this.tryCall(() -> {
                    ((EmailService)this.getContext().getWebService(EmailService.class)).accountDelete(this.getContractId(), rowData.getId());
                    this.cardLayout1.show((Container)((Object)this), "table");
                    this.trySetData();
                });
            } else {
                this.showMessageDialog();
            }
        }
    }
}

