/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.edo.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.edo.common.bean.ContragentInfos;
import ru.bitel.bgbilling.plugins.edo.common.bean.GetEdoIdSettings;

public class ContractConfigManager {
    private final Connection con;

    public ContractConfigManager(Connection con) {
        this.con = con;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getConfig(int contractId) throws BGException {
        String query = "SELECT `config` FROM `edo_contract_config` WHERE `contract_id`=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                String string2 = rs.getString("config");
                return string2;
            }
            String string = "";
            return string;
        }
        catch (SQLException ex) {
            throw new BGException("error get contract config contractId=" + contractId, (Throwable)ex);
        }
    }

    public void saveConfig(int contractId, String config) throws BGException {
        String query = "INSERT INTO `edo_contract_config` (`contract_id`, `config`) VALUES(?, ?) ON DUPLICATE KEY UPDATE `config`=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.setString(2, config);
            ps.setString(3, config);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new BGException("error save contract config contractId=" + contractId, (Throwable)ex);
        }
    }

    public GetEdoIdSettings getGetEdoIdSettings(int contractId) throws BGException {
        GetEdoIdSettings getEdoIdSettings;
        block11: {
            String query = "SELECT `getid_mode`,`getid_info` FROM `edo_contract_config` WHERE `contract_id`=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            try {
                ps.setInt(1, contractId);
                ResultSet rs = ps.executeQuery();
                GetEdoIdSettings geis = new GetEdoIdSettings();
                if (rs.next()) {
                    int getid_mode = rs.getInt("getid_mode");
                    String getid_info = rs.getString("getid_info");
                    geis.mode = GetEdoIdSettings.GetEdoIdSettingsMode.findByDbcode((int)getid_mode);
                    if (geis.mode == GetEdoIdSettings.GetEdoIdSettingsMode.SPECIFIED) {
                        geis.info = ContragentInfos.fromJson((String)getid_info);
                    }
                } else {
                    geis.mode = GetEdoIdSettings.GetEdoIdSettingsMode.DEFAULT;
                }
                getEdoIdSettings = geis;
                if (ps == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new BGException("error get EdoIdSettings contractId=" + contractId, (Throwable)ex);
                }
            }
            ps.close();
        }
        return getEdoIdSettings;
    }

    public void saveGetEdoIdSettings(int contractId, GetEdoIdSettings settings) throws BGException {
        String query = "INSERT INTO `edo_contract_config` (`contract_id`, `getid_mode`, `getid_info`) VALUES(?, ?, ?) ON DUPLICATE KEY UPDATE `getid_mode`=?, `getid_info`=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int getid_mode = settings.mode.dbcode;
            String getid_info = null;
            if (settings.mode == GetEdoIdSettings.GetEdoIdSettingsMode.SPECIFIED) {
                getid_info = settings.info != null ? settings.info.toJson() : null;
            }
            ps.setInt(1, contractId);
            ps.setInt(2, getid_mode);
            ps.setString(3, getid_info);
            ps.setInt(4, getid_mode);
            ps.setString(5, getid_info);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new BGException("error save EdoIdSettings contractId=" + contractId, (Throwable)ex);
        }
    }
}

