/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.edo.client.documents;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelPluginControls;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.dto.FileDto;
import ru.bitel.bgbilling.kernel.filestorage.common.bean.BGServerFile;
import ru.bitel.bgbilling.plugins.documents.client.contract.DocumentsEditorPanel;
import ru.bitel.bgbilling.plugins.documents.common.bean.Document;
import ru.bitel.bgbilling.plugins.edo.client.SendEdoManualDialog;
import ru.bitel.bgbilling.plugins.edo.common.bean.ContragentInfos;
import ru.bitel.bgbilling.plugins.edo.common.bean.DocInfo;
import ru.bitel.bgbilling.plugins.edo.common.bean.ExtDocument;
import ru.bitel.bgbilling.plugins.edo.common.service.EdoDocumentsService;
import ru.bitel.common.Utils;

public class DocumentsEditorPanelButton
extends BGUPanel
implements BGControlPanelPluginControls.IPluginControls,
SendEdoManualDialog.SendEdoManualDialogContext {
    private DocumentsEditorPanel documentsEditorPanel;
    private SendEdoManualDialog dialog = new SendEdoManualDialog((ClientContext)this.getContext(), this);
    private Document currentDocument = null;
    private int currentContractId = -1;

    public DocumentsEditorPanelButton() {
        super((LayoutManager)new FlowLayout(1, 0, 0), new ClientContext("ru.bitel.bgbilling.plugins.edo", 0, 0, ""));
    }

    public boolean beforeAdd(Component owner, Object ... data) {
        this.documentsEditorPanel = (DocumentsEditorPanel)owner;
        this.add((Component)new BGButton("\u042d\u0414\u041e", "open_dialog", e -> this.dialog.setVisible(true)));
        return true;
    }

    public void doSetData(Component owner, Object ... data) {
        String code;
        if (data.length < 1) {
            return;
        }
        switch (code = (String)data[0]) {
            case "editDocument": {
                this._editDocument((Document)data[1]);
                return;
            }
            case "setContractId": {
                this._setContractId((Integer)data[1]);
                return;
            }
        }
    }

    private void _editDocument(Document doc) {
        if (doc == null || this.currentDocument == null) {
            this.dialog.setContragentInfos(null);
            this.currentDocument = doc;
            return;
        }
        if (doc.getId() != this.currentDocument.getId()) {
            this.dialog.setContragentInfos(null);
            this.currentDocument = doc;
            return;
        }
    }

    private void _setContractId(int contractId) {
        if (contractId != this.currentContractId) {
            this.dialog.setContragentInfos(null);
            this.currentContractId = contractId;
            return;
        }
    }

    public boolean beforeAction(Component owner, Object ... data) {
        return true;
    }

    public void doAction(Component owner, Object ... data) {
    }

    protected void jbInit() throws Exception {
    }

    @Override
    public int getContractId() {
        return this.documentsEditorPanel.getCurrentContractId();
    }

    @Override
    public FileDto callSaveEdo(int documentTypeId, int signatoryId, ContragentInfos contragentInfos) throws BGMessageException {
        throw new BGMessageException("\u0412 \u0434\u0430\u043d\u043d\u044b\u0439 \u043c\u043e\u043c\u0435\u043d\u0442 \u043d\u0435 \u0440\u0435\u0430\u043b\u0438\u0437\u043e\u0432\u0430\u043d\u043e \u0434\u043b\u044f \u043d\u0435\u0444\u043e\u0440\u043c\u0430\u043b\u0438\u0437\u043e\u0432\u0430\u043d\u043d\u044b\u0445 \u0444\u0430\u0439\u043b\u043e\u0432");
    }

    @Override
    public boolean confirmSendEdo(ContragentInfos contragentInfos) {
        Document currentDocument = this.currentDocument;
        List files = this.documentsEditorPanel.getCurrentSelectedFiles();
        if (Utils.isEmptyCollection((Collection)files)) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u043e\u043d\u043a\u0440\u0435\u0442\u043d\u044b\u0439 \u0444\u0430\u0439\u043b");
            return false;
        }
        if (files.size() != 1) {
            ClientUtils.showErrorMessageDialog((String)"\u0424\u0430\u0439\u043b \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043e\u0434\u0438\u043d");
            return false;
        }
        BGServerFile file = (BGServerFile)files.get(0);
        return ClientUtils.confirm((String)("\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0444\u0430\u0439\u043b \"" + file.getTitle() + "\" \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \"" + currentDocument.getGuiTitle() + "\" \u0432 \u042d\u0414\u041e (" + contragentInfos.title + ")?"), (String)"\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u0432 \u042d\u0414\u041e");
    }

    @Override
    public ExtDocument callSendEdo(int documentTypeId, int signatoryId, ContragentInfos contragentInfos) throws BGException {
        DocInfo docInfo = null;
        Document currentDocument = this.currentDocument;
        List files = this.documentsEditorPanel.getCurrentSelectedFiles();
        ArrayList filesIds = new ArrayList();
        files.forEach(file -> filesIds.add(file.getId()));
        ExtDocument document = ((EdoDocumentsService)((ClientContext)this.getContext()).getPort(EdoDocumentsService.class)).sendEdo(documentTypeId, signatoryId, contragentInfos, docInfo, currentDocument.getId(), filesIds);
        return document;
    }
}

