/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.documents.client.directory;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.plugins.documents.client.directory.DirectoryTableModel;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentStatus;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.model.Id;

public class StatusEditor
extends BGUPanel {
    private BGUTable statusTable;
    private StatusTableModel statusTableModel = new StatusTableModel();

    protected void jbInit() throws Exception {
        this.statusTable = new BGUTable((TableModel)((Object)this.statusTableModel));
        this.statusTable.setSelectionMode(0);
        this.statusTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    StatusEditor.this.performAction("delete");
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)this.statusTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> this.statusTableModel.setData(((ClientContext)this.getContext()).getDirectory(DocumentStatus.class).list()));
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            List list = this.statusTableModel.getRows();
            if (list.size() == 0 || ((DocumentStatus)list.get(list.size() - 1)).getId() > 0) {
                this.statusTableModel.addRow(new DocumentStatus());
                this.statusTable.repaint();
                this.statusTable.updateUI();
            }
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            DocumentStatus selectedRow = (DocumentStatus)this.statusTableModel.getSelectedRow();
            if (selectedRow.getId() > 0) {
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u0443\u044e \u0441\u0442\u0440\u043e\u043a\u0443?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0441\u0442\u0440\u043e\u043a\u0438", 0) == 0) {
                    ((ClientContext)this.getContext()).getDirectory(DocumentStatus.class).delete(selectedRow.getId());
                }
            } else if (selectedRow.getId() == 0) {
                this.statusTableModel.deleteSelectedRows();
            } else {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435!");
                return;
            }
            this.performAction("refresh");
        });
    }

    class StatusTableModel
    extends DirectoryTableModel<DocumentStatus> {
        public StatusTableModel() {
            super(StatusEditor.class.getName());
        }

        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            DocumentStatus val = (DocumentStatus)this.getSelectedRow();
            String oldValue = val.getTitle();
            String newValue = (String)value;
            if (Utils.notBlankString((String)newValue)) {
                if (oldValue != null && oldValue.equals(newValue)) {
                    return;
                }
                val.setTitle(newValue);
                try {
                    ((ClientContext)StatusEditor.this.getContext()).getDirectory(DocumentStatus.class).update((Id)val);
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
            StatusEditor.this.performAction("refresh");
        }
    }
}

