/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.client.condition;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.math.BigDecimal;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.plugins.dispatch.client.condition.base.DummyDispatchConditionPanel;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.condition.DispatchBalanceCondition;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.condition.base.DispatchCondition;
import ru.bitel.common.Utils;

public class DispatchBalanceConditionPanel
extends DummyDispatchConditionPanel {
    private BGTextField fromBalance = new BGTextField();
    private BGTextField toBalance = new BGTextField();
    private BGTextField freqCount = new BGTextField(5);
    private JCheckBox limit = new JCheckBox("\u0441 \u0443\u0447\u0435\u0442\u043e\u043c \u043b\u0438\u043c\u0438\u0442\u0430");
    private JCheckBox freq = new JCheckBox("\u043d\u0435 \u0431\u043e\u043b\u0435\u0435 ");

    public DispatchBalanceConditionPanel(ClientContext context) {
        super(context);
    }

    @Override
    protected void jbInit() {
        super.jbInit();
        this.mainPanel.add((Component)this.getRangePanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.getOptionsPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
    }

    private JPanel getRangePanel() {
        this.fromBalance.setHorizontalAlignment(0);
        this.toBalance.setHorizontalAlignment(0);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041e\u0442:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)this.fromBalance, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)new JLabel("\u0434\u043e:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)this.toBalance, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        return panel;
    }

    private JPanel getOptionsPanel() {
        this.freqCount.setHorizontalAlignment(0);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.limit, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)this.freq, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 25, 0, 0), 0, 0));
        panel.add((Component)this.freqCount, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel(" \u0440\u0430\u0437(\u0430) \u043f\u043e\u0434\u0440\u044f\u0434"), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    @Override
    protected void fillFromCondition(DispatchCondition condition) {
        DispatchBalanceCondition balanceCondition = (DispatchBalanceCondition)condition;
        this.fromBalance.setText(balanceCondition.getLeft() == null ? "" : Utils.formatBigDecimalSumm((BigDecimal)balanceCondition.getLeft()));
        this.toBalance.setText(balanceCondition.getRight() == null ? "" : Utils.formatBigDecimalSumm((BigDecimal)balanceCondition.getRight()));
        this.limit.setSelected(balanceCondition.isLimit());
        this.freq.setSelected(balanceCondition.isFreq());
        this.freqCount.setText(String.valueOf(balanceCondition.getFreqCount()));
    }

    @Override
    protected DispatchCondition readConditionFromPanel() {
        DispatchBalanceCondition balanceCondition = new DispatchBalanceCondition();
        balanceCondition.setLeft(Utils.parseBigDecimal((String)this.fromBalance.getText(), null));
        balanceCondition.setRight(Utils.parseBigDecimal((String)this.toBalance.getText(), null));
        balanceCondition.setLimit(this.limit.isSelected());
        balanceCondition.setFreq(this.freq.isSelected());
        balanceCondition.setFreqCount(Utils.parseInt((String)this.freqCount.getText(), (int)1));
        return balanceCondition;
    }

    @Override
    public void clearFields() {
        super.clearFields();
        this.fromBalance.setText("");
        this.toBalance.setText("");
        this.freqCount.setText("");
        this.limit.setSelected(false);
        this.freq.setSelected(false);
    }

    @Override
    protected String getTitle() {
        return "\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u043f\u043e \u0431\u0430\u043b\u0430\u043d\u0441\u0443";
    }

    @Override
    public String validateCondition() {
        String result = "";
        BigDecimal from = Utils.parseBigDecimal((String)this.fromBalance.getText(), null);
        BigDecimal to = Utils.parseBigDecimal((String)this.toBalance.getText(), null);
        int freqCountValue = Utils.parseInt((String)this.freqCount.getText(), (int)-1);
        if (from == null && to == null) {
            result = "\u041d\u0435 \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430!";
        } else if (from != null && to != null && from.compareTo(to) > 0) {
            result = "\u0421\u0443\u043c\u043c\u0430 \u041e\u0422 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 \u0438\u043b\u0438 \u0440\u0430\u0432\u043d\u0430 \u0441\u0443\u043c\u043c\u0435 \u0414\u041e!";
        } else if (this.freq.isSelected() && freqCountValue < 0) {
            result = "\u041d\u0435 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u041a\u041e\u041b\u0418\u0427\u0415\u0421\u0422\u0412\u041e \u0440\u0430\u0437";
        }
        return result;
    }
}

