/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.crm.server;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.MenuItem;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.kernel.plugin.server.inpoint.OnDestroyServer;
import ru.bitel.bgbilling.kernel.plugin.server.inpoint.OnInitServer;
import ru.bitel.bgbilling.kernel.plugin.server.inpoint.SerializeContract;
import ru.bitel.bgbilling.plugins.crm.server.dao.RegisterCallManager;
import ru.bitel.bgbilling.plugins.crm.server.dao.RegisterTaskManager;
import ru.bitel.bgbilling.server.WebMenu;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class PluginServerListener
extends BGLogger
implements SerializeContract,
OnInitServer,
OnDestroyServer,
EventListener<ContractDeleteEvent>,
WebMenu {
    public void onInitServer(String applicationName) {
        if (!"server".equals(applicationName)) {
            return;
        }
        try {
            EventProcessor.getInstance().addListener((EventListener)this, ContractDeleteEvent.class, 0, null);
        }
        catch (BGException e) {
            this.getLogger().error("error add event listener", (Throwable)e);
        }
    }

    public void onDestroyServer(String applicationName) {
        if (!"server".equals(applicationName)) {
            return;
        }
        try {
            EventProcessor.getInstance().removeListener((EventListener)this);
        }
        catch (BGException e) {
            this.getLogger().error("error remove event listener", (Throwable)e);
        }
    }

    public void notify(ContractDeleteEvent event, EventListenerContext ctx) throws Exception {
        ContractDeleteEvent cdEvent;
        if (event instanceof ContractDeleteEvent && !(cdEvent = event).isCheck()) {
            Connection con = ctx.getConnection();
            int contractId = cdEvent.getContractId();
            new RegisterTaskManager(con).deleteTasksByContractId(contractId);
            new RegisterCallManager(con).deleteCallsByContractId(contractId);
        }
    }

    public void serializeContract(Connection con, int cid, XMLStreamWriter writer, boolean onlyCurrent) throws SQLException, XMLStreamException {
        String cidStr = String.valueOf(cid);
        ServerUtils.addItemsFromRS((Connection)con, (XMLStreamWriter)writer, (String)"register_task", (String)"cid", (String)cidStr, null, (boolean)false, null, null);
        ServerUtils.addItemsFromRS((Connection)con, (XMLStreamWriter)writer, (String)"register_call", (String)"cid", (String)cidStr, null, (boolean)false, null, null);
    }

    public List<MenuItem> getWebMenuItems(Connection con, String module, int moduleId) throws BGException {
        return null;
    }

    public List<MenuItem> getContractWebMenuItems(Connection con, String module, int moduleId, int contractId) throws BGException {
        return null;
    }
}

