/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.client.tariff;

import bitel.billing.module.common.BGComboBoxFixed;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGControlPanelListSelect;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.kernel.directory.tariff.common.Directory;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class PacketSetFilterTariffTreeNode
extends DefaultTariffTreeNode {
    private static final Icon icon = ClientUtils.getIcon((String)"filter.gif");
    private JLabel view;
    private Directory packetDir;
    private List<Integer> values = new ArrayList<Integer>();
    private int andornotModeValue = 1;
    private boolean on_contract_total;
    private JPanel editor;
    private BGControlPanelListSelect packets;
    private BGComboBoxFixed andornotMode;
    private JCheckBox onContractTotal;
    private String COND_AND_1 = "AND \u041f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u0441\u0440\u0430\u0437\u0443 \u0432\u0441\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0435 \u043f\u0430\u043a\u0435\u0442\u044b";
    private String COND_OR_2 = "OR \u041f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0445\u043e\u0442\u044f \u0431\u044b \u043e\u0434\u0438\u043d \u0438\u0437 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0445 \u043f\u0430\u043a\u0435\u0442\u043e\u0432";
    private String COND_NOTAND_3 = "NOT-AND (ELSE \u043a AND) \u041d\u0435 \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0445\u043e\u0442\u044f \u0431\u044b \u043e\u0434\u0438\u043d \u0438\u0437 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0445 \u043f\u0430\u043a\u0435\u0442\u043e\u0432";
    private String COND_NOTOR_4 = "NOT-OR (ELSE \u043a OR) \u041d\u0435 \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u0441\u0440\u0430\u0437\u0443 \u0432\u0441\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0435 \u043f\u0430\u043a\u0435\u0442\u044b";

    public void init(int id, int mtree, String type, TariffTree tree, ModuleTariffConfig config, TariffTreeNode parent, Map<Integer, List<Element>> childsArray) {
        super.init(id, mtree, type, tree, config, parent, childsArray);
        this.packetDir = this.getDirManager().getDirectory("packets");
    }

    protected JPanel getEditorPanel() {
        return new JPanel();
    }

    public Component getEditor() throws Exception {
        if (this.editor == null) {
            BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
            okCancel.addActionListener(e -> {
                if (e.getActionCommand().equals("ok")) {
                    this.serializeData();
                    this.saveData();
                }
                this.tree.getViewableTree().stopEditing();
            });
            this.packets = new BGControlPanelListSelect();
            this.andornotMode = new BGComboBoxFixed();
            this.onContractTotal = new JCheckBox("\u041d\u0430 \u0432\u0441\u0451\u043c \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435");
            this.packets.getList().setData(this.packetDir.getItems().stream().map(a -> new BGUListItem(a)).toList());
            this.andornotMode.addItem((Object)1, this.COND_AND_1);
            this.andornotMode.addItem((Object)2, this.COND_OR_2);
            this.andornotMode.addItem((Object)3, this.COND_NOTAND_3);
            this.andornotMode.addItem((Object)4, this.COND_NOTOR_4);
            this.editor = new JPanel(new GridBagLayout());
            this.editor.setMinimumSize(new Dimension(500, 300));
            this.editor.setPreferredSize(new Dimension(500, 300));
            this.editor.add((Component)this.andornotMode, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
            this.editor.add((Component)this.packets, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
            this.editor.add((Component)this.onContractTotal, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.editor.add((Component)okCancel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        }
        return this.editor;
    }

    protected void loadData() throws Exception {
        this._extractData();
        this.getEditor();
        this.packets.setListValues(Utils.toString(this.values));
        this.andornotMode.setSelectedId((Object)this.andornotModeValue);
        this.onContractTotal.setSelected(this.on_contract_total);
    }

    protected void serializeData() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("packets", this.packets.getListValues());
        data.put("andornot_mode", String.valueOf(this.andornotMode.getSelectedIdObj()));
        data.put("on_contract_total", String.valueOf(this.onContractTotal.isSelected()));
        this.setDataInHash(data);
    }

    public Component getView() throws Exception {
        if (this.view == null) {
            this.view = new JLabel();
            this.view.setIcon(icon);
        }
        this._extractData();
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        switch (this.andornotModeValue) {
            case 1: {
                sb.append(this.COND_AND_1);
                break;
            }
            case 2: {
                sb.append(this.COND_OR_2);
                break;
            }
            case 3: {
                sb.append(this.COND_NOTAND_3);
                break;
            }
            case 4: {
                sb.append(this.COND_NOTOR_4);
                break;
            }
            default: {
                sb.append("?");
            }
        }
        sb.append(this.on_contract_total ? " [\u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435]" : " [\u043d\u0430 \u043a\u0430\u0440\u0442\u0435]");
        for (Integer code : this.values) {
            String packetTitle = this.packetDir.getValue(code.intValue());
            if (packetTitle == null) continue;
            sb.append("<br>");
            sb.append(packetTitle);
        }
        this.view.setText(sb.toString());
        return this.view;
    }

    private void _extractData() {
        Map data = this.getDataInHash();
        this.values.clear();
        this.values.addAll(Utils.toIntegerList((String)((String)data.get("packets"))));
        this.andornotModeValue = Utils.parseInt((String)((String)data.get("andornot_mode")), (int)1);
        this.on_contract_total = Utils.parseBoolean((String)((String)data.get("on_contract_total")));
    }
}

