/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.cashcheck.server.fisc;

import org.json.JSONObject;
import org.json.JSONTokener;
import ru.bitel.bgbilling.plugins.cashcheck.server.fisc.CheckFiscalData;

public class CheckPrintResult {
    public String change;
    public String checkId;
    public String data;

    private CheckPrintResult(String change, String checkId, String data) {
        this.change = change;
        this.checkId = checkId;
        this.data = data;
    }

    public static CheckPrintResult sync(String change, CheckFiscalData data) {
        return new CheckPrintResult(change, null, data != null ? data.toJson() : null);
    }

    public static CheckPrintResult async(String checkId) {
        return new CheckPrintResult(null, checkId, null);
    }

    public String toJson() {
        JSONObject jsonObject = new JSONObject();
        if (this.change != null) {
            jsonObject.put("change", (Object)this.change);
        }
        if (this.checkId != null) {
            jsonObject.put("checkId", (Object)this.checkId);
        }
        if (this.data != null) {
            jsonObject.put("data", (Object)this.data);
        }
        return jsonObject.toString(0);
    }

    public static CheckPrintResult parseJson(String json) {
        try {
            JSONTokener tokener = new JSONTokener(json);
            JSONObject object = (JSONObject)tokener.nextValue();
            String change = object.optString("change");
            String checkId = object.optString("checkId");
            String data = object.optString("data");
            return new CheckPrintResult(change, checkId, data);
        }
        catch (Exception e) {
            return new CheckPrintResult("\u043e\u0448\u0438\u0431\u043a\u0430 json " + e.toString(), null, json);
        }
    }
}

