/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.cashcheck.frk.utils;

import java.util.Map;
import ru.bitel.common.Utils;

public class WaitTimeout {
    private static long commandPrintTimeout;
    private static long lastTimestamp;

    public static void init(Map<String, String> driverConfig) {
        commandPrintTimeout = Utils.parseLong((String)driverConfig.get("commandPrintTimeout"), (long)-1L);
        commandPrintTimeout = commandPrintTimeout > 0L ? commandPrintTimeout * 1000000L : -1L;
    }

    public static void reset() {
        if (commandPrintTimeout <= 0L) {
            return;
        }
        lastTimestamp = System.nanoTime();
    }

    public static void timeout() {
        if (commandPrintTimeout <= 0L) {
            return;
        }
        long toWait = lastTimestamp + commandPrintTimeout - System.nanoTime();
        if (toWait > 0L) {
            try {
                Thread.sleep(toWait);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        lastTimestamp = System.nanoTime();
    }
}

