/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.client;

import bitel.billing.module.services.ServiceConfig;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelDateNoB;
import ru.bitel.bgbilling.client.common.BGControlPanelListSelect;
import ru.bitel.bgbilling.client.common.BGControlPanelMonth;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.contract.label.client.ContractLabelTree;
import ru.bitel.bgbilling.kernel.contract.label.common.service.ContractLabelService;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.modules.bill.client.ActionServiceConfig;
import ru.bitel.bgbilling.modules.bill.client.BillServiceConfigTabbedPanel;
import ru.bitel.bgbilling.modules.bill.client.ServiceConfigBillGenerate;
import ru.bitel.bgbilling.modules.bill.common.bean.BillListFilter;
import ru.bitel.bgbilling.modules.bill.common.bean.enums.DocumentType;
import ru.bitel.bgbilling.modules.bill.common.service.BillService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;

public class ServiceConfigInvoiceManager
extends BillServiceConfigTabbedPanel {
    private JPanel extParamPanel = null;
    private Directory<UserInfo> userDirectory;
    private BGButton filterSet = new BGButton();
    private JRadioButton andRB = new JRadioButton("\u0418");
    private JRadioButton orRB = new JRadioButton("\u0418\u041b\u0418");
    private BGTextField contract = new BGTextField(10);
    private BGTextField billNumber = new BGTextField(10);
    private BGControlPanelMonth month = new BGControlPanelMonth();
    private BGControlPanelDateNoB fromDate = new BGControlPanelDateNoB();
    private BGControlPanelDateNoB untilDate = new BGControlPanelDateNoB();
    private BGControlPanelListSelect typeCb = new BGControlPanelListSelect(5);
    private ContractLabelTree contractLabelTree = new ContractLabelTree();

    public ServiceConfigInvoiceManager() {
        super("invoice");
        this.rb_name = ClientUtils.getRBName(ActionServiceConfig.class);
        this.getModuleDoc(ActionServiceConfig.class);
        this.tableModel = new InvoiceTableModel("InvoiceManager");
        this.initCardPanel();
    }

    @Override
    protected void addPopupItems(JPopupMenu popupMenu) {
        popupMenu.add("\u0421\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0435\u0449\u0435 \u0441 \u0434\u0430\u043d\u043d\u044b\u043c\u0438 \u043f\u043e\u0437\u0438\u0446\u0438\u044f\u043c\u0438").addActionListener(e -> {
            List rows = this.tableModel.getSelectedRows();
            if (rows.size() != 1) {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u0430 \u0441\u0447\u0435\u0442-\u0444\u0430\u043a\u0442\u0443\u0440\u0430, \u0430\u043a\u0442, \u0423\u041f\u0414");
                return;
            }
            this.tryCall(() -> {
                int cid = Utils.parseInt((String)((Element)rows.get(0)).getAttribute("cid"), (int)-1);
                int invoiceId = Utils.parseInt((String)((Element)rows.get(0)).getAttribute("id"), (int)-1);
                int invoiceDocTypeId = Utils.parseInt((String)((Element)rows.get(0)).getAttribute("type"), (int)-1);
                if (invoiceId > 0 && cid > 0 && invoiceDocTypeId > 0) {
                    String className = ServiceConfigBillGenerate.class.getName();
                    ServiceConfig serviceConfig = (ServiceConfig)this.getParent().getParent().getParent();
                    ServiceConfigBillGenerate billGenerate = (ServiceConfigBillGenerate)serviceConfig.getTab(className);
                    billGenerate.getTemplateBillList(false, "" + cid, "invoice", invoiceId, "" + invoiceDocTypeId, "invoice");
                    serviceConfig.selectTab(className);
                }
            });
        });
        popupMenu.addSeparator();
        popupMenu.add("\u0420\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043e \u043a \u043f\u043e\u043a\u0430\u0437\u0443").addActionListener(e -> this.setShowReady(true));
        popupMenu.add("\u0417\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u043a \u043f\u043e\u043a\u0430\u0437\u0443").addActionListener(e -> this.setShowReady(false));
    }

    @Override
    protected JPanel getPanel() {
        BGUTable table = new BGUTable((TableModel)this.tableModel);
        this.initTable("invoice", table);
        this.filterSet.setText("\u041f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c");
        this.filterSet.setActionCommand("go");
        this.filterSet.addActionListener(e -> this.actionMapper(e));
        this.orRB.setSelected(true);
        this.month.setBorder(null);
        JPanel groupModePanel = new JPanel();
        groupModePanel.add(new JLabel("\u0420\u0435\u0436\u0438\u043c"));
        groupModePanel.add(this.andRB);
        groupModePanel.add(this.orRB);
        ButtonGroup buttonGroup3 = new ButtonGroup();
        buttonGroup3.add(this.andRB);
        buttonGroup3.add(this.orRB);
        JPanel groupsPanel = new JPanel(new GridBagLayout());
        groupsPanel.setPreferredSize(new Dimension(220, 335));
        groupsPanel.setMinimumSize(new Dimension(220, 335));
        groupsPanel.add((Component)groupModePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        groupsPanel.add((Component)new JScrollPane((Component)this.contractLabelTree), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JTabbedPane filtersPanel = new JTabbedPane();
        filtersPanel.addTab("\u041c\u0435\u0442\u043a\u0438 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432", groupsPanel);
        filtersPanel.addTab("\u0422\u0438\u043f\u044b", (Component)this.typeCb);
        JPanel dateButtonPanel = new JPanel(new GridBagLayout());
        dateButtonPanel.add((Component)new JLabel("\u0441"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 6, 0, 0), 0, 0));
        dateButtonPanel.add((Component)this.fromDate, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 15, 0, new Insets(0, 6, 0, 0), 0, 0));
        dateButtonPanel.add((Component)new JLabel("\u043f\u043e"), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 6, 0, 0), 0, 0));
        dateButtonPanel.add((Component)this.untilDate, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 15, 0, new Insets(0, 6, 0, 0), 0, 0));
        this.extParamPanel = new JPanel(new GridBagLayout());
        this.extParamPanel.add((Component)new JLabel("\u041f\u0430\u0447\u043a\u0430:"), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.extParamPanel.add((Component)this.packageCb, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.extParamPanel.add((Component)new JLabel("\u0414\u0430\u0442\u0430 \u0432\u044b\u043f\u0438\u0441\u043a\u0438:"), new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 3, 0, 0), 0, 0));
        this.extParamPanel.add((Component)dateButtonPanel, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.extParamPanel.add((Component)new JLabel("\u0421\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430 1:"), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.extParamPanel.add((Component)this.sortModeCb, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.extParamPanel.add((Component)new JLabel("\u0421\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430 2:"), new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.extParamPanel.add((Component)this.secondarySortModeCb, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.extParamPanel.add((Component)filtersPanel, new GridBagConstraints(0, 6, 2, 1, 0.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.extParamPanel.setVisible(false);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 2, 0, 2), 0, 0));
        panel.add((Component)this.positionsEditor.getPositionsPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 13, 1, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.countLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        JPanel billPanel = new JPanel(new GridBagLayout());
        billPanel.setLayout(new GridBagLayout());
        billPanel.add((Component)this.getTopPanel(), new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        billPanel.add((Component)panel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        billPanel.add((Component)this.extParamPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 17, 1, new Insets(0, 0, 5, 0), 0, 0));
        return billPanel;
    }

    @Override
    protected JPanel getFilterPanel() {
        JToggleButton extParamButton = new JToggleButton("\u0415\u0449\u0435...");
        extParamButton.addActionListener(e -> this.extParamPanel.setVisible(((JToggleButton)e.getSource()).isSelected()));
        int insetLeft = 15;
        JPanel topPanel = new JPanel(new GridBagLayout());
        topPanel.setBorder(BorderFactory.createCompoundBorder((Border)new BGTitleBorder(" \u0424\u0438\u043b\u044c\u0442\u0440 "), BorderFactory.createEmptyBorder(0, 0, 5, 0)));
        topPanel.add((Component)new JLabel("\u041d\u043e\u043c\u0435\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 0, 0), 0, 0));
        topPanel.add((Component)this.contract, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 5, 0, 0), 0, 0));
        topPanel.add((Component)new JLabel("\u041d\u043e\u043c\u0435\u0440 \u0441\u0447\u0435\u0442\u0430:"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, insetLeft, 0, 0), 0, 0));
        topPanel.add((Component)this.billNumber, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, insetLeft, 0, 0), 0, 0));
        topPanel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434:"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, insetLeft, 0, 0), 0, 0));
        topPanel.add((Component)this.month, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, insetLeft, 0, 0), 0, 0));
        topPanel.add((Component)extParamButton, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, insetLeft, 0, 0), 0, 0));
        topPanel.add((Component)this.filterSet, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, insetLeft, 0, 0), 0, 0));
        topPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(5, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        return topPanel;
    }

    public void actionMapper(String action) {
        if (action.equals("go")) {
            this.getBillList();
        }
    }

    private void actionMapper(ActionEvent e) {
        String command = e.getActionCommand();
        this.actionMapper(command);
    }

    public void setData() {
        if (!this.init) {
            this.init();
            this.init = true;
        }
        this.getBillList();
    }

    private void init() {
        this.tryCall(() -> {
            this.userDirectory = this.getContext().getDirectory(UserInfo.class, 0);
            this.contractLabelTree.setData(((ContractLabelService)this.getContext().getPort(ContractLabelService.class, 0)).getContractLabelTreeItemList(-1, false));
            List docTypes = ((BillService)this.getContext().getPort(BillService.class, this.getModuleId())).docTypeList(DocumentType.INVOICE);
            this.typeCb.getList().setData(docTypes.stream().map(a -> new BGUListItem((IdTitle)a)).toList());
            this.prepareFilters();
        });
    }

    @Override
    protected Request getRequest() {
        this.typeBill = "invoice";
        return new Request().setModule(this.module).setAction("Invoice").setModuleId(this.getModuleId()).setAttribute("gr", Utils.toString((Iterable)this.contractLabelTree.getSelectedIds())).setAttribute("from", this.fromDate.getDateString()).setAttribute("until", this.untilDate.getDateString()).setAttribute("y", String.valueOf(this.month.getLocalDate().getYear())).setAttribute("m", String.valueOf(this.month.getLocalDate().getMonthValue() - 1)).setAttribute("contract", this.contract.getText()).setAttribute("billNumber", this.billNumber.getText()).setAttribute("package", ((IdTitle)this.packageCb.getSelectedItem()).getId()).setAttribute("sort_mode", ((IdTitle)this.sortModeCb.getSelectedItem()).getId()).setAttribute("secondary_sort_mode", ((IdTitle)this.secondarySortModeCb.getSelectedItem()).getId()).setAttribute("type", this.typeCb.getListValues()).setAttribute("countOfBill", this.tableModel.getRowCount()).setAttribute("gr_mode", this.orRB.isSelected() ? "or" : null).setAttribute("gr_mode", this.andRB.isSelected() ? "and" : null).setPageSize(0);
    }

    @Override
    protected BillListFilter getBillListFilter() {
        return new BillListFilter().setContractLabelIds(this.contractLabelTree.getSelectedIds()).setContractLabelMode(this.orRB.isSelected() ? "or" : "and").setPeriod(new Period(this.fromDate.getLocalDate(), this.untilDate.getLocalDate())).setYear(this.month.getLocalDate().getYear()).setMonth(this.month.getLocalDate().getMonthValue() - 1).setContractTitle(this.contract.getText()).setBillNumber(this.billNumber.getText()).setPackageId(((IdTitle)this.packageCb.getSelectedItem()).getId()).setPrimarySortMode(((IdTitle)this.sortModeCb.getSelectedItem()).getId()).setSecondarySortMode(((IdTitle)this.secondarySortModeCb.getSelectedItem()).getId()).setTypeIds(Utils.toIntegerList((String)this.typeCb.getListValues())).setCountOfBill(this.tableModel.getRowCount()).setPage(new Page().setPageSize(0));
    }

    public void getBillList() {
        Request request = this.getRequest();
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            try {
                Element tableEl = XMLUtils.getElement((Document)doc, (String)"table");
                ArrayList<Element> rows = new ArrayList<Element>();
                for (Element rowElement : XMLUtils.selectElements((Node)tableEl, (String)"data/row")) {
                    rows.add(rowElement);
                }
                this.tableModel.setData(rows);
                this.updateCountLabel(tableEl.getAttribute("number"), tableEl.getAttribute("summ"));
                Element sepEl = XMLUtils.selectElement((Node)doc, (String)"/data/separator");
                if (sepEl != null) {
                    this.separator = XMLUtils.getAttribute((Element)sepEl, (String)"separator", (String)",");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (ClientUtils.checkStatus((Document)(doc = this.getDocument(request = new Request().setModule(this.module).setModuleId(this.getModuleId()).setAction("InvoicePositionList").setAttribute("parsed", "1").setAttribute("mm", String.valueOf(this.month.getLocalDate().getMonthValue() - 1)).setAttribute("month", TimeUtils.format((LocalDate)this.month.getLocalDate(), (String)"dd.MM.yyyy")))))) {
            this.positionsEditor.setPositionList(XMLUtils.getNode((Document)doc, (String)"positions"));
        }
        this.currentId = null;
        this.positionsEditor.showPositions(null);
    }

    public void deleteItem() {
        List rows = this.tableModel.getSelectedRows();
        if (rows.isEmpty()) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443!");
            return;
        }
        if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0441\u0447\u0435\u0442\u0430-\u0444\u0430\u043a\u0442\u0443\u0440\u044b, \u0430\u043a\u0442\u044b, \u0423\u041f\u0414?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            ArrayList<Integer> invoiceIds = new ArrayList<Integer>();
            for (Element rowElement : rows) {
                invoiceIds.add(Utils.parseInt((String)rowElement.getAttribute("id")));
            }
            this.tryCall(() -> {
                ((BillService)this.getContext().getWebService(BillService.class)).invoiceDelete(invoiceIds);
                this.setData();
            });
        }
    }

    private void setShowReady(boolean ready) {
        String ids = this.getSelectedIds();
        if (Utils.isBlankString((String)ids)) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0438");
        } else {
            Request request = new Request().setModule(this.module).setModuleId(this.getModuleId()).setAction("SetShowReady").setAttribute("ids", ids).setAttribute("ready", ready ? "1" : "0");
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                this.setData();
            }
        }
    }

    class InvoiceTableModel
    extends BGTableModel<Element> {
        public InvoiceTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("cid", 0, 0, 0, "cid", false, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
            this.addColumn("type", 0, 0, 0, "type", false, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u041d\u043e\u043c\u0435\u0440", 120, 120, 120, "number", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0414\u0430\u0442\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f", Date.class, 120, 120, 120, "create_dt", true, (TableCellRenderer)new DatetimeTableCellRenderer("dd.MM.yyyy", 0));
            this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 [\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439]", 100, -1, -1, "contract_and_comment", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0422\u0438\u043f", 100, 250, 300, "type_title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0421\u043e\u0437\u0434\u0430\u043b", 100, 250, 300, "userId", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0420\u0430\u0437\u0440\u0435\u0448\u0435\u043d", Boolean.class, 80, 80, 80, "show_ready", true);
            this.addColumn("\u0421\u0443\u043c\u043c\u0430", BigDecimal.class, 100, 100, 100, "summ", true, (TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
        }

        public Object getValue(Element val, int column) throws Exception {
            String identifier;
            switch (identifier = this.getIdentifier(column)) {
                case "show_ready": {
                    return Boolean.valueOf(val.getAttribute(identifier));
                }
                case "create_dt": {
                    return TimeUtils.parseDate((String)val.getAttribute(identifier), (String)"dd.MM.yyyy");
                }
                case "summ": {
                    return new BigDecimal(val.getAttribute(identifier));
                }
                case "userId": {
                    UserInfo userInfo = (UserInfo)ServiceConfigInvoiceManager.this.userDirectory.get(Utils.parseInt((String)val.getAttribute(identifier), (int)-5));
                    return userInfo == null ? "<\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>" : userInfo.getName();
                }
            }
            return super.getValue((Object)val, column);
        }
    }
}

