/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.voice.accounting.mediation.proccess;

import java.util.Iterator;
import java.util.concurrent.Callable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.proccess.ErrorTask;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.proccess.LogRecordProcessor;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.proccess.TarifficationTask;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.proccess.VoiceHourSessionProcessor;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceError;
import ru.bitel.bgbilling.modules.voice.common.bean.enums.AccessCode;
import ru.bitel.bgbilling.modules.voice.server.event.LogProcessInterrupted;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceSessionRuntime;
import ru.bitel.bgbilling.modules.voice.server.tariff.VoiceTariffContext;
import ru.bitel.bgbilling.modules.voice.server.tariff.VoiceTariffWorkerContext;

public class VoiceRecordTarifficator
implements Callable<Object> {
    private static final Logger logger = LogManager.getLogger();
    private final int index;
    private final VoiceHourSessionProcessor sessionProcessor;
    private final VoiceTariffContext tariffContext;

    public VoiceRecordTarifficator(LogRecordProcessor proccessor, VoiceHourSessionProcessor sessionProcessor, int index, VoiceTariffContext tariffContext) {
        this.index = index;
        this.sessionProcessor = sessionProcessor;
        this.tariffContext = tariffContext;
    }

    @Override
    public Object call() throws Exception {
        int moduleId;
        try {
            VoiceTariffWorkerContext workerContext = (VoiceTariffWorkerContext)VoiceTariffWorkerContext.get();
            moduleId = workerContext.getModuleId();
        }
        catch (Exception ex) {
            logger.error("fatal error in " + this.getClass().getName(), (Throwable)ex);
            return null;
        }
        ErrorTask errorTask = new ErrorTask();
        try {
            TarifficationTask task;
            while ((task = this.sessionProcessor.takeNextTarifficationTask(this.index)) != null) {
                if (logger.isTraceEnabled()) {
                    logger.trace("take tarificate (index = " + this.index + ")");
                }
                task.waitResult();
                if (logger.isTraceEnabled()) {
                    logger.trace("start tarificate (index = " + this.index + "): array " + task.getIndex() + "; " + task.getSessions().size() + " sessions");
                    logger.trace("first contractId = " + String.valueOf(task.getSessions().size() > 0 ? Integer.valueOf(task.getSessions().get(0).getContractId()) : "null"));
                }
                Iterator<VoiceSessionRuntime> it = task.getSessions().iterator();
                while (it.hasNext()) {
                    VoiceSessionRuntime session = it.next();
                    int errorCode = AccessCode.SYSTEM_ERROR.getCode();
                    try {
                        errorCode = session.calculate(this.tariffContext, null, true);
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                    }
                    if (errorCode <= 0) continue;
                    VoiceError error = new VoiceError();
                    error.setCode(errorCode);
                    error.setDeviceId(session.getSession().getDeviceId());
                    error.setAccountId(session.getSession().getAccountId());
                    error.setHour(session.getSession().getHour());
                    error.setSessionStart(session.getSession().getSessionStart());
                    error.setPhoneFrom(session.getSession().getE164CallingStationId());
                    error.setPhoneTo(session.getSession().getE164CalledStationId());
                    error.setFromPort(session.getSession().getFromPort());
                    error.setToPort(session.getSession().getToPort());
                    error.setDuration(session.getSession().getSessionTime());
                    errorTask.addError(error);
                    it.remove();
                }
                this.sessionProcessor.addAddFlushTask(this.index, task);
                if (!logger.isTraceEnabled()) continue;
                logger.trace("end tarificate( index = " + this.index + "): array " + task.getIndex());
            }
            if (errorTask.getErrors().size() > 0) {
                this.sessionProcessor.addErrorTask(errorTask);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("voiceTarifficator(index = " + this.index + "): finishing");
            }
            this.sessionProcessor.finishFlushTasks(this.index);
            if (logger.isTraceEnabled()) {
                logger.trace("voiceTarifficator(index = " + this.index + ") finished");
            }
        }
        catch (InterruptedException ex) {
            logger.error(this.getClass().getName() + " was interrupted", (Throwable)ex);
        }
        catch (Exception e) {
            logger.error("fatal error in " + this.getClass().getName(), (Throwable)e);
            EventProcessor.getInstance().request((QueueEvent)new LogProcessInterrupted(moduleId, 0));
        }
        return null;
    }
}

