/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.server.service;

import jakarta.jws.WebService;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormProject;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormUploadStatistic;
import ru.bitel.bgbilling.modules.sorm.common.bean.ViewUploadFilesConfigurator;
import ru.bitel.bgbilling.modules.sorm.common.service.SormService;
import ru.bitel.bgbilling.modules.sorm.common.service.ViewUploadedFilesService;
import ru.bitel.bgbilling.modules.sorm.server.service.ViewUploadedSormFile;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.sorm.common.service.ViewUploadedFilesService")
public class ViewUploadedFilesServiceImpl
extends AbstractService
implements ViewUploadedFilesService {
    public List<String> searchFilesBySormProject(SormProject sormProject, Period period) throws BGException {
        return (List)this.tryReturn(() -> {
            String localCatalog = sormProject.getLoadedConfig().get("sorm.local.catalog", "");
            if (Utils.isBlankString((String)localCatalog)) {
                throw new BGException("\u0412 \u0434\u0430\u043d\u043d\u043e\u043c \u043f\u0440\u043e\u0435\u043a\u0442\u0435 \u0421\u041e\u0420\u041c \u043d\u0435 \u0437\u0430\u0434\u0430\u043d \u043b\u043e\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u043a\u0430\u0442\u0430\u043b\u043e\u0433 \u0434\u043b\u044f \u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u043e\u0432");
            }
            ArrayList<String> result = new ArrayList<String>();
            ServerContext serverContext = (ServerContext)ServerContext.get();
            SormService sormService = (SormService)serverContext.getService(SormService.class, this.moduleId);
            ArrayList<String> processedDates = new ArrayList<String>();
            for (SormUploadStatistic statistic : sormService.getStatisticOfProject(sormProject.getId(), null).getList()) {
                String date;
                Date dateFrom;
                Date uploadDate = statistic.getEndUploadTime();
                if (uploadDate == null || (dateFrom = period.getDateFrom()) != null && dateFrom.before(new Date()) && !TimeUtils.dateInPeriod((Date)uploadDate, (Period)period) || processedDates.contains(date = TimeUtils.format((Date)uploadDate, (String)"dd.MM.yyyy"))) continue;
                processedDates.add(date);
                Path pathToFilesDirectory = Paths.get(File.separator + localCatalog + File.separator + date + File.separator, new String[0]).normalize();
                this.getLogger().debug("\u041f\u0443\u0442\u044c \u0434\u043b\u044f \u043f\u043e\u0438\u0441\u043a\u0430 \u0441\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0445 \u0444\u0430\u0439\u043b\u043e\u0432: {}", (Object)pathToFilesDirectory);
                if (Files.exists(pathToFilesDirectory, new LinkOption[0])) {
                    result.addAll(this.getFilesFromDirectory(pathToFilesDirectory));
                    continue;
                }
                this.getLogger().warn("\u041f\u0443\u0442\u044c \u0434\u043e \u0444\u0430\u0439\u043b\u043e\u0432 \u0431\u044b\u043b \u0441\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d, \u043d\u043e \u043e\u043d \u043d\u0435 \u0432\u0435\u0440\u0435\u043d (\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u0434\u0430\u043d\u043d\u043e\u0439 \u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u0438 \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442): {}", (Object)pathToFilesDirectory);
            }
            return result;
        });
    }

    public List<String> searchFilesByPath(String pathToFile) throws BGException {
        Path path = Paths.get(pathToFile, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new BGMessageException("\u0424\u0430\u0439\u043b \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
        }
        return Files.isRegularFile(path, new LinkOption[0]) ? Collections.singletonList(path.toString()) : this.getFilesFromDirectory(path);
    }

    private List<String> getFilesFromDirectory(Path directory) throws BGException {
        List<String> result;
        try (Stream<Path> files = Files.walk(directory, new FileVisitOption[0]);){
            result = files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(this::filterByExtension).sorted((file1, file2) -> {
                Date lastModifyDateFile2;
                Date lastModifyDateFile1 = new Date(file1.toFile().lastModified());
                if (lastModifyDateFile1.after(lastModifyDateFile2 = new Date(file2.toFile().lastModified()))) {
                    return -1;
                }
                if (lastModifyDateFile1.before(lastModifyDateFile2)) {
                    return 1;
                }
                return 0;
            }).map(Path::toString).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    private boolean filterByExtension(Path file) {
        String fileName = file.getFileName().toString();
        return fileName.endsWith(".txt") || fileName.endsWith(".csv");
    }

    public String processUploadedFile(ViewUploadFilesConfigurator viewerConfigurator) throws BGException {
        List<String> data = new ViewUploadedSormFile(viewerConfigurator).processed();
        StringBuilder result = new StringBuilder();
        data.forEach(s -> result.append((String)s).append("\n"));
        return result.toString();
    }

    public void deleteFiles(List<String> files) throws BGException {
        for (String filePath : files) {
            Path pathTofile = Paths.get(filePath, new String[0]);
            try {
                Files.deleteIfExists(pathTofile);
            }
            catch (IOException e) {
                throw new BGException((Throwable)e);
            }
        }
    }
}

