/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.server.bean;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormProject;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Id;

public class SormProjectDao
extends AbstractIdDao<SormProject> {
    public SormProjectDao(Connection con, int moduleId) {
        super(con, "sorm_projects", moduleId);
    }

    public List<SormProject> getList() throws SQLException {
        ArrayList<SormProject> projects = new ArrayList<SormProject>();
        String query = "SELECT * FROM " + this.tableName;
        try (Statement statement = this.con.createStatement();
             ResultSet rs = statement.executeQuery(query);){
            while (rs.next()) {
                projects.add(this.getFromRS(rs));
            }
        }
        return projects;
    }

    protected void updateImpl(SormProject sormProject) throws SQLException {
        boolean update = sormProject.getId() > 0;
        String set = " SET title=?, comment=?, user_id=?, config=?, project_type=?, isEnable=?, last_modify_date=NOW()";
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + set + (update ? " WHERE id=?" : ", create_date=NOW()");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, sormProject.getTitle());
            ps.setString(index++, sormProject.getComment());
            ps.setInt(index++, sormProject.getUserId());
            ps.setString(index++, sormProject.getConfig());
            ps.setInt(index++, sormProject.getProjectType());
            ps.setInt(index++, sormProject.isEnable() ? 1 : 0);
            this.executeUpdate((Id)sormProject, index, ps);
        }
    }

    protected SormProject getFromRS(ResultSet rs) throws SQLException {
        SormProject sormProject = new SormProject();
        sormProject.setId(rs.getInt("id"));
        sormProject.setTitle(rs.getString("title"));
        sormProject.setComment(rs.getString("comment"));
        sormProject.setUserId(rs.getInt("user_id"));
        sormProject.setConfig(rs.getString("config"));
        sormProject.setCreateDate(TimeUtils.convertSqlDateToDate((Date)rs.getDate("create_date")));
        sormProject.setLastModifyDate(TimeUtils.convertSqlDateToDate((Date)rs.getDate("last_modify_date")));
        sormProject.setProjectType(rs.getInt("project_type"));
        int enable = rs.getInt("isEnable");
        sormProject.setEnable(enable == 1);
        return sormProject;
    }

    public List<SormProject> getActiveSormProject() throws SQLException {
        ArrayList<SormProject> activeProjects = new ArrayList<SormProject>();
        String query = "SELECT * FROM " + this.tableName + " WHERE isEnable=1";
        try (Statement statement = this.con.createStatement();
             ResultSet rs = statement.executeQuery(query);){
            while (rs.next()) {
                activeProjects.add(this.getFromRS(rs));
            }
        }
        return activeProjects;
    }
}

