package ru.bitel.bgbilling.modules.sorm.dyn.cdr;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.sorm.common.SormManufacturer;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormProject;
import ru.bitel.bgbilling.modules.sorm.server.upload.cdr.CDRItem;
import ru.bitel.bgbilling.modules.sorm.server.upload.cdr.voice.VoiceCDRUploadCommon;
import ru.bitel.bgbilling.modules.sorm.server.upload.norsitrans.NorsiTransFileTitle;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

import java.nio.file.Path;
import java.util.Arrays;

import static ru.bitel.bgbilling.modules.sorm.server.upload.norsitrans.NorsiTransConstants.FILE_TITLE_PATTERN;
import static ru.bitel.bgbilling.modules.sorm.server.utils.SormUtils.getUploadFile;
/*
Для АТС MD110
I - входящий из ТфОП
M - Исходящий в ТфОП
J - вызов внутри коммутатора
T - трансфер звонка
NI - переадресация
NJ - переадресация внутренних вызовов коммутатора
 */
public class NorsiTransVoiceCDRUpload
extends VoiceCDRUploadCommon
{
    private static final Logger log = LogManager.getLogger();

    public NorsiTransVoiceCDRUpload( SormProject sormProject, String cdrNumberConverters )
    throws BGException
    {
        super( sormProject, cdrNumberConverters );
    }

    @Override
    public SormManufacturer getSormManufacturer()
    {
        return SormManufacturer.NORSITRANS;
    }

    @Override
    public Path getFile()
    throws BGException
    {
        return getUploadFile( localUserPath,
                              NorsiTransFileTitle.CDR.getTitle(),
                              FILE_TITLE_PATTERN );
    }

    @Override
    public String[] getCDRItem( CDRItem cdrItem )
    throws BGException
    {
        String[] raw = cdrItem.otherInfo;
        StringBuilder logLine = new StringBuilder("New line for SORM: ");
        for ( int i = 0; i < raw.length; i++ )
        {
            logLine.append( i ).append( "=" ).append( raw[i] ).append( ", " );
        }
        log.debug( logLine );

        String callingNumber = raw[2].trim();
        String calledNumber = raw[3].trim();
        String callingE164 = applyCallingNumberConverterRule( callingNumber );
        String calledE164 = applyCalledNumberConverterRule( calledNumber );
        String conditionCode = raw[6];
        //String externalLineId = raw[8];
        String externalLineId = getExternalLineId( raw );

        log.debug( "startDate={}, A={}, B={}, A164={}, B164={}, duration={}, conditionCode={}", cdrItem.startTime, cdrItem.callingNumber, cdrItem.calledNumber, callingE164, calledE164, cdrItem.duration, conditionCode );

        try
        {
        /*
            Разделитель – табуляция.
            Поля не заключаются в экранирующие кавычки.
         */
            String[] item = new String[17];
            item[0] = regionId; //идентификатор оператора связи или филиала (регион) (число);
            item[1] = TimeUtils.formatFullDate( TimeUtils.parseDate( raw[0], TimeUtils.DATE_FORMAT_PATTERN_DDMMYYYY_HHMMSS ) ); //дата и время начала соединения;
            item[2] = String.valueOf( cdrItem.duration ); //длительность, сек (число);
            /*
            поле 4 - по справочнику, типа такого:
            "1";"0";"01.01.1999 00:00:00";"";"Телефонный вызов"
            "1";"1";"01.01.1999 00:00:00";"";"Исходящий вызов на ТФОП"
            "1";"2";"01.01.1999 00:00:00";"";"Входящий вызов из ТФОП"
            "1";"3";"01.01.1999 00:00:00";"";"Внутренний вызов в пределах сети АО ОператорСвязи"
             */
            String type = "0";
            if ( "M".equals( conditionCode ) )
            {
                type = "1";
            }
            else if ( "I".equals( conditionCode ) )
            {
                type = "2";
            }
            else if ( "J".equals( conditionCode ) )
            {
                type = "3";
            }
            item[3] = type; //тип вызова (справочник типов вызовов) (число);

            /*
            Поле 5 - это ДВО. Ставим по следующему справочнику:

            "1";"1";"NI";"01.01.1999 00:00:00";"";"Безусловная переадресация (NI)"
            "1";"2";"T";"01.01.1999 00:00:00";"";"Трансфер (T)"
            "1";"3";"NJ";"01.01.1999 00:00:00";"";"Входящий вызов на групповой номер (NJ)"

            в зависимости от ConditionCode - если "NI", то 1, если "T", то 2.
            Во всех остальных случаях - пустое поле (так написали НОРСИ).
             */
            String dvo = "";
            if ( "NI".equals( conditionCode ) )
            {
                dvo = "1";
            }
            else if ( "T".equals( conditionCode ) )
            {
                dvo = "2";
            }
            else if ( "NJ".equals(conditionCode) )
            {
                dvo = "3";
            }
            item[4] = dvo; //ДВО (справочник список ДВО) (число);

            item[5] = isOurNumber( callingE164 ) ? "0" : "1"; //тип вызывающего абонента (0 - абонент данного коммутатора, 1 - абонент сети связи);
            item[6] = isOurNumber( calledE164 ) ? "0" : "1"; //тип вызываемого абонента (0 - абонент данного коммутатора, 1 - абонент сети связи);
            item[7] = String.valueOf( cdrItem.deviceId ); //код АТС/коммутатора/MGW обслужившего вызов (код по справочнику коммутатора, обслужившего соединение) (строка);

            /*
            старый код

            String trunk = "";
            if ( externalLineId != null && externalLineId.length() >= 4 )
            {
                trunk = externalLineId.substring( 0, 4 ).trim();
            }
            item[8] = "I".equals( conditionCode ) ? trunk : ""; //входящая транковая группа (код по справочнику пучков соединительных линий) (число); // всегда значение 0101 для данного оператора
            item[9] = "M".equals(conditionCode) ? trunk : "";
             */

            /*
            - при исходящих вызовах на ТфОП (ConditionCode=M) поле 8 - пустое, поле 9 = 101, если "External Line ID" = 0101xx  и 401 если "External Line ID"=0401xx;
            - при входящих вызовах из ТфОП (ConditionCode=I или T или NI или пустое) поле 8 =101, поле 9 - пустое;
            - при вызовах внутри коммутатора (ConditionCode=J или NJ) поля 8 и 9 - пустые.
             */
            String inTrunk = "";
            String outTrunk = "";
            if ( "M".equals( conditionCode ) )
            {
                if ( externalLineId.startsWith( "00 0101" ) || externalLineId.startsWith( "0101" ) )
                {
                    outTrunk = "101";
                }
                else if ( externalLineId.startsWith( "00 0401" ) || externalLineId.startsWith( "0401" ) )
                {
                    outTrunk = "401";
                }
            }

            if ( "I".equals( conditionCode ) || "NI".equals( conditionCode ) || Utils.isBlankString( conditionCode ) )
            {
                inTrunk = "101";
                outTrunk = "";
            }

            item[8] = inTrunk;
            item[9] = outTrunk;

            item[10] = "607"; //причина разъединения соединения (код по справочнику причин завершения соединений) (число);

            // вынес в метод парсинг этих 5 полей
            parseIdentifiers( item, callingNumber, calledNumber, callingE164, calledE164, conditionCode );

            //17 - поле "External Line ID" из сырого лога при "Condition Code" = NI или NJ.
            if ( "NI".equals( conditionCode ) || "NJ".equals( conditionCode ) )
            {
                item[16] = Utils.maskBlank( parseExternalLineId( externalLineId ), "" ); //телефонный номер при переадресации (строка).
            }
            else
            {
                item[16] = ""; //телефонный номер при переадресации (строка).
            }

            log.debug( "Сформированная запись = {}", Arrays.toString( item ) );

            return item;
        }
        catch( Exception e )
        {
            throw new BGException( e );
        }
    }

    public String parseExternalLineId( String rawExternalLineId )
    {
        if ( rawExternalLineId == null || !rawExternalLineId.contains(" ") )
        {
            return "";
        }

        // Разделяем по пробелу и берём часть после него
        String[] parts = rawExternalLineId.trim().split("\\s+");
        if ( parts.length < 2 || parts[1].length() < 4 )
        {
            return "";
        }

        String id = parts[1].substring(0, 4); // Берём первые 4 цифры
        return id.startsWith("0") ? id.substring(1) : id; // Удаляем ведущий 0, если он есть
    }

    private String getExternalLineId( String[] raw )
    {
        String externalLineId = "";
        for (int i = raw.length - 1; i >= 0; i--)
        {
            if (!raw[i].trim().isEmpty())
            {
                externalLineId = raw[i].trim();
                break;
            }
        }
        return externalLineId;
    }

    public void parseIdentifiers( String[] item, String calling, String called, String callingE164, String calledE164, String conditionCode )
    {
        String field11 = ""; // Calling number (входящий ТфОП или E.164 при исходящем)
        String field12 = ""; // Calling number (только при исходящем)
        String field13 = called; // Dialled number (всегда)
        String field14 = ""; // Dialled number в E.164 (не для исходящих на ТфОП)
        String field15 = ""; // Dialled number при входящих и внутренних

        boolean isIncoming = "I".equals(conditionCode);
        boolean isOutgoing = "M".equals(conditionCode);
        boolean isInternal = "J".equals(conditionCode);
        boolean isTransfer = "T".equals(conditionCode);
        boolean isRedirect = "NI".equals(conditionCode) || "NJ".equals( conditionCode );

        field14 = called;

        if ( isIncoming || Utils.isBlankString( conditionCode ) )
        {
            field11 = calling;          // из ТфОП
            field12 = "";
            field14 = calledE164;
            field15 = called;
        }
        else if ( isOutgoing )
        {
            field11 = callingE164;
            field12 = calling;
            field14 = called.isEmpty() ? "" : calledE164;
            field15 = ""; // при исходящих на ТФОП — пусто
        }
        if ( isRedirect )
        {
            field11 = callingE164;
            field12 = "";
            field14 = calledE164;
            field15 = called;
        }
        else if ( isInternal )
        {
            field11 = callingE164;
            field12 = calling;
            field14 = calledE164;
            field15 = called;
        }
        else if ( isTransfer )
        {
            field11 = callingE164;
            field12 = calling;
            field14 = calledE164;
            field15 = "";
        }

        item[11] = Utils.maskBlank(field11, "");
        item[12] = Utils.maskBlank(field12, "");
        item[13] = Utils.maskBlank(field13, "");
        item[14] = Utils.maskBlank(field14, "");
        item[15] = Utils.maskBlank(field15, "");
    }

    @Override
    public String[] getCDRItem( String[] cdrFields )
    throws BGException
    {
        return null;
    }

    @Override
    public String[] getHeader()
    {
        return null;
    }
}