/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.client.contract;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGTextArea;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.table.client.BGDataSourceTableModel;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableRowData;
import ru.bitel.bgbilling.modules.smarthouse.client.contract.SmartHouseAccountFlussonicWatcherEditor;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.SmartHouseAccount;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.SmartHouseAccountType;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.enums.SmartHouseAccountMode;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.enums.SmartHouseAccountState;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.enums.SmartHouseAccountStatus;
import ru.bitel.bgbilling.modules.smarthouse.common.service.ForpostIntercomService;
import ru.bitel.bgbilling.modules.smarthouse.common.service.SmartHouseService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;

public class SmartHouseContractAccountPanel
extends BGUPanel {
    private BGTextField filterValue = new BGTextField(20);
    private BGUComboBox<KeyValue> filterColumn = new BGUComboBox();
    private BGUComboBox<IdTitle> filterStatus = new BGUComboBox();
    private BGUComboBox<IdTitle> filterState = new BGUComboBox();
    private JCheckBox filterClosed = new JCheckBox("\u043f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u0437\u0430\u043a\u0440\u044b\u0442\u044b\u0435");
    private BGDataSourceTableModel accountTableModel = new BGDataSourceTableModel("ContractAccount");
    private BGDataSourceTableModel accountTaskTableModel = new BGDataSourceTableModel("ContractAccountTask");
    private BGDataSourceTableModel accountConfigLogTableModel = new BGDataSourceTableModel("ContractAccountConfig");
    private BGUPanel.WebServiceHolder<SmartHouseService> smartHouseService = new BGUPanel.WebServiceHolder((BGUPanel)this, SmartHouseService.class);
    private BGUPanel.WebServiceHolder<ForpostIntercomService> forpostIntercomService = new BGUPanel.WebServiceHolder((BGUPanel)this, ForpostIntercomService.class);

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add(this.getFilterPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 5, 0, 5), 0, 0));
        this.add(this.getTableAndAccountDataPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getTableAndAccountDataPanel() {
        BGSplitPaneNoBorder splitPane = new BGSplitPaneNoBorder(0, (Component)this.getTablePanel(), (Component)this.getAccountDataPanel(), 300L);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)splitPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 5, 0, 5), 0, 0));
        return panel;
    }

    private JPanel getAccountDataPanel() {
        JPanel accountDataPanel = new JPanel(new BorderLayout());
        accountDataPanel.add((Component)this.getAccountConfigLogPanel(), "Center");
        accountDataPanel.add((Component)this.getAccountTaskPanel(), "East");
        return accountDataPanel;
    }

    private JPanel getAccountConfigLogPanel() {
        BGUTable table = new BGUTable((TableModel)this.accountConfigLogTableModel);
        table.setSelectionMode(0);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041b\u043e\u0433 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0439:"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 0, 5), 0, 0));
        panel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 0, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getAccountTaskPanel() {
        BGUTable table = new BGUTable((TableModel)this.accountTaskTableModel);
        table.setSelectionMode(0);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0417\u0430\u0434\u0430\u043d\u0438\u044f \u043d\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435:"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 0, 5), 0, 0));
        panel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 0, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getFilterPanel() {
        this.filterColumn.setData(Arrays.asList(new KeyValue("title", "\u0410\u043a\u043a\u0430\u0443\u043d\u0442"), new KeyValue("comment", "\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439")));
        this.filterValue.setHorizontalAlignment(0);
        this.filterClosed.addActionListener(e -> this.doFilterTable());
        ArrayList<IdTitle> statusItems = new ArrayList<IdTitle>();
        statusItems.add(new IdTitle(-1, "\u043b\u044e\u0431\u043e\u0439"));
        statusItems.addAll(Stream.of(SmartHouseAccountStatus.values()).map(SmartHouseAccountStatus::toIdTitle).toList());
        this.filterStatus.setData(statusItems);
        ArrayList<IdTitle> statesItems = new ArrayList<IdTitle>();
        statesItems.add(new IdTitle(-2, "\u043b\u044e\u0431\u043e\u0435"));
        statesItems.addAll(Stream.of(SmartHouseAccountState.values()).map(SmartHouseAccountState::toIdTitle).toList());
        this.filterState.setData(statesItems);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.filterColumn, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.filterValue, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u0421\u0442\u0430\u0442\u0443\u0441:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)this.filterStatus, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)this.filterState, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)this.filterClosed, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add(Box.createHorizontalGlue(), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getTablePanel() {
        BGUTable table = new BGUTable((TableModel)this.accountTableModel);
        table.setSelectionMode(0);
        table.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                Optional rowDataId = this.accountTableModel.optSelectRow(Id.class);
                this.showAccountTasks(rowDataId.map(a -> a.getId()).orElse(0));
                this.showAccountConfigs(rowDataId.map(a -> a.getId()).orElse(0));
            }
        });
        BGSwingUtilites.handleEdit((JTable)table, (AbstractBGUPanel)this);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private void showAccountTasks(int accountId) {
        BGUTableParams tableParams = new BGUTableParams().setContractId(((ClientContext)this.getContext()).getContractId()).addParam("accountId", accountId);
        this.accountConfigLogTableModel.loadData((ClientContext)this.getContext(), tableParams);
    }

    private void showAccountConfigs(int accountId) {
        BGUTableParams tableParams = new BGUTableParams().setContractId(((ClientContext)this.getContext()).getContractId()).addParam("accountId", accountId);
        this.accountTaskTableModel.loadData((ClientContext)this.getContext(), tableParams);
    }

    private void doFilterTable() {
        BGUTableParams tableParams = new BGUTableParams().setContractId(((ClientContext)this.getContext()).getContractId());
        this.accountTableModel.loadData((ClientContext)this.getContext(), tableParams);
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> this.doFilterTable());
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> new AccountEditor("\u041d\u043e\u0432\u044b\u0439 \u0430\u043a\u043a\u0430\u0443\u043d\u0442", new Id()).open());
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            Optional row = this.accountTableModel.optSelectedRow();
            if (row.isEmpty()) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0430\u043a\u043a\u0430\u0443\u043d\u0442 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
                return;
            }
            String mode = this.accountTableModel.optSelectedRow().map(a -> a.optValue("mode").orElse(null)).orElse(null);
            switch (SmartHouseAccountMode.getSmartHouseAccountMode((int)Utils.parseInt((String)mode))) {
                case FLUSSONICWATCHER: {
                    new SmartHouseAccountFlussonicWatcherEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430", (Id)this.accountTableModel.optSelectRow(Id.class).get(), (ClientContext)this.getContext()).open();
                    break;
                }
                case FORPOST_VIDEO: {
                    break;
                }
            }
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            IdTitle idTitle = this.accountTableModel.optSelectRow(IdTitle.class).orElse(null);
            if (idTitle == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0430\u043a\u043a\u0430\u0443\u043d\u0442 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f");
                return;
            }
            if (ClientUtils.confirmDelete((Object)idTitle)) {
                this.tryCall(() -> {
                    ((SmartHouseService)this.smartHouseService.get()).smarthouseAccountDelete(idTitle.getId());
                    this.performAction("refresh");
                });
            }
        });
    }

    class AccountEditor
    extends BGEditorDialog<Id> {
        private SmartHouseAccount account;
        private BGUComboBox<IdTitle> accountType;
        private BGDataSourceTableModel paramTableModel;
        private List<SmartHouseAccountType> smarthouseAccountTypes;
        private BGTextField title;
        private BGTextArea comment;

        public AccountEditor(String title, Id data) {
            super(title, (Object)data);
            this.account = new SmartHouseAccount();
            this.accountType = new BGUComboBox();
            this.paramTableModel = new BGDataSourceTableModel("ContractAccountParameter");
            this.smarthouseAccountTypes = new ArrayList<SmartHouseAccountType>();
            this.title = new BGTextField(50);
            this.comment = new BGTextArea(2, 50);
        }

        public void doDialogPanel() {
            this.title.setHorizontalAlignment(0);
            this.title.setEnabled(false);
            this.panel.add((Component)this.getTopPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.addFieldV("\u0410\u043a\u043a\u0430\u0443\u043d\u0442:", (JComponent)this.title);
            this.panel.add((Component)this.getParamTablePanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
            this.addFieldV("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:", new JScrollPane((Component)this.comment));
            this.accountType.addItemListener(SmartHouseContractAccountPanel.this.comboBoxSelect(e -> this.selectAccountType()));
            this.accountType.setEnabled(((Id)this.data).getId() == 0);
            if (((Id)this.data).getId() > 0) {
                this.tryCall(() -> {
                    this.account = ((SmartHouseService)SmartHouseContractAccountPanel.this.smartHouseService.get()).smarthouseAccountGet(((Id)this.data).getId());
                    this.accountType.setSelectedItem((Object)new Id().setId(this.account.getType()));
                });
            } else {
                this.account.setContractId(((ClientContext)SmartHouseContractAccountPanel.this.getContext()).getContractId());
            }
            this.title.setText(this.title.getText());
            this.comment.setText(this.account.getComment());
            this.selectAccountType();
        }

        private JPanel getTopPanel() {
            this.tryCall(() -> {
                this.smarthouseAccountTypes = ((SmartHouseService)SmartHouseContractAccountPanel.this.smartHouseService.get()).smarthouseAccountTypes();
            });
            ArrayList<IdTitle> accountTypeItems = new ArrayList<IdTitle>();
            accountTypeItems.add(IdTitle.NO_SELECT);
            accountTypeItems.addAll(this.smarthouseAccountTypes.stream().filter(a -> ((Id)this.data).getId() > 0 || a.isUsed()).map(IdTitle::toIdTitle).toList());
            this.accountType.setData(accountTypeItems);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u0422\u0438\u043f \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.accountType, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
            panel.add(Box.createHorizontalGlue(), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getParamTablePanel() {
            BGUTable table = new BGUTable((TableModel)this.paramTableModel);
            table.setSelectionMode(0);
            BGSwingUtilites.handleLDMouseClicked((Component)table, e -> this.showParamEditor());
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)BGSwingUtilites.wrapScrollPane((JComponent)table, (int)800, (int)300), new GridBagConstraints(-1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        private void selectAccountType() {
            BGUTableParams tableParams = new BGUTableParams().setContractId(((ClientContext)SmartHouseContractAccountPanel.this.getContext()).getContractId()).addParam("accountId", this.account.getId()).addParam("accountTypeId", ((IdTitle)this.accountType.getSelectedItem()).getId());
            this.paramTableModel.loadData((ClientContext)SmartHouseContractAccountPanel.this.getContext(), tableParams);
        }

        private void showParamEditor() {
            BGUTableRowData rowData = (BGUTableRowData)this.paramTableModel.getSelectedRow();
            String type = rowData.optValue("type").orElse(null);
            if (type.startsWith("list:")) {
                String dir;
                switch (dir = type.substring(5)) {
                    case "forpost_intercom_management_account": {
                        this.tryCall(() -> {
                            List items = ((ForpostIntercomService)SmartHouseContractAccountPanel.this.forpostIntercomService.get()).forpostIntercomManagementAccountList();
                            new ComboBoxEditor(SmartHouseContractAccountPanel.this, "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430", rowData, items).open();
                        });
                        break;
                    }
                    case "forpost_intercom_device": {
                        this.tryCall(() -> {
                            String managementAccountId = this.paramTableModel.getRows().stream().filter(a -> "ManagementAccountId".equals(a.optValue("name").orElse(""))).findFirst().map(a -> a.optValue("value").orElse(null)).orElse(null);
                            if (Utils.isEmptyString((String)managementAccountId)) {
                                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u043d\u0430\u0447\u0430\u043b\u0430 \u0434\u043e\u043c\u043e\u0444\u043e\u043d\u043d\u044b\u0439 \u0430\u043a\u043a\u0430\u0443\u043d\u0442");
                                return;
                            }
                            new ForpostIntercomDeviceEditor("\u0412\u044b\u0431\u043e\u0440 \u0434\u043e\u043c\u043e\u0444\u043e\u043d\u0430", rowData, Utils.parseInt((String)managementAccountId)).open();
                        });
                        break;
                    }
                    default: {
                        ClientUtils.showErrorMessageDialog((String)("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f [" + dir + "]"));
                    }
                }
            }
        }

        public boolean doApply() throws Exception {
            int accountTypeId = ((IdTitle)this.accountType.getSelectedItem()).getId();
            SmartHouseAccountMode accountMode = this.smarthouseAccountTypes.stream().filter(a -> a.getId() == accountTypeId).findFirst().map(SmartHouseAccountType::getMode).orElse(null);
            if (accountMode == null) {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u0442\u0438\u043f \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430");
                return false;
            }
            this.account.setType(accountTypeId).setComment(this.comment.getText());
            switch (accountMode) {
                case FORPOST_INTERCOM: {
                    break;
                }
                case FORPOST_VIDEO: {
                    break;
                }
            }
            return this.tryCallBoolean(() -> {
                ((SmartHouseService)SmartHouseContractAccountPanel.this.smartHouseService.get()).smarthouseAccountUpdate(this.account);
                SmartHouseContractAccountPanel.this.performAction("refresh");
            });
        }
    }

    class ForpostIntercomDeviceEditor
    extends BGEditorDialog<BGUTableRowData> {
        private int accountId;
        private BGUComboBox<KeyValue> filter;
        private BGUList<IdTitle> houseList;
        private BGUList<IdTitle> podList;

        public ForpostIntercomDeviceEditor(String title, BGUTableRowData data, int accountId) {
            super(title, (Object)data);
            this.accountId = 0;
            this.filter = new BGUComboBox();
            this.houseList = new BGUList();
            this.podList = new BGUList();
            this.accountId = accountId;
        }

        public void doDialogPanel() {
            List<KeyValue> filterItems = Arrays.asList(new KeyValue("", "\u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0440\u0435\u0436\u0438\u043c \u0444\u0438\u043b\u044c\u0442\u0440\u0430\u0446\u0438\u0438"), new KeyValue("manual", "\u0432\u044b\u0431\u043e\u0440 \u0438\u0437 \u0441\u043f\u0438\u0441\u043a\u0430 \u0432\u0441\u0435\u0445 \u0434\u043e\u043c\u043e\u0432"));
            this.filter.setData(filterItems);
            this.filter.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.doFilter();
                }
            });
            this.addFieldV("\u0424\u0438\u043b\u044c\u0442\u0440:", (JComponent)this.filter);
            this.addFieldV("", this.getHouseAndPodPanel());
        }

        private JPanel getHouseAndPodPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.getHousePanel(), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.getPodPanel(), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getHousePanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            this.addFieldV("\u0414\u043e\u043c:", BGSwingUtilites.wrapScrollPane(this.houseList, (int)600, (int)350), panel);
            return panel;
        }

        private JPanel getPodPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            this.addFieldV("\u041f\u043e\u0434\u044a\u0435\u0437\u0434:", BGSwingUtilites.wrapScrollPane(this.podList, (int)200, (int)350), panel);
            return panel;
        }

        private void doFilter() {
            String filterMode;
            switch (filterMode = ((KeyValue)this.filter.getSelectedItem()).getKey()) {
                case "": {
                    this.houseList.removeAll();
                    this.podList.removeAll();
                    break;
                }
                case "manual": {
                    this.tryCall(() -> this.houseList.setData(((ForpostIntercomService)SmartHouseContractAccountPanel.this.forpostIntercomService.get()).forpostIntercomHouseList(this.accountId)));
                    this.podList.removeAll();
                    break;
                }
            }
        }
    }

    class ComboBoxEditor
    extends BGEditorDialog<BGUTableRowData> {
        private BGUComboBox<KeyValue> comboBox = new BGUComboBox();

        public ComboBoxEditor(SmartHouseContractAccountPanel this$0, String title, BGUTableRowData data, List<KeyValue> items) {
            super(title, (Object)data);
            ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>(items);
            keyValues.add(0, new KeyValue("0", "====="));
            this.comboBox.setData(keyValues);
        }

        public void doDialogPanel() {
            this.addFieldV(((BGUTableRowData)this.data).optValue("title").map(a -> a + ":").orElse(""), (JComponent)this.comboBox);
            this.comboBox.setSelectedItem((Object)new KeyValue(((BGUTableRowData)this.data).optValue("value").orElse("0"), ""));
        }

        public boolean doApply() throws Exception {
            KeyValue keyValue = (KeyValue)this.comboBox.getSelectedItem();
            if ("0".equals(keyValue.getKey())) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435");
                return false;
            }
            ((BGUTableRowData)this.data).setValue("value", String.valueOf(keyValue.getKey()));
            ((BGUTableRowData)this.data).setValue("valueTitle", keyValue.getValue());
            return true;
        }
    }
}

