/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mtsbank.server.bean;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.security.cert.X509Certificate;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.apache.logging.log4j.LogManager;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.SearchParam;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.mtsbank.common.bean.Transaction;
import ru.bitel.bgbilling.modules.mtsbank.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.mtsbank.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.mtsbank.server.event.MTSbankAutopaymentSumEvent;
import ru.bitel.bgbilling.server.bean.AbstractTransactionManager;
import ru.bitel.bgbilling.server.util.KeyStoreUtils;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;
import ru.bitel.common.security.EyelessHostnameVerifier;
import ru.bitel.common.security.PEMCertificate;

public class TransactionManager
extends AbstractTransactionManager<Transaction> {
    public TransactionManager(Connection con, int moduleId) {
        super(con, "mtsbank_transaction", moduleId);
        this.fields = new HashMap();
        this.fields.put("id", "id");
        this.fields.put("createDate", "create_date");
        this.fields.put("transactionDate", "transaction_date");
        this.fields.put("sum", "sum");
    }

    protected void queryStatus(StringBuilder query, String status) {
        if (Utils.notBlankString((String)status) && !TransactionStatus.ALL.getCode().equals(status)) {
            query.append(" AND pt.result=?");
        }
    }

    protected int psStatus(PreparedStatement ps, String status, int index) throws SQLException {
        if (Utils.notBlankString((String)status) && !TransactionStatus.ALL.getCode().equals(status)) {
            ps.setString(index++, status);
        }
        return index;
    }

    protected Transaction getFromRS(ResultSet rs) throws SQLException {
        return (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setId(rs.getInt("id"))).setContractId(rs.getInt("contract_id"))).setContractTitle(rs.getString("contract_title"))).setPaymentId(rs.getInt("payment_id"))).setCreateDate((Date)rs.getTimestamp("create_date"))).setTransactionDate((Date)rs.getTimestamp("transaction_date"))).setTransactionId(rs.getString("transaction_id"))).setStatus(rs.getString("result"))).setParameters(rs.getString("params"))).setSum(rs.getBigDecimal("sum"))).setAutopayment(rs.getBoolean("autopayment"))).build();
    }

    protected void updateImpl(Transaction transaction) throws SQLException {
        String querySet = "contract_id=?, payment_id=?, create_date=?, transaction_date=?, transaction_id=?, result=?, params=?, sum=?, autopayment=?";
        try (PreparedStatement ps = this.prepareStatement((Id)transaction, querySet);){
            int index = 1;
            ps.setInt(index++, transaction.getContractId());
            ps.setInt(index++, transaction.getPaymentId());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getCreateDate()));
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getTransactionDate()));
            ps.setString(index++, transaction.getTransactionId());
            ps.setString(index++, transaction.getStatus());
            ps.setString(index++, transaction.getParameters());
            ps.setBigDecimal(index++, transaction.getSum());
            ps.setBoolean(index++, transaction.isAutopayment());
            this.executeUpdate((Id)transaction, index, ps);
        }
    }

    public void doCheckRequest(int contractId, String clientIpAddr) throws Exception {
        SearchParam searchParam = SearchParam.builder().setContractId(contractId).setStatus(TransactionStatus.CREATED.getCode()).build();
        SearchResult searchResult = new SearchResult(new Page(1, 25), new String[]{"createDate:1"});
        this.searchTransaction(searchResult, searchParam);
        for (Transaction transaction : searchResult.getList()) {
            String transactionId = transaction.getTransactionId();
            if (transactionId == null) continue;
            StringBuilder requestParam = new StringBuilder("command=c").append("&trans_id=").append(URLEncoder.encode(transactionId, "UTF-8")).append("&client_ip_addr=").append(this.moduleSetup.get("mtsbank.client.ip.addr", clientIpAddr));
            String responseParam = TransactionManager.doRequest(requestParam.toString(), this.moduleSetup);
            this.checkResponse(responseParam, transaction);
        }
    }

    public Transaction registerOrder(int contractId, String contractTitle, BigDecimal sum, Map<String, Object> dataMap, boolean autopaymentTransaction, boolean requestBindingId) throws Exception {
        if (autopaymentTransaction || requestBindingId) {
            MTSbankAutopaymentSumEvent event = new MTSbankAutopaymentSumEvent(this.moduleId, contractId, sum);
            BigDecimal newSum = ((MTSbankAutopaymentSumEvent)EventProcessor.getInstance().request((QueueEvent)event)).getSum();
            if (newSum != null) {
                sum = newSum;
            }
        }
        Transaction transaction = (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setSum(sum)).setContractId(contractId)).setCreateDate(new Date())).setAutopayment(autopaymentTransaction)).build();
        this.update(transaction);
        String bindingId = null;
        String description = this.moduleSetup.get("mtsbank.description", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contractTitle);
        StringBuilder requestParam = new StringBuilder("command=").append(requestBindingId ? "z" : "v").append("&amount=").append(sum.multiply(new BigDecimal(100)).longValue()).append("&currency=643").append("&client_ip_addr=").append(this.moduleSetup.get("mtsbank.client.ip.addr", (String)dataMap.get("mtsbank.client.ip.addr"))).append("&description=").append(description);
        if (requestBindingId) {
            String billingName = Setup.getSetup().get("billing.name");
            bindingId = (String)(billingName == null ? "" : billingName + "_") + contractId + "_" + String.valueOf(System.currentTimeMillis());
            requestParam.append("&biller_client_id=").append(bindingId);
            GregorianCalendar now = new GregorianCalendar();
            ((Calendar)now).add(2, this.moduleSetup.getInt("mtsbank.autopayment.pattern.expiry", 12));
            SimpleDateFormat dateFormat = new SimpleDateFormat("MMYY");
            requestParam.append("&perspayee_expiry=").append(dateFormat.format(now.getTime()));
        }
        String responseParam = TransactionManager.doRequest(requestParam.toString(), this.moduleSetup);
        String transactionId = null;
        if (responseParam != null) {
            for (String line : responseParam.split("\n")) {
                PeriodWithTime period;
                AutopaymentManager autopaymentManager;
                Autopayment autopayment;
                if (!line.startsWith("TRANSACTION_ID:")) continue;
                transactionId = line.substring(15).trim();
                dataMap.put("formFields", new String[]{"trans_id"});
                dataMap.put("trans_id", transactionId);
                if (!requestBindingId || (autopayment = (autopaymentManager = new AutopaymentManager(this.con, this.moduleId)).getCurrentAutopayment(contractId)) == null || (period = autopayment.getPeriod()) == null || period.getDateFrom() != null) continue;
                period.setLocalDateTimeFrom(LocalDateTime.now());
                autopayment.setAccessToken(bindingId);
                autopaymentManager.updateAutopayment(autopayment);
            }
        }
        if (transactionId != null) {
            transaction.setTransactionId(transactionId);
            transaction.setParameters(requestParam.append("\nTRANSACTION_ID = ").append(transactionId).toString());
            this.update(transaction);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("TRANSACTION DATA:\n" + requestParam.toString());
            }
        }
        return transaction;
    }

    public void doAutopayment(int contractId, String contractTitle, BigDecimal sum, Autopayment autopayment) throws Exception {
        if (sum != null && autopayment != null) {
            Transaction transaction = (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setSum(sum)).setContractId(contractId)).setCreateDate(new Date())).setAutopayment(true)).build();
            this.update(transaction);
            String bindingId = autopayment.getAccessToken();
            if (bindingId != null) {
                String description = this.moduleSetup.get("mtsbank.description", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contractTitle);
                try {
                    bindingId = URLEncoder.encode(bindingId, "UTF-8");
                    description = URLEncoder.encode(description, "UTF-8");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                StringBuilder requestParam = new StringBuilder("command=e").append("&amount=").append(sum.multiply(new BigDecimal(100)).longValue()).append("&currency=643").append("&client_ip_addr=").append(this.moduleSetup.get("mtsbank.client.ip.addr", "0.0.0.0")).append("&description=").append(description);
                requestParam.append("&biller_client_id=").append(bindingId);
                String responseParam = TransactionManager.doRequest(requestParam.toString(), this.moduleSetup);
                Map<String, String> responseParamMap = this.checkResponse(responseParam, transaction);
                if (responseParamMap != null && responseParamMap.containsKey("RESULT_CODE") && !"000".equals(responseParamMap.get("RESULT_CODE"))) {
                    autopayment.getPeriod().setLocalDateTimeTo(LocalDateTime.now());
                    new AutopaymentManager(this.con, this.moduleId).updateAutopayment(autopayment);
                }
            } else {
                this.getLogger().error("\u0417\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 \u0430\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d, \u0442\u0430\u043a \u043a\u0430 \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d bindingId = " + bindingId);
            }
        }
    }

    private Map<String, String> checkResponse(String responseParam, Transaction transaction) throws Exception {
        HashMap<String, String> responseParamMap = new HashMap<String, String>();
        if (responseParam != null) {
            for (String line : responseParam.split("\n")) {
                String[] keyValue = line.split(":");
                if (keyValue.length <= 1) continue;
                responseParamMap.put(keyValue[0].trim(), keyValue[1].trim());
            }
            if (responseParamMap.containsKey("error")) {
                transaction.setStatus(TransactionStatus.ERROR.getCode());
                transaction.setTransactionDate(new Date());
                transaction.setPaymentId(-1);
                transaction.setParameters(transaction.getParameters() + "\n\n" + responseParam);
                this.update(transaction);
            } else {
                String result = (String)responseParamMap.get("RESULT");
                if (result != null) {
                    if ("OK".equals(result)) {
                        PeriodWithTime period;
                        AutopaymentManager autopaymentManager;
                        Autopayment autopayment;
                        transaction.setStatus(TransactionStatus.OK.getCode());
                        transaction.setTransactionDate(new Date());
                        Payment payment = Payment.builder().setDate(transaction.getTransactionDate()).setTypeId(this.moduleSetup.getInt("mtsbank.payment.type.id", 0)).setContractId(transaction.getContractId()).setSum(transaction.getSum()).setUserId(0).setTransactionId(String.valueOf(transaction.getId())).setComment("\u041f\u043b\u0430\u0442\u0435\u0436 \u0447\u0435\u0440\u0435\u0437 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u0443\u044e \u0441\u0438\u0441\u0442\u0435\u043c\u0443 \u041c\u0422\u0421\u0411\u0430\u043d\u043a").build();
                        new PaymentDao(this.con).update((Object)payment);
                        ServerUtils.commitConnection((Connection)this.con);
                        try (BalanceUtils balanceUtils = new BalanceUtils(this.con);){
                            balanceUtils.updateBalance(payment.getDate(), payment.getContractId());
                        }
                        ServerUtils.commitConnection((Connection)this.con);
                        transaction.setPaymentId(payment.getId());
                        StringBuilder transactionParameters = new StringBuilder();
                        if (transaction.getParameters() != null) {
                            transactionParameters.append(transaction.getParameters());
                        }
                        if (transactionParameters.length() > 0 && !responseParam.isEmpty()) {
                            transactionParameters.append("\n\n").append(responseParam);
                        }
                        transaction.setParameters(transactionParameters.toString());
                        this.update(transaction);
                        String reccPmntId = (String)responseParamMap.get("RECC_PMNT_ID");
                        if (reccPmntId != null && (autopayment = (autopaymentManager = new AutopaymentManager(this.con, this.moduleId)).getCurrentAutopayment(transaction.getContractId())) != null && (period = autopayment.getPeriod()) != null && period.getDateFrom() == null) {
                            period.setLocalDateTimeFrom(LocalDateTime.now());
                            autopayment.setAccessToken(reccPmntId);
                            autopaymentManager.updateAutopayment(autopayment);
                        }
                        EventProcessor.getInstance().publish((Event)new PaymentEvent(0, payment));
                        EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, payment.getSum()));
                    } else if (!"PENDING".equals(result) && !"CREATED".equals(result)) {
                        transaction.setStatus(TransactionStatus.ERROR.getCode());
                        transaction.setTransactionDate(new Date());
                        transaction.setPaymentId(-1);
                        transaction.setParameters(transaction.getParameters() + "\n\n" + responseParam);
                        this.update(transaction);
                    }
                }
            }
        }
        return responseParamMap;
    }

    public static String doRequest(String requestParam, ParameterMap moduleSetup) throws BGException {
        StringBuilder result = null;
        try {
            File fileCertCrt = new File(moduleSetup.get("mtsbank.cert.path.crt", "cert/mtsbank/cert.pem"));
            File fileCertKey = new File(moduleSetup.get("mtsbank.cert.path.key", "cert/mtsbank/key.pem"));
            File fileHostCrt = new File(moduleSetup.get("mtsbank.cert.path.host", "cert/mtsbank/host.pem"));
            SSLContext sslContext = null;
            if (fileCertCrt.exists() && fileCertKey.exists() && fileHostCrt.exists()) {
                X509Certificate[] chain = new X509Certificate[]{PEMCertificate.getPemCertificate((File)fileCertCrt)};
                String keyPassword = moduleSetup.get("mtsbank.cert.key.password", "");
                sslContext = KeyStoreUtils.createSSLContext((File)fileCertKey, (String)keyPassword, (X509Certificate[])chain, (File[])new File[]{fileHostCrt});
            }
            URL url = URI.create(moduleSetup.get("mtsbank.merchant.url", "https://payments.mtsbank.ru/ecomm/MerchantHandler")).toURL();
            HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-type", "application/x-www-form-urlencoded; charset=UTF-8");
            if (sslContext != null) {
                connection.setSSLSocketFactory(sslContext.getSocketFactory());
                connection.setHostnameVerifier((HostnameVerifier)EyelessHostnameVerifier.INSTANCE);
            }
            connection.setDoOutput(true);
            connection.setDoInput(true);
            if (LogManager.getLogger().isDebugEnabled()) {
                LogManager.getLogger().debug("\u0417\u0430\u043f\u0440\u043e\u0441 MTSBank PG: {}", (Object)requestParam);
            }
            try (OutputStream writer = connection.getOutputStream();){
                writer.write(requestParam.getBytes("utf-8"));
                writer.flush();
            }
            if (connection.getResponseCode() == 200) {
                result = new StringBuilder();
                BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                String line = null;
                while ((line = br.readLine()) != null) {
                    result.append(line).append("\n");
                }
                if (LogManager.getLogger().isDebugEnabled()) {
                    LogManager.getLogger().debug("\u041e\u0442\u0432\u0435\u0442 MTSBank PG: {}", (Object)result);
                }
            } else {
                LogManager.getLogger().error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u043a \u0448\u043b\u044e\u0437\u0443. [ResponseCode: " + connection.getResponseCode() + "; " + connection.getResponseMessage() + "]");
            }
        }
        catch (Exception ex) {
            throw new BGException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u0442\u0441\u044f \u043a \u0448\u043b\u044e\u0437\u0443. \u041f\u043e\u0434\u0440\u043e\u0431\u043d\u043e\u0441\u0442\u0438: " + ex.getMessage(), (Throwable)ex);
        }
        return result == null ? null : result.toString();
    }
}

