/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.loader.server.utils;

import jakarta.mail.internet.InternetAddress;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterGroupAttr;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.parameter.ContractParameterGroupAttrDao;
import ru.bitel.bgbilling.kernel.contract.loader.server.utils.LoaderBase;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.directories.address.common.bean.City;
import ru.bitel.oss.kernel.directories.address.common.bean.Country;
import ru.bitel.oss.kernel.directories.address.common.bean.House;
import ru.bitel.oss.kernel.directories.address.common.bean.Street;
import ru.bitel.oss.kernel.directories.address.server.bean.CityDao;
import ru.bitel.oss.kernel.directories.address.server.bean.CountryDao;
import ru.bitel.oss.kernel.directories.address.server.bean.HouseDao;
import ru.bitel.oss.kernel.directories.address.server.bean.StreetDao;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrDate;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrEmail;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrPhone;
import ru.bitel.oss.kernel.entity.common.bean.enums.EntitySpecAttrType;

public class LoaderParameterConvertUtil
extends LoaderBase {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String execute(String data, String config) throws BGException {
        JSONObject configJsonObject = new JSONObject(config);
        int sourceParameterId = configJsonObject.optInt("sourceParameterId", 0);
        int targetParameterId = configJsonObject.optInt("targetParameterId", 0);
        StringBuffer buf = new StringBuffer();
        try {
            String mode = configJsonObject.optString("mode", "append");
            if ("replace".equals(mode)) {
                this.deleteParameter(targetParameterId);
            }
            try (ContractDao contractDao = new ContractDao(this.con, 0);
                 ContractParameterGroupAttrDao contractParameterGroupAttrDao = new ContractParameterGroupAttrDao(this.con);){
                ContractParameterGroupAttr contractParameterGroupAttr = (ContractParameterGroupAttr)((Object)contractParameterGroupAttrDao.get(targetParameterId));
                EntitySpecAttrType targetAttrType = (EntitySpecAttrType)EntitySpecAttrType.optEntitySpecAttrType((int)contractParameterGroupAttr.getType()).get();
                switch (targetAttrType) {
                    case PHONE: {
                        buf.append("\u0422\u0435\u043b\u0435\u0444\u043e\u043d \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u043e\u0432\u0430\u0442\u044c \u0448\u0430\u0431\u043b\u043e\u043d\u0443 +7XXXXXXXXXX\n\n");
                        break;
                    }
                }
                int counter = 0;
                try (PreparedStatement psSelect = this.con.prepareStatement("SELECT id, title FROM contract");
                     ResultSet resultSet = psSelect.executeQuery();){
                    block55: while (resultSet.next()) {
                        String val;
                        ++counter;
                        int contractId = resultSet.getInt(1);
                        String contractTitle = resultSet.getString(2);
                        EntityAttr entityAttr = contractDao.getContractParameter(contractId, sourceParameterId);
                        if (entityAttr == null || !Utils.notBlankString(val = entityAttr.toString())) continue;
                        switch (targetAttrType) {
                            case DATE: {
                                Date date = TimeUtils.parseDate(val, "dd.MM.yyyy");
                                if (date == null) break;
                                contractDao.updateContractParameter(contractId, (EntityAttr)new EntityAttrDate(contractId, targetParameterId, date));
                                break;
                            }
                            case EMAIL: {
                                List<String> emails = Utils.toList(val, "\n ;,");
                                if (emails.isEmpty()) break;
                                ArrayList<EntityAttrEmail.EmailContact> contacts = new ArrayList<EntityAttrEmail.EmailContact>();
                                for (String email : emails) {
                                    InternetAddress[] addresses = InternetAddress.parse((String)email);
                                    if (addresses == null) continue;
                                    int size = addresses.length;
                                    for (int index = 0; index < size; ++index) {
                                        contacts.add(new EntityAttrEmail.EmailContact(addresses[index].getPersonal(), addresses[index].getAddress()));
                                    }
                                }
                                if (contacts.isEmpty()) continue block55;
                                EntityAttrEmail entityAttrEmail = (EntityAttrEmail)contractDao.getContractParameter(contractId, targetParameterId);
                                if (entityAttrEmail == null) {
                                    entityAttrEmail = new EntityAttrEmail(contractId, targetParameterId);
                                }
                                entityAttrEmail.getContactList().addAll(contacts);
                                contractDao.updateContractParameter(contractId, (EntityAttr)entityAttrEmail);
                                break;
                            }
                            case PHONE: {
                                if (val.matches("^\\+\\d{11}$")) {
                                    EntityAttrPhone entityAttrPhone = (EntityAttrPhone)contractDao.getContractParameter(contractId, targetParameterId);
                                    if (entityAttrPhone == null) {
                                        entityAttrPhone = new EntityAttrPhone(contractId, targetParameterId);
                                    }
                                    entityAttrPhone.addContact(val, "");
                                    contractDao.updateContractParameter(contractId, (EntityAttr)entityAttrPhone);
                                    break;
                                }
                                buf.append(contractTitle).append(": \u043f\u0440\u043e\u043f\u0443\u0441\u043a\u0430\u0435\u043c [").append(val).append("]\n");
                                break;
                            }
                            case ADDRESS: {
                                try {
                                    CityDao cityDao = new CityDao(this.con);
                                    try {
                                        HouseDao houseDao = new HouseDao(this.con);
                                        try {
                                            StreetDao streetDao = new StreetDao(this.con);
                                            try {
                                                CountryDao countryDao = new CountryDao(this.con);
                                                try {
                                                    String houseFrac;
                                                    House house;
                                                    String streetTitle;
                                                    Street street;
                                                    String cityTitle;
                                                    City city;
                                                    JSONObject jsonObject = new JSONObject(val);
                                                    String countryTitle = jsonObject.optString("country", "\u0420\u043e\u0441\u0441\u0438\u044f");
                                                    Country country = countryDao.get(countryTitle);
                                                    if (country == null) {
                                                        country = new Country();
                                                        country.setTitle(countryTitle);
                                                        countryDao.update((Object)country);
                                                    }
                                                    if ((city = cityDao.get(cityTitle = jsonObject.optString("city"), country.getId())) == null) {
                                                        city = new City();
                                                        city.setCountryId(country.getId());
                                                        city.setTitle(cityTitle);
                                                        cityDao.update((Object)city);
                                                    }
                                                    if ((street = (Street)streetDao.get(streetTitle = jsonObject.optString("street"), city.getId())) == null) {
                                                        street = new Street();
                                                        street.setCity(city);
                                                        street.setTitle(streetTitle);
                                                        streetDao.update((Object)street);
                                                    }
                                                    if ((house = houseDao.get(houseFrac = jsonObject.optString("house"), street.getId())) == null) {
                                                        house = new House();
                                                        house.setStreetId(street.getId());
                                                        house.setHouseAndFrac(houseFrac);
                                                        house.setPostIndex(jsonObject.optString("postIndex"));
                                                        houseDao.update(house);
                                                    }
                                                    String flat = jsonObject.optString("flat");
                                                    EntityAttrAddress entityAttrAddress = new EntityAttrAddress(contractId, targetParameterId).setHouseId(house.getId()).setPod(0).setFloor(0).setFlat(flat).setRoom("").setComment("").setFormatKey(null).setTitle(val);
                                                    contractDao.updateContractParameter(contractId, (EntityAttr)entityAttrAddress);
                                                    continue block55;
                                                }
                                                finally {
                                                    countryDao.close();
                                                    continue block55;
                                                }
                                            }
                                            finally {
                                                streetDao.close();
                                                continue block55;
                                            }
                                        }
                                        finally {
                                            houseDao.close();
                                            continue block55;
                                        }
                                    }
                                    finally {
                                        cityDao.close();
                                        continue block55;
                                    }
                                }
                                catch (Exception ex) {
                                    this.logError(ex);
                                    break;
                                }
                            }
                        }
                    }
                }
                buf.append("\n\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432: ").append(counter);
                return buf.toString();
            }
            catch (Exception ex) {
                this.logError(ex);
                return buf.toString();
            }
        }
        catch (Exception ex) {
            this.logError(ex);
            throw new BGException(ex);
        }
    }
}

