/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.bean.parameter;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterGroup;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.parameter.ContractParameterGroupAttrDao;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractDirectoryIdDao;

public class ContractParameterGroupDao
extends AbstractDirectoryIdDao<ContractParameterGroup> {
    private ContractParameterGroupAttrDao attrDao;

    public ContractParameterGroupDao(Connection con) {
        super(con, 0, "contract_parameter_group_name");
        this.attrDao = new ContractParameterGroupAttrDao(con);
    }

    @Override
    protected ContractParameterGroup getFromRS(ResultSet rs) throws SQLException, BGException {
        int id = rs.getInt("id");
        return new ContractParameterGroup().setId(id).setTitle(rs.getString("title")).setAttributeList(this.attrDao.list(id));
    }

    @Override
    protected void updateImpl(ContractParameterGroup contractParameterGroup) throws BGException, SQLException {
        boolean update = contractParameterGroup.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET title=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            ps.setString(1, contractParameterGroup.getTitle());
            if (update) {
                ps.setInt(2, contractParameterGroup.getId());
            }
            ps.executeUpdate();
            if (!update) {
                contractParameterGroup.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
    }

    @Override
    protected int deleteImpl(int id) throws BGException, SQLException {
        this.checkContractUsed(id);
        this.checkContractPatternUsed(id);
        int result = super.deleteImpl(id);
        String query = "DELETE FROM contract_parameter_group WHERE gid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
        return result;
    }

    private void checkContractUsed(int id) throws SQLException, BGMessageException {
        boolean found = false;
        String query = "SELECT id FROM contract WHERE pgid=? LIMIT 1";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    found = true;
                }
            }
        }
        if (found) {
            throw new BGMessageException("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u0433\u0440\u0443\u043f\u043f\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430\u0445.");
        }
    }

    private void checkContractPatternUsed(int id) throws SQLException, BGMessageException {
        boolean found = false;
        String query = "SELECT id FROM contract_pattern WHERE pgid=? LIMIT 1";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    found = true;
                }
            }
        }
        if (found) {
            throw new BGMessageException("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u0433\u0440\u0443\u043f\u043f\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0432 \u0448\u0430\u0431\u043b\u043e\u043d\u0430\u0445 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430.");
        }
    }

    @Override
    public ContractParameterGroup get(String title) throws BGException {
        return (ContractParameterGroup)((Object)super.get("title=?", title));
    }

    @Override
    public List<ContractParameterGroup> list() throws BGException {
        return super.list(null, null, new Object[0]);
    }
}

