/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import ru.bitel.common.Utils;
import ru.bitel.common.io.Base64InputStream;
import ru.bitel.common.io.Base64OutputStream;

public class Base64 {
    static String CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    static char PAD = (char)61;

    public static String encodeUTF8(String str) throws RuntimeException {
        return Base64.encode(str, StandardCharsets.UTF_8);
    }

    public static String encode(String str, Charset charset) throws RuntimeException {
        byte[] bytes = str.getBytes(charset);
        byte[] encoded = Base64.encode(bytes);
        return new String(encoded, StandardCharsets.US_ASCII);
    }

    public static String decodeUTF8(String str) throws RuntimeException {
        return Base64.decode(str, StandardCharsets.UTF_8);
    }

    public static String decode(String str, Charset charset) throws RuntimeException {
        byte[] bytes = str.getBytes(StandardCharsets.US_ASCII);
        byte[] decoded = Base64.decode(bytes);
        return new String(decoded, charset);
    }

    public static byte[] encode(byte[] bytes) throws RuntimeException {
        return Base64.encode(bytes, 0);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] encode(byte[] bytes, int wrapAt) throws RuntimeException {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
            byte[] byArray;
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(8192);){
                Base64.encode(inputStream, outputStream, wrapAt);
                byArray = outputStream.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected I/O error", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] decode(byte[] bytes) throws RuntimeException {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
            byte[] byArray;
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(8192);){
                Base64.decode(inputStream, outputStream);
                byArray = outputStream.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected I/O error", e);
        }
    }

    public static void encode(InputStream inputStream, OutputStream outputStream) throws IOException {
        Base64.encode(inputStream, outputStream, 0);
    }

    public static void encode(InputStream inputStream, OutputStream outputStream, int wrapAt) throws IOException {
        Base64OutputStream aux = new Base64OutputStream(outputStream, wrapAt);
        Utils.flush(inputStream, aux);
        aux.flushbuffer();
    }

    public static void decode(InputStream inputStream, OutputStream outputStream) throws IOException {
        Utils.flush(new Base64InputStream(inputStream), outputStream);
    }

    public static String encode(InputStream inputStream) throws IOException {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(8192);){
            Base64.encode(inputStream, outputStream);
            String string = outputStream.toString(StandardCharsets.US_ASCII);
            return string;
        }
    }

    public static String encodeWeb(String base64) {
        return base64.replace('+', '-').replace('/', '_');
    }

    public static String decodeWeb(String base64web) {
        return base64web.replace('-', '+').replace('_', '/');
    }
}

